/*
 * Decompiled with CFR 0.152.
 */
package cronapp.framework.authentication.security;

import java.time.OffsetDateTime;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;

public class CronappUserDetails
implements UserDetails {
    private String name;
    private String userName;
    private String normalizedUserName;
    private String email;
    private String normalizedEmail;
    private boolean emailConfirmed;
    private String password;
    private String securityStamp;
    private String phoneNumber;
    private boolean phoneNumberConfirmed;
    private boolean twoFactorEnabled;
    private OffsetDateTime lockoutEnd;
    private boolean lockoutEnabled;
    private int accessFailedCount;
    private Set<GrantedAuthority> authorities;
    private byte[] picture;
    private Map<String, Object> payload;

    protected CronappUserDetails() {
    }

    public String getName() {
        return this.name;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getNormalizedUserName() {
        return this.normalizedUserName;
    }

    public String getEmail() {
        return this.email;
    }

    public String getNormalizedEmail() {
        return this.normalizedEmail;
    }

    public boolean isEmailConfirmed() {
        return this.emailConfirmed;
    }

    public Collection<? extends GrantedAuthority> getAuthorities() {
        return Collections.unmodifiableSet(this.authorities);
    }

    public String getPassword() {
        return this.password;
    }

    public String getUsername() {
        return this.normalizedUserName;
    }

    public boolean isAccountNonExpired() {
        return true;
    }

    public boolean isAccountNonLocked() {
        return this.lockoutEnabled && this.lockoutEnd != null && this.lockoutEnd.isBefore(OffsetDateTime.now());
    }

    public boolean isCredentialsNonExpired() {
        return true;
    }

    public boolean isEnabled() {
        return true;
    }

    public String getSecurityStamp() {
        return this.securityStamp;
    }

    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    public boolean isPhoneNumberConfirmed() {
        return this.phoneNumberConfirmed;
    }

    public boolean isTwoFactorEnabled() {
        return this.twoFactorEnabled;
    }

    public OffsetDateTime getLockoutEnd() {
        return this.lockoutEnd;
    }

    public boolean isLockoutEnabled() {
        return this.lockoutEnabled;
    }

    public int getAccessFailedCount() {
        return this.accessFailedCount;
    }

    public byte[] getPicture() {
        return this.picture;
    }

    public Map<String, Object> getPayload() {
        return this.payload;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private String name;
        private String userName;
        private String normalizedUserName;
        private String email;
        private String normalizedEmail;
        private boolean emailConfirmed;
        private String password;
        private String securityStamp;
        private String phoneNumber;
        private boolean phoneNumberConfirmed;
        private boolean twoFactorEnabled;
        private OffsetDateTime lockoutEnd;
        private boolean lockoutEnabled;
        private int accessFailedCount;
        private Set<GrantedAuthority> authorities;
        private byte[] picture;
        private Map<String, Object> payload;

        private Builder() {
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setUserName(String userName) {
            this.userName = userName;
            return this;
        }

        public Builder setNormalizedUserName(String normalizedUserName) {
            this.normalizedUserName = normalizedUserName;
            return this;
        }

        public Builder setEmail(String email) {
            this.email = email;
            return this;
        }

        public Builder setNormalizedEmail(String normalizedEmail) {
            this.normalizedEmail = normalizedEmail;
            return this;
        }

        public Builder setEmailConfirmed(boolean emailConfirmed) {
            this.emailConfirmed = emailConfirmed;
            return this;
        }

        public Builder setPassword(String password) {
            this.password = password;
            return this;
        }

        public Builder setSecurityStamp(String securityStamp) {
            this.securityStamp = securityStamp;
            return this;
        }

        public Builder setPhoneNumber(String phoneNumber) {
            this.phoneNumber = phoneNumber;
            return this;
        }

        public Builder setPhoneNumberConfirmed(boolean phoneNumberConfirmed) {
            this.phoneNumberConfirmed = phoneNumberConfirmed;
            return this;
        }

        public Builder setTwoFactorEnabled(boolean twoFactorEnabled) {
            this.twoFactorEnabled = twoFactorEnabled;
            return this;
        }

        public Builder setLockoutEnd(OffsetDateTime lockoutEnd) {
            this.lockoutEnd = lockoutEnd;
            return this;
        }

        public Builder setLockoutEnabled(boolean lockoutEnabled) {
            this.lockoutEnabled = lockoutEnabled;
            return this;
        }

        public Builder setAccessFailedCount(int accessFailedCount) {
            this.accessFailedCount = accessFailedCount;
            return this;
        }

        public Builder setAuthorities(Set<GrantedAuthority> authorities) {
            this.authorities = authorities;
            return this;
        }

        public Builder setPicture(byte[] picture) {
            this.picture = picture;
            return this;
        }

        public Builder setPayload(Map<String, Object> payload) {
            this.payload = payload;
            return this;
        }

        public CronappUserDetails build() {
            CronappUserDetails cronappUserDetails = new CronappUserDetails();
            cronappUserDetails.twoFactorEnabled = this.twoFactorEnabled;
            cronappUserDetails.normalizedEmail = this.normalizedEmail;
            cronappUserDetails.password = this.password;
            cronappUserDetails.securityStamp = this.securityStamp;
            cronappUserDetails.phoneNumberConfirmed = this.phoneNumberConfirmed;
            cronappUserDetails.phoneNumber = this.phoneNumber;
            cronappUserDetails.lockoutEnabled = this.lockoutEnabled;
            cronappUserDetails.emailConfirmed = this.emailConfirmed;
            cronappUserDetails.name = this.name;
            cronappUserDetails.accessFailedCount = this.accessFailedCount;
            cronappUserDetails.lockoutEnd = this.lockoutEnd;
            cronappUserDetails.userName = this.userName;
            cronappUserDetails.authorities = this.authorities;
            cronappUserDetails.normalizedUserName = this.normalizedUserName;
            cronappUserDetails.email = this.email;
            cronappUserDetails.picture = this.picture;
            cronappUserDetails.payload = this.payload;
            return cronappUserDetails;
        }
    }
}

