/*
 * Decompiled with CFR 0.152.
 */
package cronapp.framework.authentication.token;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import cronapi.AppConfig;
import cronapi.RestClient;
import cronapi.Var;
import cronapi.database.DatabaseQueryManager;
import cronapi.database.HistoryListener;
import cronapi.database.TransactionManager;
import cronapi.util.Operations;
import cronapp.framework.LockedUserException;
import cronapp.framework.api.ApiManager;
import cronapp.framework.api.EventsManager;
import cronapp.framework.api.response.DefaultResponse;
import cronapp.framework.authentication.external.ExternalAuthenticationConfig;
import cronapp.framework.authentication.security.CronappUserDetails;
import cronapp.framework.authentication.social.SocialConfig;
import cronapp.framework.authentication.token.AuthenticationResponse;
import cronapp.framework.authentication.token.ForbiddenException;
import cronapp.framework.authentication.token.TokenUtils;
import cronapp.framework.authentication.token.google.CaptchaVerify;
import cronapp.framework.authentication.token.google.ICaptchaVerify;
import cronapp.framework.core.CronappConfiguration;
import cronapp.framework.core.CronappSettingsService;
import cronapp.framework.i18n.Messages;
import cronapp.framework.persistence.PasswordConstraintException;
import cronapp.framework.tenant.TenantComponent;
import io.jsonwebtoken.Claims;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.lang.Nullable;
import org.springframework.mobile.device.Device;
import org.springframework.security.authentication.AuthenticationServiceException;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.crypto.encrypt.Encryptors;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"auth"})
public class AuthenticationController {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String SCOPE_UPDATE_CURRENT_USER_PASSWORD = "update:current_user:password";
    private TenantComponent tenantComponent;
    private ICaptchaVerify captchaVerify = new CaptchaVerify();

    public AuthenticationController(@Nullable TenantComponent tenantComponent) {
        this.tenantComponent = tenantComponent;
    }

    @RequestMapping(method={RequestMethod.POST})
    public ResponseEntity<AuthenticationResponse> authenticationRequest(@RequestParam String username, String password, Device device, @RequestHeader(name="X-AUTH-TOKEN", required=false) String token, HttpServletRequest request) throws AuthenticationException {
        return this.auth(username, password, device, "local", token, null, request);
    }

    public ResponseEntity<AuthenticationResponse> auth(String username, String password, Device device, String provider, String authToken, JsonObject details, HttpServletRequest request) throws AuthenticationException {
        if (StringUtils.hasLength((String)authToken)) {
            String localProvider = TokenUtils.getProviderFromToken(authToken);
            if (provider != null && !"local".equals(localProvider) && username.equals("#OAUTH#")) {
                username = TokenUtils.getUsernameFromToken(authToken);
                provider = localProvider;
            }
        }
        boolean isOauth = !"local".equals(provider);
        boolean autoSignUp = false;
        boolean externalAuthenticationSuccess = false;
        CronappUserDetails externalUserDetails = null;
        if (ExternalAuthenticationConfig.isExternalAuth()) {
            Authentication externalToken = ExternalAuthenticationConfig.authenticateExternally((Authentication)new UsernamePasswordAuthenticationToken((Object)username, (Object)password));
            provider = ExternalAuthenticationConfig.getExternalAuthType();
            externalAuthenticationSuccess = true;
            autoSignUp = AppConfig.autoSignUp();
            if (externalToken.getPrincipal() instanceof CronappUserDetails) {
                externalUserDetails = (CronappUserDetails)externalToken.getPrincipal();
            }
        } else if (ExternalAuthenticationConfig.isSocial(provider)) {
            autoSignUp = SocialConfig.isAutoSignUp();
        } else if ("SSO".equalsIgnoreCase(provider)) {
            autoSignUp = AppConfig.autoSignUp();
        }
        ApiManager apiManager = ApiManager.byUserAndPassword(username, password, provider, autoSignUp, details);
        cronapp.framework.api.User userNoPassword = null;
        try {
            userNoPassword = ApiManager.byUser(username).getUser();
            if (ApiManager.isUserLocked(userNoPassword)) {
                this.doLogAuthOperation("Fail", "auth", username, Arrays.asList("Reason", "UserLocked"));
                throw new LockedUserException(Messages.getString("UserLocked"));
            }
            this.verifyRecaptcha(username, request);
            cronapp.framework.api.User user = apiManager.getUser(externalUserDetails);
            if (user == null) {
                this.doLogAuthOperation("Fail", "auth", username, Arrays.asList("Reason", "UserNotFound"));
                throw new UsernameNotFoundException(Messages.getString("UserNotFound"));
            }
            if (ExternalAuthenticationConfig.isExternalAuth() && !isOauth && !externalAuthenticationSuccess) {
                this.doLogAuthOperation("Fail", "auth", username, Arrays.asList("Reason", "UserOrPassordInvalids"));
                throw new BadCredentialsException(Messages.getString("UserOrPassordInvalids"));
            }
            if (!(ExternalAuthenticationConfig.isExternalAuth() || isOauth || apiManager.passwordMatches(password, user.getPassword()))) {
                this.doLogAuthOperation("Fail", "auth", username, Arrays.asList("Reason", "UserOrPassordInvalids"));
                throw new BadCredentialsException(Messages.getString("UserOrPassordInvalids"));
            }
            Collection<Object> authorities = StringUtils.hasLength((String)authToken) ? (Collection)TokenUtils.getAuthoritiesFromToken(authToken).stream().map(SimpleGrantedAuthority::new).collect(Collectors.toSet()) : (externalUserDetails == null ? apiManager.getAuthorities() : externalUserDetails.getAuthorities());
            if (!AppConfig.isNull((JsonElement)details) && !AppConfig.isNull((JsonElement)details.get("authorities"))) {
                ArrayList mergedList = new ArrayList();
                authorities.forEach(s -> mergedList.add(s.getAuthority()));
                JsonArray authoritiesList = details.get("authorities").getAsJsonArray();
                authoritiesList.forEach(a -> {
                    String role = a.getAsJsonObject().get("role").getAsString();
                    if (!mergedList.contains(role)) {
                        mergedList.add(role);
                    }
                });
                authorities = AuthorityUtils.commaSeparatedStringToAuthorityList((String)StringUtils.collectionToCommaDelimitedString(mergedList));
            }
            User userDetails = new User(username, "password", true, true, true, true, authorities);
            SecurityContextHolder.getContext().setAuthentication((Authentication)new UsernamePasswordAuthenticationToken((Object)userDetails, (Object)"password", authorities));
            StringJoiner roles = new StringJoiner(",");
            roles.add("Public");
            roles.add("Authenticated");
            boolean root = false;
            for (GrantedAuthority grantedAuthority : authorities) {
                if (grantedAuthority.getAuthority().equals("Public") || grantedAuthority.getAuthority().equals("Authenticated")) continue;
                roles.add(grantedAuthority.getAuthority());
                if (!grantedAuthority.getAuthority().equalsIgnoreCase("Administrators")) continue;
                root = true;
            }
            if (this.tenantComponent != null) {
                this.tenantComponent.authenticationTenant(user.getUsername());
            }
            cronapp.framework.api.User userWithoutPass = user.resetPassword();
            if (EventsManager.hasEvent("onLogin") && EventsManager.getEvent("onLogin").get("type").getAsString().equalsIgnoreCase("server")) {
                EventsManager.executeEventOnTransaction("onLogin", Var.valueOf((String)"username", (Object)username));
            }
            String string = TokenUtils.generateToken((UserDetails)userDetails, user.getName(), device, provider);
            Date expires = TokenUtils.getExpirationDateFromToken(string);
            ApiManager.unlockUser(user);
            this.doLogAuthOperation("Success", "auth", username, Arrays.asList("Roles", roles.toString()));
            return ResponseEntity.ok((Object)new AuthenticationResponse(userWithoutPass, string, expires.getTime(), roles.toString(), root));
        }
        catch (Exception e) {
            this.logger.error(Messages.getString("AuthError", e.getMessage()), (Throwable)e);
            ApiManager.attemptFailed(userNoPassword);
            if (!ApiManager.isUserLocked(userNoPassword) && ApiManager.getFailedAttempts(userNoPassword) > AppConfig.getFailedAttempts()) {
                ApiManager.lockUser(userNoPassword);
                this.doLogAuthOperation("Fail", "auth", username, Arrays.asList("Reason", "UserLocked10Min"));
                throw new AuthenticationServiceException(Messages.getString("UserLocked10Min"));
            }
            this.doLogAuthOperation("Fail", "auth", username, Arrays.asList("Reason", e.getMessage()));
            throw new AuthenticationServiceException(Messages.getString("AuthError", e.getMessage()));
        }
    }

    @RequestMapping(value={"refresh"}, method={RequestMethod.GET})
    public ResponseEntity<?> authenticationRequest(HttpServletRequest request) {
        Date expires;
        String tokenHeader = "X-AUTH-TOKEN";
        String token = request.getHeader(tokenHeader);
        if (!TokenUtils.canTokenBeRefreshed(token, expires = TokenUtils.getExpirationDateFromToken(token)) || !TokenUtils.getScopeFromToken(token).isEmpty()) {
            return ResponseEntity.badRequest().body(null);
        }
        String refreshedToken = TokenUtils.refreshToken(token);
        expires = TokenUtils.getExpirationDateFromToken(token);
        String username = TokenUtils.getUsernameFromToken(token);
        String name = TokenUtils.getNameFromToken(token);
        if (name == null || "".equals(name)) {
            name = username;
        }
        ApiManager apiManager = ApiManager.byUser(username);
        StringJoiner roles = new StringJoiner(",");
        roles.add("Public");
        roles.add("Authenticated");
        boolean root = false;
        if (ExternalAuthenticationConfig.isExternalAuth() || ExternalAuthenticationConfig.getExternalAuthType().equalsIgnoreCase("SSO")) {
            roles = new StringJoiner(",");
            List<String> authoritiesFromToken = TokenUtils.getAuthoritiesFromToken(token);
            authoritiesFromToken.forEach(roles::add);
            root = authoritiesFromToken.stream().filter(a -> a.equalsIgnoreCase("Administrators")).findFirst().isPresent();
        } else {
            for (GrantedAuthority role : apiManager.getAuthorities()) {
                roles.add(role.getAuthority());
                if (!role.getAuthority().equalsIgnoreCase("Administrators")) continue;
                root = true;
            }
        }
        cronapp.framework.api.User userWithoutPass = new cronapp.framework.api.User(name, username);
        AuthenticationResponse authenticationResponse = new AuthenticationResponse(userWithoutPass, refreshedToken, expires.getTime(), roles.toString(), root);
        return ResponseEntity.ok((Object)authenticationResponse);
    }

    private void verifyRecaptcha(String username, HttpServletRequest request) {
        try {
            Assert.isTrue((boolean)this.captchaVerify.processRequest(username, request), (String)"");
        }
        catch (Exception e) {
            this.logger.error(Messages.getString("AuthError", e.getMessage()), (Throwable)e);
            throw new AuthenticationServiceException(Messages.getString("AuthError", e.getMessage()));
        }
    }

    private void doLogAuthOperation(String type, String command, String user, List<String> params) {
        try {
            DatabaseQueryManager logManager = HistoryListener.getAuditLogManager();
            if (logManager != null) {
                String className = logManager.getEntity();
                Class<?> c = Class.forName(className);
                TransactionManager.begin(c);
                JsonObject json = new JsonObject();
                JsonArray arrayParams = new JsonArray();
                json.add("parameters", (JsonElement)arrayParams);
                for (String p : params) {
                    arrayParams.add(p);
                }
                Var auditLog = new Var(new LinkedHashMap());
                auditLog.set("type", (Object)("app.authorization." + type));
                auditLog.set("command", (Object)command);
                auditLog.set("category", (Object)"Authorization");
                auditLog.set("date", (Object)new Date());
                auditLog.set("objectData", (Object)json.toString());
                if (RestClient.getRestClient() != null) {
                    auditLog.set("user", (Object)user);
                    auditLog.set("host", (Object)RestClient.getRestClient().getHost());
                    auditLog.set("agent", (Object)RestClient.getRestClient().getAgent());
                }
                auditLog.set("server", (Object)HistoryListener.CURRENT_IP);
                auditLog.set("affectedFields", null);
                auditLog.set("application", (Object)AppConfig.guid());
                logManager.insert((Object)auditLog, new Object[0]);
                TransactionManager.commit(c);
            }
        }
        catch (Exception e) {
            this.logger.error("Error on logging: " + e.getMessage());
        }
    }

    @PostMapping(value={"reset-password"})
    public ResponseEntity<String> resetPassword(@RequestParam(value="email") String email) {
        try {
            cronapp.framework.api.User user = ApiManager.byUser(email).getUser();
            HashMap<String, Object> claims = new HashMap<String, Object>();
            claims.put("sub", user.getUsername());
            claims.put("scope", SCOPE_UPDATE_CURRENT_USER_PASSWORD);
            String token = TokenUtils.generateToken(claims, TokenUtils.generateExpirationDate());
            Operations.callBlockly((Var)Var.valueOf((Object)"UserManager:sendResetPasswordEmail"), (Var[])new Var[]{Var.valueOf((Object)user.getEmail()), Var.valueOf((Object)user.getName()), Var.valueOf((Object)token)});
        }
        catch (Exception e) {
            this.logger.error(Messages.getString("AuthError", e.getMessage()), (Throwable)e);
        }
        return new ResponseEntity((Object)"{}", HttpStatus.OK);
    }

    @PostMapping(value={"confirm-reset-password"})
    public void confirmResetPassword(@RequestParam(value="password") String password, @RequestParam(value="otp", required=false) String otp, @RequestHeader(value="X-AUTH-TOKEN") String authToken) {
        if (TokenUtils.isTokenExpired(authToken)) {
            throw new ForbiddenException(Messages.getString("ResetPasswordTokenExpired"));
        }
        String username = TokenUtils.getUsernameFromToken(authToken);
        List<String> scopes = TokenUtils.getScopeFromToken(authToken);
        Claims claims = TokenUtils.getClaimsFromToken(authToken);
        if (username == null || !scopes.contains(SCOPE_UPDATE_CURRENT_USER_PASSWORD)) {
            throw new ForbiddenException(Messages.getString("UserOrPassordInvalids"));
        }
        CronappSettingsService settingsService = (CronappSettingsService)CronappConfiguration.getBean(CronappSettingsService.class);
        if (otp != null) {
            String encryptedOneTimePassword = String.valueOf(claims.get((Object)"otp"));
            String decryptedOneTimePassword = Encryptors.text((CharSequence)settingsService.getEncryptionKey(), (CharSequence)settingsService.getEncryptionSalt()).decrypt(encryptedOneTimePassword);
            if (encryptedOneTimePassword != null && !decryptedOneTimePassword.equals(otp)) {
                throw new ForbiddenException(Messages.getString("InvalidOTP"));
            }
        }
        if (EventsManager.hasEvent("onResetPassword")) {
            EventsManager.executeEventOnTransaction("onResetPassword", Var.valueOf((Object)username), Var.valueOf((Object)password));
            return;
        }
        ApiManager manager = ApiManager.byUser(username);
        try {
            manager.updatePassword(password);
        }
        catch (Exception e) {
            PasswordConstraintException passwordConstraintException = PasswordConstraintException.unwrap(e);
            if (passwordConstraintException != null) {
                throw passwordConstraintException;
            }
            throw new AuthenticationServiceException(Messages.getString("AuthError", e.getMessage()));
        }
    }

    @PostMapping(value={"signup"})
    public ResponseEntity<DefaultResponse> signUp(@RequestBody Var fields) {
        DefaultResponse defaultResponse = new DefaultResponse();
        Boolean avaliableSignup = AppConfig.getIfRegistrationAvailable();
        if (!avaliableSignup.booleanValue()) {
            return new ResponseEntity((Object)defaultResponse.parseResponse(HttpStatus.FORBIDDEN.value(), Messages.getString("UserRegisterNotAvaliable")), HttpStatus.FORBIDDEN);
        }
        Map mapUser = fields.getObjectAsMap();
        if (mapUser.get("name") == null) {
            mapUser.put("name", mapUser.get("username"));
        }
        mapUser.put("normalizedUserName", mapUser.get("username"));
        mapUser.put("normalizedEmail", mapUser.get("email"));
        try {
            cronapp.framework.api.User userNoPassword = ApiManager.byUser(mapUser.get("username").toString()).getUser();
            if (userNoPassword != null) {
                return new ResponseEntity((Object)defaultResponse.parseResponse(HttpStatus.BAD_REQUEST.value(), Messages.getString("UserAlreadyExists")), HttpStatus.BAD_REQUEST);
            }
            ApiManager.createUser(fields);
        }
        catch (Exception err) {
            PasswordConstraintException passwordConstraintException = PasswordConstraintException.unwrap(err);
            if (passwordConstraintException != null) {
                throw passwordConstraintException;
            }
            return new ResponseEntity((Object)defaultResponse.parseResponse(HttpStatus.FORBIDDEN.value(), Messages.getString("AuthError", err.getMessage())), HttpStatus.FORBIDDEN);
        }
        return new ResponseEntity((Object)defaultResponse.parseResponse(HttpStatus.CREATED.value(), Messages.getString("UserRegisteredSuccessfully")), HttpStatus.CREATED);
    }
}

