/*
 * Decompiled with CFR 0.152.
 */
package cronapp.framework.authentication.token;

import cronapp.framework.api.ApiManager;
import cronapp.framework.authentication.token.TokenUtils;
import java.io.IOException;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.web.authentication.UsernamePasswordAuthenticationFilter;
import org.springframework.security.web.authentication.WebAuthenticationDetailsSource;

public class AuthenticationTokenFilter
extends UsernamePasswordAuthenticationFilter {
    private final boolean useApiManager;

    public AuthenticationTokenFilter(boolean useApiManager) {
        this.useApiManager = useApiManager;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        String authToken = httpRequest.getHeader("X-AUTH-TOKEN");
        String username = TokenUtils.getUsernameFromToken(authToken);
        if (username != null && SecurityContextHolder.getContext().getAuthentication() == null && TokenUtils.getScopeFromToken(authToken).isEmpty() && !TokenUtils.isTokenExpired(authToken)) {
            UserDetails userDetails;
            Set<Object> authorities;
            if ("local".equals(TokenUtils.getIssuerFromToken(authToken)) && this.useApiManager) {
                ApiManager apiManager = ApiManager.byUser(username);
                authorities = apiManager.getAuthorities();
                cronapp.framework.api.User user = new cronapp.framework.api.User(username);
                userDetails = new User(user.getUsername(), user.getPassword(), false, false, false, false, authorities);
            } else {
                authorities = TokenUtils.getAuthoritiesFromToken(authToken).stream().map(SimpleGrantedAuthority::new).collect(Collectors.toSet());
                userDetails = User.withUsername((String)username).password("").authorities(authorities).build();
            }
            UsernamePasswordAuthenticationToken authentication = new UsernamePasswordAuthenticationToken((Object)userDetails, null, authorities);
            authentication.setDetails((Object)new WebAuthenticationDetailsSource().buildDetails(httpRequest));
            SecurityContextHolder.getContext().setAuthentication((Authentication)authentication);
        }
        chain.doFilter((ServletRequest)httpRequest, response);
    }
}

