/*
 * Decompiled with CFR 0.152.
 */
package cronapp.framework.authentication.security;

import cronapp.framework.api.ApiManager;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.security.access.AccessDecisionVoter;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.FilterInvocation;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.OrRequestMatcher;
import org.springframework.stereotype.Component;

@ConditionalOnProperty(name={"cronapp.security.authentication"}, havingValue="true", matchIfMissing=true)
@Component(value="securityInvocationVoter")
public class FilterInvocationVoter
implements AccessDecisionVoter<FilterInvocation> {
    public boolean supports(ConfigAttribute attribute) {
        return true;
    }

    public boolean supports(Class clazz) {
        return FilterInvocation.class.isAssignableFrom(clazz);
    }

    public int vote(Authentication authentication, FilterInvocation filterInvocation, Collection collection) {
        OrRequestMatcher matcher;
        List matchers = authentication.getAuthorities().stream().flatMap(authority -> ApiManager.getSecurableViews(authority.getAuthority()).stream()).map(securable -> securable.getStringField("pattern")).flatMap(pattern -> Stream.of(pattern.split(","))).distinct().map(AntPathRequestMatcher::new).collect(Collectors.toList());
        if (!matchers.isEmpty() && (matcher = new OrRequestMatcher(matchers)).matches(filterInvocation.getRequest())) {
            return 1;
        }
        return 0;
    }
}

