/*
 * Decompiled with CFR 0.152.
 */
package cronapp.framework.authentication.social;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.JsonObject;
import cronapi.RestClient;
import cronapi.util.ReflectionUtils;
import cronapp.framework.authentication.normal.AuthenticationConfigurer;
import cronapp.framework.authentication.token.AuthenticationController;
import cronapp.framework.authentication.token.AuthenticationResponse;
import java.util.Collections;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.lang.Nullable;
import org.springframework.mobile.device.LiteDeviceResolver;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.social.connect.Connection;
import org.springframework.social.connect.UserProfile;
import org.springframework.social.connect.support.OAuth2Connection;
import org.springframework.social.connect.web.SignInAdapter;
import org.springframework.stereotype.Service;
import org.springframework.web.context.request.NativeWebRequest;

@Service
public class SocialSignInAdapter
implements SignInAdapter {
    private static final Logger logger = LoggerFactory.getLogger(SocialSignInAdapter.class);
    private AuthenticationConfigurer authenticationConfigurer;
    private AuthenticationController authenticationController;
    private HttpServletRequest servletRequest;
    private HttpServletResponse servletResponse;

    public SocialSignInAdapter(HttpServletRequest servletRequest, HttpServletResponse servletResponse, @Nullable AuthenticationConfigurer authenticationConfigurer, @Nullable AuthenticationController authenticationController) {
        this.authenticationConfigurer = authenticationConfigurer;
        this.authenticationController = authenticationController;
        this.servletRequest = servletRequest;
        this.servletResponse = servletResponse;
    }

    public String signIn(String localUserId, Connection<?> connection, NativeWebRequest request) {
        logger.info("Social Sign Adaptor signIn() localUserId: " + localUserId);
        try {
            UserProfile userProfile = connection.fetchUserProfile();
            String email = userProfile.getEmail();
            if (email == null) {
                email = userProfile.getUsername();
            }
            logger.info("Social Sign Adaptor signIn() email: " + email);
            JsonObject json = new JsonObject();
            String userDisplayName = connection.getDisplayName();
            String userImageUrl = connection.getImageUrl();
            json.addProperty("name", userDisplayName);
            json.addProperty("image", userImageUrl);
            logger.info("Social Sign Adaptor signIn() name: " + userDisplayName);
            logger.info("Social Sign Adaptor signIn() image: " + userImageUrl);
            String provider = connection.getKey().getProviderId();
            UsernamePasswordAuthenticationToken auth = new UsernamePasswordAuthenticationToken((Object)email, (Object)provider, Collections.singletonList(new SimpleGrantedAuthority("#OAUTH#")));
            auth.setDetails((Object)json);
            if (connection instanceof OAuth2Connection) {
                Object accessToken = ReflectionUtils.getField(connection, (String)"accessToken");
                RestClient.getRestClient().getRequest().setAttribute("CronappToken:SSOAccessToken", accessToken);
            }
            ObjectMapper mapper = new ObjectMapper();
            Map userDetails = (Map)mapper.convertValue((Object)userProfile, Map.class);
            RestClient.getRestClient().getRequest().setAttribute("CronappToken:SSOUserDetails", (Object)userDetails);
            try {
                if (this.authenticationConfigurer == null) {
                    LiteDeviceResolver deviceResolver = new LiteDeviceResolver();
                    ResponseEntity<AuthenticationResponse> authenticationRequest = this.authenticationController.auth(email, provider, deviceResolver.resolveDevice(this.servletRequest), provider, null, json, this.servletRequest, this.servletResponse);
                    AuthenticationResponse response = (AuthenticationResponse)authenticationRequest.getBody();
                    String token = response.getToken();
                    logger.info("Social Sign Adaptor signIn() token: " + token);
                    return this.servletRequest.getContextPath() + "/#/connected?_ctk=" + token;
                }
                Authentication socialAuth = this.authenticationConfigurer.authenticate((Authentication)auth);
                SecurityContextHolder.getContext().setAuthentication(socialAuth);
                this.servletRequest.getSession().setAttribute("#OAUTH#USER", (Object)email);
            }
            catch (Exception e) {
                logger.error("Social Sign Adaptor Error: Redirect to /#/notconnected due to: ", (Throwable)e);
                return this.servletRequest.getContextPath() + "/#/notconnected";
            }
        }
        catch (Exception e) {
            logger.error("Social Sign Adaptor Error: Redirect to /#/error/403 due to: ", (Throwable)e);
            return this.servletRequest.getContextPath() + "/#/error/403";
        }
        logger.error("Social Sign Adaptor Info: Redirect to /#/connected");
        return this.servletRequest.getContextPath() + "/#/connected";
    }
}

