/*
 * Decompiled with CFR 0.152.
 */
package cronapp.framework.authentication.token;

import cronapi.CronapiBeanConfigurator;
import cronapi.Var;
import cronapp.framework.core.model.AppConfiguration;
import cronapp.framework.core.model.HttpHeader;
import cronapp.framework.i18n.Messages;
import java.io.IOException;
import java.security.Security;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.cors.CorsUtils;

public class CorsFilter
implements Filter {
    public void init(FilterConfig filterConfig) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        HttpServletResponse response = (HttpServletResponse)res;
        HttpServletRequest request = (HttpServletRequest)req;
        AppConfiguration appConfig = AppConfiguration.getInstance();
        String cors = appConfig.getCors();
        if (!cors.equals("<sameorigin>")) {
            response.setHeader("Access-Control-Allow-Origin", cors);
            response.setHeader("Access-Control-Max-Age", "3600");
        }
        response.setHeader("Access-Control-Allow-Methods", appConfig.getCorsMethods());
        response.setHeader("Access-Control-Allow-Headers", appConfig.getCorsHeaders());
        if (appConfig.getExtraHeaders() != null) {
            for (HttpHeader httpHeader : appConfig.getExtraHeaders()) {
                response.setHeader(httpHeader.getName(), httpHeader.getValue());
            }
        }
        if (CronapiBeanConfigurator.INIT_PARAMS != null) {
            for (Map.Entry entry : CronapiBeanConfigurator.INIT_PARAMS.entrySet()) {
                if (!((String)entry.getKey()).toString().startsWith("crn.header.")) continue;
                response.setHeader(((String)entry.getKey()).toString().replace("crn.header.", ""), ((Var)entry.getValue()).toString());
            }
        }
        if (System.getenv() != null) {
            for (Map.Entry entry : System.getenv().entrySet()) {
                if (!((String)entry.getKey()).toString().startsWith("CRN_HEADER_")) continue;
                response.setHeader(((String)entry.getKey()).toString().replace("CRN_HEADER_", ""), ((String)entry.getValue()).toString());
            }
        }
        if (System.getProperties() != null) {
            for (Map.Entry entry : System.getProperties().entrySet()) {
                if (!entry.getKey().toString().startsWith("crn.header.")) continue;
                response.setHeader(entry.getKey().toString().replace("crn.header.", ""), entry.getValue().toString());
            }
        }
        try {
            Messages.set(req.getLocale());
            if (CorsUtils.isPreFlightRequest((HttpServletRequest)request)) {
                response.setStatus(200);
            } else {
                chain.doFilter(req, res);
            }
        }
        finally {
            Messages.remove();
        }
    }

    public void destroy() {
    }

    static {
        Security.setProperty("keystore.type", "jks");
    }
}

