/*
 * Decompiled with CFR 0.152.
 */
package cronapp.framework.authentication.normal;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import cronapi.Var;
import cronapp.framework.api.ApiManager;
import cronapp.framework.api.EventsManager;
import cronapp.framework.authentication.AuthenticationUtil;
import cronapp.framework.authentication.normal.AuthenticationConfigurer;
import cronapp.framework.authentication.security.CronappAnonymousAuthenticationFilter;
import cronapp.framework.authentication.security.CronappLogoutSuccessHandler;
import cronapp.framework.authentication.security.Permission;
import cronapp.framework.i18n.Messages;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.StringJoiner;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.AccessDecisionManager;
import org.springframework.security.access.AccessDecisionVoter;
import org.springframework.security.access.vote.UnanimousBased;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.AuthenticationServiceException;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.config.annotation.web.configurers.FormLoginConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.authentication.AnonymousAuthenticationFilter;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.security.web.authentication.Http403ForbiddenEntryPoint;
import org.springframework.security.web.authentication.logout.LogoutSuccessHandler;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;

@Configuration
@EnableWebSecurity
public class AuthorizationConfigurer
extends WebSecurityConfigurerAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(AuthorizationConfigurer.class);
    @Autowired
    private AuthenticationConfigurer authenticationProvider;
    @Autowired(required=false)
    private Permission permission;
    @Autowired
    private List<AccessDecisionVoter<? extends Object>> decisionVoters;
    @Autowired
    private CronappLogoutSuccessHandler logoutSuccessHandler;

    protected void configure(AuthenticationManagerBuilder auth) {
        auth.authenticationProvider((AuthenticationProvider)this.authenticationProvider);
    }

    protected void configure(HttpSecurity http) throws Exception {
        http.csrf().disable();
        ((HttpSecurity)http.exceptionHandling().authenticationEntryPoint((AuthenticationEntryPoint)new Http403ForbiddenEntryPoint()).and()).sessionManagement().maximumSessions(100).maxSessionsPreventsLogin(false).and().sessionCreationPolicy(SessionCreationPolicy.IF_REQUIRED);
        if (this.permission != null) {
            AuthenticationUtil.loadStaticSecurity(http);
            this.permission.loadSecurityPermission(http);
        } else {
            http.anonymous().authenticationFilter((AnonymousAuthenticationFilter)new CronappAnonymousAuthenticationFilter("anonymousAuthenticationFilterKey", "anonymousUser", ApiManager.getPublicAuthorities()));
            ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)http.authorizeRequests().anyRequest()).denyAll().accessDecisionManager((AccessDecisionManager)new UnanimousBased(this.decisionVoters));
        }
        ((HttpSecurity)((FormLoginConfigurer)((FormLoginConfigurer)((FormLoginConfigurer)http.formLogin().loginProcessingUrl("/auth")).successHandler(this.successHandler())).failureHandler(this.failureHandler())).and()).logout().logoutRequestMatcher((RequestMatcher)new AntPathRequestMatcher("/logout")).logoutSuccessHandler((LogoutSuccessHandler)this.logoutSuccessHandler).invalidateHttpSession(true);
        http.headers().cacheControl().disable().frameOptions().disable().httpStrictTransportSecurity().disable();
    }

    private AuthenticationSuccessHandler successHandler() {
        return (request, response, authentication) -> {
            HttpSession session = request.getSession();
            User authUser = (User)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
            String username = authUser.getUsername();
            session.setAttribute("username", (Object)username);
            session.setAttribute("authorities", (Object)authentication.getAuthorities());
            response.setStatus(200);
            StringJoiner roles = new StringJoiner(",");
            roles.add("Public");
            roles.add("Authenticated");
            boolean root = false;
            for (GrantedAuthority role : authUser.getAuthorities()) {
                roles.add(role.getAuthority());
                if (!role.getAuthority().equalsIgnoreCase("Administrators")) continue;
                root = true;
            }
            try {
                cronapp.framework.api.User user = (cronapp.framework.api.User)request.getAttribute("userDetails");
                Gson gson = new Gson();
                JsonObject json = new JsonObject();
                json.add("user", gson.toJsonTree((Object)user.resetPassword()));
                json.add("picture", gson.toJsonTree((Object)user.getPicture()));
                json.addProperty("roles", roles.toString());
                json.addProperty("theme", "" + session.getAttribute("theme"));
                json.addProperty("root", Boolean.valueOf(root));
                response.getOutputStream().write(json.toString().getBytes(StandardCharsets.UTF_8));
                response.setHeader("Content-Type", "application/json;charset=UTF-8");
            }
            catch (Exception e) {
                LOGGER.error(Messages.getString("AuthError", e.getMessage()), (Throwable)e);
                throw new AuthenticationServiceException(Messages.getString("AuthError", e.getMessage()));
            }
            if (EventsManager.hasEvent("onLogin")) {
                EventsManager.executeEventOnTransaction("onLogin", Var.valueOf((String)"username", (Object)authentication.getName()));
            }
        };
    }

    private AuthenticationFailureHandler failureHandler() {
        return (request, response, failureHandler) -> {
            Object e = failureHandler;
            for (int nivel = 0; e != null && nivel < 3; e = e.getCause(), ++nivel) {
                LOGGER.error("Falha obter token OAUTH", (Object)e.getMessage(), e);
            }
            response.setStatus(HttpStatus.UNAUTHORIZED.value());
        };
    }
}

