/*
 * Decompiled with CFR 0.152.
 */
package cronapp.framework.mailer;

import cronapp.framework.core.CronappSettingsService;
import cronapp.framework.core.EntityManagerConfiguration;
import cronapp.framework.core.liquibase.CronappChangeLog;
import cronapp.framework.fs.FileSystemService;
import cronapp.framework.mailer.MailQueueRepository;
import cronapp.framework.mailer.MailerJob;
import cronapp.framework.mailer.MailerOptions;
import cronapp.framework.mailer.MailerQueueService;
import cronapp.framework.mailer.MailerService;
import cronapp.framework.mailer.MailerSimpleService;
import java.util.Properties;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.boot.autoconfigure.mail.MailSenderAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.env.Environment;
import org.springframework.data.jpa.repository.config.EnableJpaRepositories;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.JavaMailSenderImpl;

@Configuration
@ComponentScan
@EnableJpaRepositories(basePackageClasses={MailerConfiguration.class}, entityManagerFactoryRef="cronappEntityManagerFactory", transactionManagerRef="cronappTransactionManager")
@Import(value={MailSenderAutoConfiguration.class})
public class MailerConfiguration {
    private static final String PROPERTY_MAILER_USE_QUEUE = "cronapp.framework.mailer.useQueue";

    @Bean
    public EntityManagerConfiguration mailerEntityManagerConfiguration() {
        return EntityManagerConfiguration.builder().packageToScan(this.getClass().getPackage().getName()).build();
    }

    @Bean
    public JavaMailSender javaMailSender(MailerOptions options) {
        JavaMailSenderImpl sender = new JavaMailSenderImpl();
        sender.setHost(options.getHost());
        if (options.getPort() != 0) {
            sender.setPort(options.getPort());
        }
        sender.setUsername(options.getUserName());
        sender.setPassword(options.getPassword());
        sender.setProtocol(options.getProtocol());
        Properties javaMailProperties = new Properties();
        if (options.getAuth()) {
            javaMailProperties.setProperty("spring.mail.properties.mail.smtp.auth", "true");
        }
        if (options.getTls()) {
            javaMailProperties.setProperty("mail.smtp.starttls.enable", "true");
            javaMailProperties.setProperty("mail.smtp.starttls.require", "true");
        }
        if (StringUtils.isNotEmpty((CharSequence)options.getHost())) {
            javaMailProperties.setProperty("mail.smtp.ssl.trust", options.getHost());
        }
        javaMailProperties.setProperty("mail.smtp.ssl.protocols", "TLSv1.2");
        sender.setJavaMailProperties(javaMailProperties);
        sender.setDefaultEncoding("UTF-8");
        return sender;
    }

    @Bean
    public CronappChangeLog mailerLiquibaseChangelog(Environment environment) {
        if (BooleanUtils.toBoolean((String)environment.getProperty(PROPERTY_MAILER_USE_QUEUE))) {
            return CronappChangeLog.newBuilder().setDataModel("classpath:mailer-db-changes.xml").build();
        }
        return CronappChangeLog.newBuilder().build();
    }

    @Bean
    public MailerService getMailerService(Environment environment, FileSystemService fileSystem, MailerOptions options, MailQueueRepository repository, JavaMailSender sender, CronappSettingsService settings) {
        if (BooleanUtils.toBoolean((String)environment.getProperty(PROPERTY_MAILER_USE_QUEUE))) {
            return new MailerQueueService(fileSystem, options, repository, sender, settings);
        }
        return new MailerSimpleService(sender);
    }

    @Bean
    public MailerJob getMailerJob(Environment environment, MailerService mailer, MailQueueRepository repository, MailerOptions options, FileSystemService fileSystem, JavaMailSender sender, CronappSettingsService settings) {
        if (BooleanUtils.toBoolean((String)environment.getProperty(PROPERTY_MAILER_USE_QUEUE))) {
            return new MailerJob(mailer, repository, options, fileSystem, sender, settings);
        }
        return null;
    }
}

