/*
 * Decompiled with CFR 0.152.
 */
package cronapp.framework.mailer;

import cronapp.framework.core.CronappSettingsService;
import java.nio.file.Paths;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.stereotype.Component;

@Component
public class MailerOptions
implements InitializingBean {
    static final String OPTION_HOST = "cronapp.framework.mailer.host";
    static final String OPTION_USERNAME = "cronapp.framework.mailer.username";
    static final String OPTION_PASSWORD = "cronapp.framework.mailer.password";
    static final String OPTION_PROTOCOL = "cronapp.framework.mailer.protocol";
    static final String OPTION_PORT = "cronapp.framework.mailer.port";
    static final String OPTION_AUTH = "cronapp.framework.mailer.auth";
    static final String OPTION_TLS = "cronapp.framework.mailer.tls";
    static final String OPTION_STORAGE_NAME = "cronapp.framework.mailer.storage.name";
    static final String OPTION_STORAGE_PATH = "cronapp.framework.mailer.storage.path";
    static final String OPTION_SCHEDULER_EXPRESSION = "cronapp.framework.mailer.scheduler.expression";
    static final String OPTION_SCHEDULER_BATCH_SIZE = "cronapp.framework.mailer.scheduler.batchSize";
    final CronappSettingsService settingsService;

    public MailerOptions(CronappSettingsService settingsService) {
        this.settingsService = settingsService;
    }

    public void afterPropertiesSet() throws Exception {
        this.settingsService.addOption(OPTION_HOST, false);
        this.settingsService.addOption(OPTION_USERNAME, false);
        this.settingsService.addOption(OPTION_PASSWORD, true);
        this.settingsService.addOption(OPTION_PROTOCOL, false);
        this.settingsService.addOption(OPTION_PORT, false);
        this.settingsService.addOption(OPTION_AUTH, false);
        this.settingsService.addOption(OPTION_TLS, false);
        this.settingsService.addOption(OPTION_STORAGE_NAME, false);
        this.settingsService.addOption(OPTION_STORAGE_PATH, false);
        this.settingsService.addOption(OPTION_SCHEDULER_EXPRESSION, false);
        this.settingsService.addOption(OPTION_SCHEDULER_BATCH_SIZE, false);
    }

    public String getHost() {
        return this.settingsService.getOption(OPTION_HOST);
    }

    public String getUserName() {
        return this.settingsService.getOption(OPTION_USERNAME);
    }

    public String getPassword() {
        return this.settingsService.getOption(OPTION_PASSWORD);
    }

    public String getProtocol() {
        return this.settingsService.getOption(OPTION_PROTOCOL);
    }

    public int getPort() {
        return NumberUtils.toInt((String)this.settingsService.getOption(OPTION_PORT), (int)0);
    }

    public boolean getAuth() {
        return BooleanUtils.isTrue((Boolean)BooleanUtils.toBoolean((String)this.settingsService.getOption(OPTION_AUTH)));
    }

    public boolean getTls() {
        return BooleanUtils.isTrue((Boolean)BooleanUtils.toBoolean((String)this.settingsService.getOption(OPTION_TLS)));
    }

    public String getStorageName() {
        return (String)StringUtils.firstNonBlank((CharSequence[])new String[]{this.settingsService.getOption(OPTION_STORAGE_NAME), "default"});
    }

    public String getStoragePath() {
        String storagePath = this.settingsService.getOption(OPTION_STORAGE_PATH);
        if (storagePath == null) {
            return Paths.get(System.getProperty("user.home"), ".cronapp", this.settingsService.getApplicationId(), "mailer").toString();
        }
        return storagePath;
    }

    public String getSchedulerExpression() {
        return (String)StringUtils.firstNonBlank((CharSequence[])new String[]{this.settingsService.getOption(OPTION_SCHEDULER_EXPRESSION), "0 * * ? * *"});
    }

    public Integer getBatchSize() {
        return NumberUtils.toInt((String)this.settingsService.getOption(OPTION_SCHEDULER_BATCH_SIZE), (int)10);
    }
}

