/*
 * Decompiled with CFR 0.152.
 */
package cronapp.framework.tunnel;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import cronapp.framework.tunnel.TunnelException;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;

public class TunnelSession
implements Closeable {
    private static final Logger logger = Logger.getLogger(TunnelSession.class.getName());
    private static final Object downloadLock = new Object();
    private static Path ngrokBinPath;
    private static Process process;
    private final CompletableFuture<String> addressCompletion = new CompletableFuture();

    public TunnelSession(String authToken, int port) throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Path getNgrokBinPath() throws IOException {
        if (ngrokBinPath != null) {
            return ngrokBinPath;
        }
        Object object = downloadLock;
        synchronized (object) {
            String ngrokBin;
            URL ngrokDownloadUrl;
            if (ngrokBinPath != null) {
                return ngrokBinPath;
            }
            if (SystemUtils.IS_OS_LINUX) {
                ngrokDownloadUrl = new URL("https://s3.amazonaws.com/files.cronapp.io/ngrok/ngrok-stable-linux-amd64.zip");
                ngrokBin = "ngrok";
            } else if (SystemUtils.IS_OS_MAC) {
                ngrokDownloadUrl = new URL("https://s3.amazonaws.com/files.cronapp.io/ngrok/ngrok-stable-darwin-amd64.zip");
                ngrokBin = "ngrok";
            } else if (SystemUtils.IS_OS_WINDOWS) {
                ngrokDownloadUrl = new URL("https://s3.amazonaws.com/files.cronapp.io/ngrok/ngrok-stable-windows-amd64.zip");
                ngrokBin = "ngrok.exe";
            } else {
                throw new TunnelException("Operating system not supported.");
            }
            Path ngrokPath = Files.createTempDirectory("cronapp", new FileAttribute[0]);
            try (ZipInputStream zipInputStream = new ZipInputStream(ngrokDownloadUrl.openStream());){
                ZipEntry entry = zipInputStream.getNextEntry();
                while (entry != null) {
                    Path entryPath = ngrokPath.resolve(entry.getName());
                    if (entry.isDirectory()) {
                        Files.createDirectories(entryPath, new FileAttribute[0]);
                    } else {
                        Path parentPath = entryPath.getParent();
                        Files.createDirectories(parentPath, new FileAttribute[0]);
                        try (FileOutputStream outputStream = new FileOutputStream(entryPath.toFile());){
                            IOUtils.copyLarge((InputStream)zipInputStream, (OutputStream)outputStream, (long)0L, (long)entry.getSize());
                        }
                    }
                    entry = zipInputStream.getNextEntry();
                }
            }
            ngrokBinPath = ngrokPath.resolve(ngrokBin);
            if (SystemUtils.IS_OS_UNIX) {
                Files.setPosixFilePermissions(ngrokBinPath, PosixFilePermissions.fromString("rwxr--r--"));
            }
            return ngrokBinPath;
        }
    }

    private void consumeStdout() {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
            String line;
            while ((line = reader.readLine()) != null) {
                this.consumeStdoutLine(line);
            }
        }
        catch (IOException e) {
            if (!this.addressCompletion.isDone()) {
                this.addressCompletion.completeExceptionally(e);
            }
            logger.log(Level.SEVERE, "Error consuming tunnel process stdout", e);
            this.close();
        }
    }

    private boolean consumeStdoutLine(String line) {
        try {
            logger.log(Level.INFO, "Consuming stdout line: {0}", line);
            JsonObject json = new JsonParser().parse(line).getAsJsonObject();
            JsonElement msg = json.get("msg");
            if (msg != null && StringUtils.equals((CharSequence)msg.getAsString(), (CharSequence)"started tunnel")) {
                JsonElement url = json.get("url");
                if (url == null) {
                    String errorMsg = "No url found after tunnel started.";
                    logger.log(Level.SEVERE, errorMsg);
                    this.addressCompletion.completeExceptionally(new TunnelException(errorMsg));
                } else {
                    URI uri = URI.create(url.getAsString());
                    this.addressCompletion.complete(String.format("%s:%d", uri.getHost(), uri.getPort()));
                }
                return true;
            }
        }
        catch (JsonSyntaxException e) {
            logger.log(Level.SEVERE, "Error parsing tunnel process stdout", e);
        }
        return false;
    }

    @Override
    public void close() {
        process.destroy();
    }

    public CompletableFuture<String> getAddress() {
        return this.addressCompletion;
    }
}

