/*
 * Decompiled with CFR 0.152.
 */
package cronapp.framework.openapi.codegen;

import com.samskivert.mustache.Mustache;
import com.samskivert.mustache.Template;
import io.swagger.v3.oas.models.tags.Tag;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.openapitools.codegen.CliOption;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.languages.JavaClientCodegen;
import org.openapitools.codegen.model.ModelMap;
import org.openapitools.codegen.model.OperationMap;
import org.openapitools.codegen.model.OperationsMap;

public class CronapiJavaCodegen
extends JavaClientCodegen {
    public static final String BLOCK_PACKAGE = "blockPackage";
    public static final String BLOCK_PACKAGE_DESC = "package for generated blocks";
    public static final String CATEGORY_NAME = "categoryName";
    public static final String NEW_API_CLIENT_NAME = "newApiClientName";
    private String blockPackage;
    private String operationCategory;
    private boolean operationCategoryTags;

    public CronapiJavaCodegen() {
        this.invokerPackage = "cronapp.openapi.client";
        this.apiPackage = "cronapp.openapi.client.api";
        this.blockPackage = "cronapp.openapi.client.block";
        this.modelPackage = "cronapp.openapi.client.model";
        this.openApiNullable = false;
        this.cliOptions.add(CliOption.newString((String)BLOCK_PACKAGE, (String)BLOCK_PACKAGE_DESC));
        this.apiTemplateFiles.put("api_cronapp.mustache", ".java");
    }

    public void processOpts() {
        super.processOpts();
        if (this.additionalProperties.containsKey(BLOCK_PACKAGE)) {
            this.blockPackage = this.additionalProperties.get(BLOCK_PACKAGE).toString();
        }
        this.additionalProperties.put("removeTypeArguments", new RemoveTypeArgumentsLambda());
        String blocksFolder = this.sourceFolder + File.separator + this.blockPackage.replace('.', File.separatorChar);
        this.supportingFiles.add(new SupportingFile("ApiClientBlocks.mustache", blocksFolder, "ApiClientBlocks.java"));
        Object operationCategoryObject = this.openAPI.getExtensions().get("x-cronapp-operation-category");
        this.operationCategory = operationCategoryObject == null ? null : operationCategoryObject.toString();
        Object operationCategoryTagsObject = this.openAPI.getExtensions().get("x-cronapp-operation-category-tags");
        boolean bl = this.operationCategoryTags = operationCategoryTagsObject == null || BooleanUtils.toBoolean((String)operationCategoryTagsObject.toString());
        if (StringUtils.isBlank((CharSequence)this.operationCategory)) {
            this.operationCategory = this.openAPI.getInfo().getTitle();
        }
        this.additionalProperties.put("operationCategory", this.operationCategory);
        this.additionalProperties.put("operationCategoryTags", this.operationCategoryTags);
    }

    public OperationsMap postProcessOperationsWithModels(OperationsMap objs, List<ModelMap> allModels) {
        super.postProcessOperationsWithModels(objs, allModels);
        OperationMap operations = objs.getOperations();
        if (operations != null) {
            objs.put((Object)"blocksClassName", (Object)operations.getClassname().replaceAll(this.apiNameSuffix + "$", "Blocks"));
            String tagName = operations.getClassname().replaceAll(this.apiNameSuffix + "$", "");
            if (this.operationCategoryTags) {
                String tagDescription = this.openAPI.getTags().stream().map(Tag::getName).filter(name -> this.sanitizeTag((String)name).equals(tagName)).findFirst().orElse(tagName);
                objs.put((Object)CATEGORY_NAME, (Object)String.format("%s - %s", this.operationCategory, tagDescription));
            } else {
                objs.put((Object)CATEGORY_NAME, (Object)String.format(this.operationCategory, new Object[0]));
            }
        }
        return objs;
    }

    public String apiFilename(String templateName, String tag) {
        if (templateName.equals("api_cronapp.mustache")) {
            return this.blockFileFolder() + File.separator + org.openapitools.codegen.utils.StringUtils.camelize((String)(tag + "_blocks")) + ".java";
        }
        return super.apiFilename(templateName, tag);
    }

    public String blockFileFolder() {
        return (this.outputFolder + File.separator + this.sourceFolder + File.separator + this.blockPackage.replace('.', File.separatorChar)).replace('/', File.separatorChar);
    }

    public Map<String, Object> postProcessSupportingFileData(Map<String, Object> objs) {
        if (this.operationCategoryTags) {
            objs.put(CATEGORY_NAME, this.operationCategory);
            objs.put(NEW_API_CLIENT_NAME, String.format("%s - Nova Conex\u00e3o", this.operationCategory));
        } else {
            objs.put(CATEGORY_NAME, this.operationCategory);
            objs.put(NEW_API_CLIENT_NAME, "Nova Conex\u00e3o");
        }
        return super.postProcessSupportingFileData(objs);
    }

    private static class RemoveTypeArgumentsLambda
    implements Mustache.Lambda {
        private RemoveTypeArgumentsLambda() {
        }

        public void execute(Template.Fragment fragment, Writer writer) throws IOException {
            writer.write(fragment.execute().replaceAll("<[^>]++>", ""));
        }
    }
}

