/*
 * Decompiled with CFR 0.152.
 */
package cronapi.crystal.util;

import com.crystaldecisions.sdk.occa.report.application.DataDefController;
import com.crystaldecisions.sdk.occa.report.application.PrintOutputController;
import com.crystaldecisions.sdk.occa.report.application.ReportClientDocument;
import com.crystaldecisions.sdk.occa.report.data.FieldDisplayNameType;
import com.crystaldecisions.sdk.occa.report.data.Fields;
import com.crystaldecisions.sdk.occa.report.data.IParameterField;
import com.crystaldecisions.sdk.occa.report.data.IValue;
import com.crystaldecisions.sdk.occa.report.data.ParameterField;
import com.crystaldecisions.sdk.occa.report.data.ParameterFieldDiscreteValue;
import com.crystaldecisions.sdk.occa.report.data.ParameterFieldRangeValue;
import com.crystaldecisions.sdk.occa.report.data.RangeValueBoundType;
import com.crystaldecisions.sdk.occa.report.data.Values;
import com.crystaldecisions.sdk.occa.report.exportoptions.CharacterSeparatedValuesExportFormatOptions;
import com.crystaldecisions.sdk.occa.report.exportoptions.DataOnlyExcelExportFormatOptions;
import com.crystaldecisions.sdk.occa.report.exportoptions.EditableRTFExportFormatOptions;
import com.crystaldecisions.sdk.occa.report.exportoptions.ExportOptions;
import com.crystaldecisions.sdk.occa.report.exportoptions.IExportFormatOptions;
import com.crystaldecisions.sdk.occa.report.exportoptions.IExportOptions;
import com.crystaldecisions.sdk.occa.report.exportoptions.PDFExportFormatOptions;
import com.crystaldecisions.sdk.occa.report.exportoptions.RTFWordExportFormatOptions;
import com.crystaldecisions.sdk.occa.report.exportoptions.ReportExportFormat;
import com.crystaldecisions.sdk.occa.report.lib.ReportSDKException;
import com.crystaldecisions.sdk.occa.report.lib.ReportSDKExceptionBase;
import cronapi.crystal.util.ReportParameters;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class CrystalHelper {
    private CrystalHelper() {
    }

    public static void addDiscreteParameterValue(ReportClientDocument clientDoc, String reportName, String parameterName, Object newValue) throws ReportSDKException {
        DataDefController dataDefController = null;
        dataDefController = reportName.equals("") ? clientDoc.getDataDefController() : clientDoc.getSubreportController().getSubreport(reportName).getDataDefController();
        ParameterFieldDiscreteValue newDiscValue = new ParameterFieldDiscreteValue();
        newDiscValue.setValue(newValue);
        ParameterField paramField = (ParameterField)dataDefController.getDataDefinition().getParameterFields().findField(parameterName, FieldDisplayNameType.fieldName, Locale.getDefault());
        boolean multiValue = paramField.getAllowMultiValue();
        if (multiValue) {
            Values newVals = (Values)paramField.getCurrentValues().clone(true);
            newVals.add((IValue)newDiscValue);
            clientDoc.getDataDefController().getParameterFieldController().setCurrentValue(reportName, parameterName, (Object)newVals);
        } else {
            clientDoc.getDataDefController().getParameterFieldController().setCurrentValue(reportName, parameterName, newValue);
        }
    }

    public static void addDiscreteParameterValue(ReportClientDocument clientDoc, String reportName, String parameterName, Object[] newValues) throws ReportSDKException {
        clientDoc.getDataDefController().getParameterFieldController().setCurrentValues(reportName, parameterName, newValues);
    }

    public static void addDiscreteParameterValue(ReportClientDocument clientDoc, String parameterName, Object newValue) throws ReportSDKException {
        CrystalHelper.addDiscreteParameterValue(clientDoc, "", parameterName, newValue);
    }

    public static void addRangeParameterValue(ReportClientDocument clientDoc, String reportName, String parameterName, Object beginValue, Object endValue) throws ReportSDKException {
        CrystalHelper.addRangeParameterValue(clientDoc, reportName, parameterName, beginValue, RangeValueBoundType.inclusive, endValue, RangeValueBoundType.inclusive);
    }

    public static void addRangeParameterValue(ReportClientDocument clientDoc, String reportName, String parameterName, Object[] beginValues, Object[] endValues) throws ReportSDKException {
        CrystalHelper.addRangeParameterValue(clientDoc, reportName, parameterName, beginValues, RangeValueBoundType.inclusive, endValues, RangeValueBoundType.inclusive);
    }

    public static void addRangeParameterValue(ReportClientDocument clientDoc, String reportName, String parameterName, Object beginValue, RangeValueBoundType lowerBoundType, Object endValue, RangeValueBoundType upperBoundType) throws ReportSDKException {
        DataDefController dataDefController = null;
        dataDefController = reportName.equals("") ? clientDoc.getDataDefController() : clientDoc.getSubreportController().getSubreport(reportName).getDataDefController();
        ParameterFieldRangeValue newRangeValue = new ParameterFieldRangeValue();
        newRangeValue.setBeginValue(beginValue);
        newRangeValue.setLowerBoundType(lowerBoundType);
        newRangeValue.setEndValue(endValue);
        newRangeValue.setUpperBoundType(upperBoundType);
        ParameterField paramField = (ParameterField)dataDefController.getDataDefinition().getParameterFields().findField(parameterName, FieldDisplayNameType.fieldName, Locale.getDefault());
        boolean multiValue = paramField.getAllowMultiValue();
        if (multiValue) {
            Values newVals = (Values)paramField.getCurrentValues().clone(true);
            newVals.add((IValue)newRangeValue);
            clientDoc.getDataDefController().getParameterFieldController().setCurrentValue(reportName, parameterName, (Object)newVals);
        } else {
            clientDoc.getDataDefController().getParameterFieldController().setCurrentValue(reportName, parameterName, (Object)newRangeValue);
        }
    }

    public static void addRangeParameterValue(ReportClientDocument clientDoc, String reportName, String parameterName, Object[] beginValues, RangeValueBoundType lowerBoundType, Object[] endValues, RangeValueBoundType upperBoundType) throws ReportSDKException {
        Object[] newRangeValues = new ParameterFieldRangeValue[beginValues.length];
        for (int i = 0; i < beginValues.length; ++i) {
            newRangeValues[i] = new ParameterFieldRangeValue();
            newRangeValues[i].setBeginValue(beginValues[i]);
            newRangeValues[i].setLowerBoundType(lowerBoundType);
            newRangeValues[i].setEndValue(endValues[i]);
            newRangeValues[i].setUpperBoundType(upperBoundType);
        }
        clientDoc.getDataDefController().getParameterFieldController().setCurrentValues(reportName, parameterName, newRangeValues);
    }

    public static InputStream exportPDF(ReportClientDocument clientDoc) throws ReportSDKExceptionBase {
        PDFExportFormatOptions pdfOptions = new PDFExportFormatOptions();
        pdfOptions.setCreateBookmarksFromGroupTree(false);
        ExportOptions exportOptions = new ExportOptions();
        exportOptions.setExportFormatType(ReportExportFormat.PDF);
        exportOptions.setFormatOptions((IExportFormatOptions)pdfOptions);
        return CrystalHelper.export(clientDoc, exportOptions);
    }

    public static InputStream exportPDF(ReportClientDocument clientDoc, int startPage, int endPage) throws ReportSDKExceptionBase {
        PDFExportFormatOptions pdfOptions = new PDFExportFormatOptions();
        pdfOptions.setStartPageNumber(startPage);
        pdfOptions.setEndPageNumber(endPage);
        ExportOptions exportOptions = new ExportOptions();
        exportOptions.setExportFormatType(ReportExportFormat.PDF);
        exportOptions.setFormatOptions((IExportFormatOptions)pdfOptions);
        return CrystalHelper.export(clientDoc, exportOptions);
    }

    public static InputStream exportRTF(ReportClientDocument clientDoc) throws ReportSDKExceptionBase {
        RTFWordExportFormatOptions rtfOptions = new RTFWordExportFormatOptions();
        ExportOptions exportOptions = new ExportOptions();
        exportOptions.setExportFormatType(ReportExportFormat.RTF);
        exportOptions.setFormatOptions((IExportFormatOptions)rtfOptions);
        return CrystalHelper.export(clientDoc, exportOptions);
    }

    public static InputStream exportRTF(ReportClientDocument clientDoc, int startPage, int endPage) throws ReportSDKExceptionBase {
        RTFWordExportFormatOptions rtfOptions = new RTFWordExportFormatOptions();
        rtfOptions.setStartPageNumber(startPage);
        rtfOptions.setEndPageNumber(endPage);
        ExportOptions exportOptions = new ExportOptions();
        exportOptions.setExportFormatType(ReportExportFormat.RTF);
        exportOptions.setFormatOptions((IExportFormatOptions)rtfOptions);
        return CrystalHelper.export(clientDoc, exportOptions);
    }

    public static InputStream exportRTFEditable(ReportClientDocument clientDoc) throws ReportSDKExceptionBase {
        EditableRTFExportFormatOptions rtfOptions = new EditableRTFExportFormatOptions();
        ExportOptions exportOptions = new ExportOptions();
        exportOptions.setExportFormatType(ReportExportFormat.editableRTF);
        exportOptions.setFormatOptions((IExportFormatOptions)rtfOptions);
        return CrystalHelper.export(clientDoc, exportOptions);
    }

    public static InputStream exportRTFEditable(ReportClientDocument clientDoc, int startPage, int endPage) throws ReportSDKExceptionBase {
        EditableRTFExportFormatOptions rtfOptions = new EditableRTFExportFormatOptions();
        rtfOptions.setStartPageNumber(startPage);
        rtfOptions.setEndPageNumber(endPage);
        ExportOptions exportOptions = new ExportOptions();
        exportOptions.setExportFormatType(ReportExportFormat.editableRTF);
        exportOptions.setFormatOptions((IExportFormatOptions)rtfOptions);
        return CrystalHelper.export(clientDoc, exportOptions);
    }

    public static InputStream exportExcelDataOnly(ReportClientDocument clientDoc) throws ReportSDKExceptionBase {
        DataOnlyExcelExportFormatOptions excelOptions = new DataOnlyExcelExportFormatOptions();
        ExportOptions exportOptions = new ExportOptions();
        exportOptions.setExportFormatType(ReportExportFormat.recordToMSExcel);
        exportOptions.setFormatOptions((IExportFormatOptions)excelOptions);
        return CrystalHelper.export(clientDoc, exportOptions);
    }

    public static InputStream exportCSV(ReportClientDocument clientDoc) throws ReportSDKExceptionBase {
        CharacterSeparatedValuesExportFormatOptions csvOptions = new CharacterSeparatedValuesExportFormatOptions();
        ExportOptions exportOptions = new ExportOptions();
        exportOptions.setExportFormatType(ReportExportFormat.characterSeparatedValues);
        exportOptions.setFormatOptions((IExportFormatOptions)csvOptions);
        return CrystalHelper.export(clientDoc, exportOptions);
    }

    public static InputStream exportTXT(ReportClientDocument clientDoc) throws ReportSDKExceptionBase {
        CharacterSeparatedValuesExportFormatOptions txtOptions = new CharacterSeparatedValuesExportFormatOptions();
        txtOptions.setSeparator("\t");
        txtOptions.setDelimiter("");
        ExportOptions exportOptions = new ExportOptions();
        exportOptions.setExportFormatType(ReportExportFormat.characterSeparatedValues);
        exportOptions.setFormatOptions((IExportFormatOptions)txtOptions);
        return CrystalHelper.export(clientDoc, exportOptions);
    }

    private static InputStream export(ReportClientDocument clientDoc, ExportOptions exportOptions) throws ReportSDKExceptionBase {
        PrintOutputController printOutputController = clientDoc.getPrintOutputController();
        return printOutputController.export((IExportOptions)exportOptions);
    }

    public static InputStream export(ReportClientDocument clientDoc, String format, Map<String, Object> parameters) throws ReportSDKExceptionBase {
        CrystalHelper.setDocumentParameters(clientDoc, parameters);
        if (format.contains("RTF")) {
            return CrystalHelper.exportRTF(clientDoc);
        }
        if (format.contains("CSV")) {
            return CrystalHelper.exportCSV(clientDoc);
        }
        if (format.contains("MSExcel")) {
            return CrystalHelper.exportExcelDataOnly(clientDoc);
        }
        if (format.contains("TXT")) {
            return CrystalHelper.exportTXT(clientDoc);
        }
        return CrystalHelper.exportPDF(clientDoc);
    }

    public static List<ReportParameters> getParameters(String documentPath) throws ReportSDKException {
        return CrystalHelper.getParameters(CrystalHelper.getDocument(documentPath));
    }

    public static List<ReportParameters> getParameters(ReportClientDocument document) throws ReportSDKException {
        DataDefController dataDefController = document.getDataDefController();
        Fields fields = dataDefController.getDataDefinition().getParameterFields();
        ArrayList<ReportParameters> reportParametersList = new ArrayList<ReportParameters>();
        for (IParameterField field : fields) {
            ReportParameters reportParameters = new ReportParameters().setParameter(field.getName()).setDescription(field.getDescription()).setType(field.getType().toString());
            if (field.getDefaultValues() != null) {
                for (IValue value : field.getDefaultValues()) {
                    reportParameters.addDefaultValue(((ParameterFieldDiscreteValue)value).getValue());
                }
            }
            reportParametersList.add(reportParameters);
        }
        return reportParametersList;
    }

    public static ReportClientDocument getDocument(String documentPath) throws ReportSDKException {
        ReportClientDocument document = new ReportClientDocument();
        document.open((Object)documentPath, 0);
        return document;
    }

    public static void setDocumentParameters(ReportClientDocument document, Map<String, Object> parameters) {
        if (parameters != null) {
            parameters.forEach((key, value) -> {
                try {
                    CrystalHelper.addDiscreteParameterValue(document, key, value);
                }
                catch (ReportSDKException e) {
                    e.printStackTrace();
                }
            });
        }
    }
}

