/*
 * Decompiled with CFR 0.152.
 */
package cronapp.framework.mongodb;

import com.google.gson.JsonArray;
import com.google.gson.JsonParser;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.UpdateOptions;
import com.mongodb.client.result.DeleteResult;
import com.mongodb.client.result.UpdateResult;
import cronapi.CronapiMetaData;
import cronapi.Var;
import org.bson.Document;
import org.bson.conversions.Bson;

@CronapiMetaData
public final class Operations {
    @CronapiMetaData
    public static Var find(Var uriConnection, Var database, Var collection, Var filter) {
        try (MongoClient mongoClient = MongoClients.create((String)uriConnection.getObjectAsString());){
            MongoDatabase mongoDatabase = mongoClient.getDatabase(database.getObjectAsString());
            MongoCollection mongoCollection = mongoDatabase.getCollection(collection.getObjectAsString());
            JsonParser parser = new JsonParser();
            JsonArray array = new JsonArray();
            Document mongoFilter = null;
            FindIterable documents = null;
            if (filter != null && !filter.isEmpty().booleanValue()) {
                mongoFilter = Document.parse((String)filter.getObjectAsString());
                documents = mongoCollection.find((Bson)mongoFilter);
            } else {
                documents = mongoCollection.find();
            }
            documents.forEach(da -> array.add(parser.parse(da.toJson())));
            Var var = Var.valueOf((Object)array);
            return var;
        }
    }

    @CronapiMetaData
    public static Var insert(Var uriConnection, Var database, Var collection, Var jsonDocument) {
        try (MongoClient mongoClient = MongoClients.create((String)uriConnection.getObjectAsString());){
            MongoDatabase mongoDatabase = mongoClient.getDatabase(database.getObjectAsString());
            MongoCollection mongoCollection = mongoDatabase.getCollection(collection.getObjectAsString());
            Document document = Document.parse((String)jsonDocument.getObjectAsString());
            mongoCollection.insertOne((Object)document);
            Object id = document.get((Object)"_id");
            Var var = Var.valueOf((Object)id);
            return var;
        }
    }

    @CronapiMetaData
    public static Var update(Var uriConnection, Var database, Var collection, Var filter, Var jsonDocument) {
        try (MongoClient mongoClient = MongoClients.create((String)uriConnection.getObjectAsString());){
            MongoDatabase mongoDatabase = mongoClient.getDatabase(database.getObjectAsString());
            MongoCollection mongoCollection = mongoDatabase.getCollection(collection.getObjectAsString());
            Document mongoFilter = Document.parse((String)filter.getObjectAsString());
            Document updateDocument = Document.parse((String)jsonDocument.getObjectAsString());
            UpdateOptions options = new UpdateOptions().upsert(true);
            UpdateResult result = mongoCollection.updateOne((Bson)mongoFilter, (Bson)updateDocument, options);
            Var var = Var.valueOf((Object)result.getModifiedCount());
            return var;
        }
    }

    @CronapiMetaData
    public static Var delete(Var uriConnection, Var database, Var collection, Var filter) {
        try (MongoClient mongoClient = MongoClients.create((String)uriConnection.getObjectAsString());){
            MongoDatabase mongoDatabase = mongoClient.getDatabase(database.getObjectAsString());
            MongoCollection mongoCollection = mongoDatabase.getCollection(collection.getObjectAsString());
            Document mongoFilter = Document.parse((String)filter.getObjectAsString());
            DeleteResult result = mongoCollection.deleteOne((Bson)mongoFilter);
            Var var = Var.valueOf((Object)result.getDeletedCount());
            return var;
        }
    }
}

