/*
 * Decompiled with CFR 0.152.
 */
package cronapp.reports.j4c.export;

import cronapp.reports.j4c.J4CObject;
import cronapp.reports.j4c.commons.J4CConstants;
import cronapp.reports.j4c.commons.J4CDatasetType;
import cronapp.reports.j4c.dataset.J4CDataset;
import cronapp.reports.j4c.export.J4CExport;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.Connection;
import java.util.Base64;
import java.util.Map;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JasperCompileManager;
import net.sf.jasperreports.engine.JasperExportManager;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.data.JRBeanCollectionDataSource;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.xml.JRXmlLoader;

public class Base64Export
implements J4CExport<String> {
    private final J4CObject j4CObject;
    private final Connection connection;

    Base64Export(J4CObject j4CObject, Connection connection) {
        this.j4CObject = j4CObject;
        this.connection = connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String get() throws Exception {
        File temporaryFile = null;
        try {
            try {
                temporaryFile = File.createTempFile(J4CConstants.TEMPORARY_PDF_NAME, ".pdf");
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            FileOutputStream outputStream = new FileOutputStream(temporaryFile);
            String xml = this.j4CObject.build().toJrxml(this.connection).get();
            ByteArrayInputStream contentStream = new ByteArrayInputStream(xml.getBytes(StandardCharsets.UTF_8));
            JasperDesign jasperDesign = JRXmlLoader.load((InputStream)contentStream);
            JasperReport jasperReport = JasperCompileManager.compileReport((JasperDesign)jasperDesign);
            J4CDataset dataset = this.j4CObject.dataset();
            J4CDatasetType datasetType = dataset.getDatasetType();
            Map<String, Object> parameterValues = this.j4CObject.getParametersValue();
            if (J4CDatasetType.COLLECTION.equals((Object)datasetType)) {
                JRBeanCollectionDataSource dataSource = new JRBeanCollectionDataSource(dataset.getCollection());
                JasperPrint jasperPrint = JasperFillManager.fillReport((JasperReport)jasperReport, parameterValues, (JRDataSource)dataSource);
                JasperExportManager.exportReportToPdfStream((JasperPrint)jasperPrint, (OutputStream)outputStream);
            } else if (J4CDatasetType.DATASOURCE.equals((Object)datasetType)) {
                JasperPrint jasperPrint = this.connection == null ? JasperFillManager.fillReport((JasperReport)jasperReport, parameterValues) : JasperFillManager.fillReport((JasperReport)jasperReport, parameterValues, (Connection)this.connection);
                JasperExportManager.exportReportToPdfStream((JasperPrint)jasperPrint, (OutputStream)outputStream);
            }
            Path path = Paths.get(temporaryFile.getAbsolutePath(), new String[0]);
            String string = Base64.getEncoder().encodeToString(Files.readAllBytes(path));
            return string;
        }
        finally {
            if (temporaryFile != null && temporaryFile.exists()) {
                temporaryFile.delete();
            }
        }
    }
}

