/*
 * Decompiled with CFR 0.152.
 */
package cronapp.reports;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import cronapp.reports.commons.Functions;
import cronapp.reports.commons.GsonSingleton;
import cronapp.reports.j4c.dataset.J4CDataset;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ReportDataset {
    private final String name;
    private J4CDataset j4CDataset;
    private boolean main;

    public ReportDataset() {
        this.name = "main-dataset";
        this.j4CDataset = new J4CDataset();
        this.main = true;
    }

    public ReportDataset(String name) {
        this.name = name;
        this.j4CDataset = new J4CDataset();
        this.main = true;
    }

    public ReportDataset(String name, J4CDataset j4CDataset, boolean main) {
        this.name = name;
        this.j4CDataset = j4CDataset;
        this.main = main;
    }

    public String getName() {
        return this.name;
    }

    public J4CDataset getJ4CDataset() {
        return this.j4CDataset;
    }

    public void setJ4CDataset(J4CDataset j4CDataset) {
        this.j4CDataset = j4CDataset;
    }

    public void setMain(boolean main) {
        this.main = main;
    }

    public boolean isMain() {
        return this.main;
    }

    public static List<ReportDataset> listFromJson(String json) {
        if (!Functions.isExists(json)) {
            return new ArrayList<ReportDataset>();
        }
        Gson gson = (Gson)GsonSingleton.INSTANCE.get();
        Type type = new TypeToken<Collection<ReportDataset>>(){}.getType();
        return (List)gson.fromJson(json, type);
    }

    public static String toJson(List<ReportDataset> datasets) {
        if (datasets == null || datasets.isEmpty()) {
            return "";
        }
        Gson gson = (Gson)GsonSingleton.INSTANCE.get();
        return gson.toJson(datasets);
    }

    public static ReportDataset getMain(List<ReportDataset> datasets) {
        if (datasets.isEmpty()) {
            return new ReportDataset();
        }
        return datasets.stream().filter(ReportDataset::isMain).findFirst().orElse(null);
    }
}

