/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.core.edm.provider;

import org.apache.olingo.odata2.api.edm.EdmAnnotatable;
import org.apache.olingo.odata2.api.edm.EdmAnnotations;
import org.apache.olingo.odata2.api.edm.EdmAssociation;
import org.apache.olingo.odata2.api.edm.EdmAssociationSet;
import org.apache.olingo.odata2.api.edm.EdmAssociationSetEnd;
import org.apache.olingo.odata2.api.edm.EdmEntityContainer;
import org.apache.olingo.odata2.api.edm.EdmEntitySet;
import org.apache.olingo.odata2.api.edm.EdmException;
import org.apache.olingo.odata2.api.edm.provider.AssociationSet;
import org.apache.olingo.odata2.api.edm.provider.AssociationSetEnd;
import org.apache.olingo.odata2.core.edm.provider.EdmAnnotationsImplProv;
import org.apache.olingo.odata2.core.edm.provider.EdmAssociationSetEndImplProv;
import org.apache.olingo.odata2.core.edm.provider.EdmImplProv;
import org.apache.olingo.odata2.core.edm.provider.EdmNamedImplProv;

public class EdmAssociationSetImplProv
extends EdmNamedImplProv
implements EdmAssociationSet,
EdmAnnotatable {
    private AssociationSet associationSet;
    private EdmEntityContainer edmEntityContainer;
    private EdmAnnotations annotations;

    public EdmAssociationSetImplProv(EdmImplProv edm, AssociationSet associationSet, EdmEntityContainer edmEntityContainer) throws EdmException {
        super(edm, associationSet.getName());
        this.associationSet = associationSet;
        this.edmEntityContainer = edmEntityContainer;
    }

    public EdmAssociation getAssociation() throws EdmException {
        EdmAssociation association = this.edm.getAssociation(this.associationSet.getAssociation().getNamespace(), this.associationSet.getAssociation().getName());
        if (association == null) {
            throw new EdmException(EdmException.COMMON);
        }
        return association;
    }

    public EdmAssociationSetEnd getEnd(String role) throws EdmException {
        AssociationSetEnd end;
        if (this.associationSet.getEnd1().getRole().equals(role)) {
            end = this.associationSet.getEnd1();
        } else if (this.associationSet.getEnd2().getRole().equals(role)) {
            end = this.associationSet.getEnd2();
        } else {
            return null;
        }
        EdmEntitySet entitySet = this.edmEntityContainer.getEntitySet(end.getEntitySet());
        if (entitySet == null) {
            throw new EdmException(EdmException.COMMON);
        }
        return new EdmAssociationSetEndImplProv(end, entitySet);
    }

    public EdmEntityContainer getEntityContainer() throws EdmException {
        return this.edmEntityContainer;
    }

    public EdmAnnotations getAnnotations() throws EdmException {
        if (this.annotations == null) {
            this.annotations = new EdmAnnotationsImplProv(this.associationSet.getAnnotationAttributes(), this.associationSet.getAnnotationElements());
        }
        return this.annotations;
    }
}

