/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.core.uri.expression;

import java.util.ArrayList;
import java.util.List;
import org.apache.olingo.odata2.api.edm.EdmSimpleType;
import org.apache.olingo.odata2.api.edm.EdmType;
import org.apache.olingo.odata2.api.edm.EdmTypeKind;
import org.apache.olingo.odata2.core.uri.expression.ExpressionParserInternalError;

public class ParameterSet {
    private EdmType returnType = null;
    public ArrayList<EdmSimpleType> types = new ArrayList();
    private EdmSimpleType furtherType = null;

    public ParameterSet(EdmType returnType, EdmSimpleType type1) {
        this.returnType = returnType;
        this.types.add(type1);
    }

    public ParameterSet(EdmSimpleType returnType, EdmSimpleType type1, EdmSimpleType type2) {
        this.returnType = returnType;
        this.types.add(type1);
        this.types.add(type2);
    }

    public ParameterSet(EdmSimpleType returnType, EdmSimpleType type1, EdmSimpleType type2, EdmSimpleType type3) {
        this.returnType = returnType;
        this.types.add(type1);
        this.types.add(type2);
        this.types.add(type3);
    }

    public EdmType getReturnType() {
        return this.returnType;
    }

    public EdmSimpleType getFurtherType() {
        return this.furtherType;
    }

    public ParameterSet setFurtherType(EdmSimpleType furtherType) {
        this.furtherType = furtherType;
        return this;
    }

    public boolean equals(List<EdmType> actualParameterTypes, boolean allowPromotion) throws ExpressionParserInternalError {
        int paramSize;
        int actSize = actualParameterTypes.size();
        if (actSize < (paramSize = this.types.size())) {
            return false;
        }
        if (actSize > paramSize && this.furtherType == null) {
            return false;
        }
        for (int i = 0; i < actSize; ++i) {
            EdmType actType = actualParameterTypes.get(i);
            if (actType == null) {
                return false;
            }
            EdmSimpleType paramType = null;
            paramType = i < paramSize ? this.types.get(i) : this.furtherType;
            if (actType.equals(paramType)) continue;
            if (!allowPromotion) {
                return false;
            }
            if (actType.getKind() != EdmTypeKind.SIMPLE) {
                return false;
            }
            if (paramType.isCompatible((EdmSimpleType)actType)) continue;
            return false;
        }
        return true;
    }
}

