/*
 * Decompiled with CFR 0.152.
 */
package cronapi;

import com.mifmif.common.regex.Generex;
import cronapi.CronapiMetaData;
import cronapi.ParamMetaData;
import cronapi.Var;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URL;
import java.util.Base64;
import javax.imageio.ImageIO;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;
import javax.xml.bind.DatatypeConverter;
import org.json.JSONException;
import org.json.JSONObject;

@CronapiMetaData(categoryName="PIX")
public class GerencianetPix {
    @CronapiMetaData(type="function", name="{{generateToken}}", description="{{generateTokenDesc}}", params={"{{environment}}: {{environmentDesc}}.", "{{clientId}}: {{clientIdDesc}}", "{{clientSecret}}: {{clientSecretDesc}}", "{{certificate}}: {{certificateDesc}}"}, paramsType={CronapiMetaData.ObjectType.STRING, CronapiMetaData.ObjectType.STRING, CronapiMetaData.ObjectType.STRING, CronapiMetaData.ObjectType.STRING}, returnType=CronapiMetaData.ObjectType.STRING)
    public static String generateToken(@ParamMetaData(blockType="util_dropdown", keys={"DEVELOPMENT", "PRODUCTION"}, values={"{{development}}", "{{production}}"}) Var environment, Var client_id, Var client_secret, Var path_certificate) throws Exception {
        String token = "";
        String basicAuth = Base64.getEncoder().encodeToString((client_id.getObjectAsString() + ":" + client_secret.getObjectAsString()).getBytes());
        try {
            String response;
            System.setProperty("javax.net.ssl.keyStore", path_certificate.getObjectAsString());
            SSLSocketFactory sslsocketfactory = (SSLSocketFactory)SSLSocketFactory.getDefault();
            URL url = new URL(GerencianetPix.getEnvironmentUrl(environment.getObjectAsString()) + "/oauth/token");
            HttpsURLConnection conn = (HttpsURLConnection)url.openConnection();
            conn.setDoOutput(true);
            conn.setRequestMethod("POST");
            conn.setRequestProperty("Content-Type", "application/json");
            conn.setRequestProperty("Authorization", "Basic " + basicAuth);
            conn.setSSLSocketFactory(sslsocketfactory);
            String input = "{\"grant_type\": \"client_credentials\"}";
            OutputStream os = conn.getOutputStream();
            os.write(input.getBytes());
            os.flush();
            InputStreamReader reader = new InputStreamReader(conn.getInputStream());
            BufferedReader br = new BufferedReader(reader);
            StringBuilder sb = new StringBuilder();
            while ((response = br.readLine()) != null) {
                sb.append(response);
                try {
                    JSONObject jsonObject = new JSONObject(sb.toString());
                    token = jsonObject.getString("access_token");
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
            conn.disconnect();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Object result = "{'environment':'" + environment + "','access_token':'" + token + "'}";
        result = ((String)result).replaceAll("'", "\"");
        return result;
    }

    @CronapiMetaData(type="function", name="{{createBilling}}", description="{{createBillingDesc}}", params={"Token: {{tokenDesc}}", "{{debtorDocument}}:{{debtorDocumentDesc}}", "{{sellerName}}", "{{value}}:{{valueDesc}}", "{{pixKey}}: {{pixKeyDesc}}", "{{solicitation}}: {{payerInformation}}"}, paramsType={CronapiMetaData.ObjectType.STRING, CronapiMetaData.ObjectType.STRING, CronapiMetaData.ObjectType.STRING, CronapiMetaData.ObjectType.LONG, CronapiMetaData.ObjectType.STRING, CronapiMetaData.ObjectType.STRING}, returnType=CronapiMetaData.ObjectType.STRING)
    public static String createCob(Var token, Var debtorDoc, Var debtorName, Var cobValue, Var pixKey, Var solicitation) throws Exception {
        String payload = GerencianetPix.getFormattedPayload(debtorDoc.getObjectAsString(), debtorName.getObjectAsString(), cobValue.getObjectAsDouble(), pixKey.getObjectAsString(), solicitation.getObjectAsString());
        StringBuilder responseBuilder = new StringBuilder();
        HttpsURLConnection conn = null;
        try {
            String response;
            JSONObject jsonObjectToken = new JSONObject(token.toString());
            String environment = jsonObjectToken.getString("environment");
            String accessToken = jsonObjectToken.getString("access_token");
            Generex generex = new Generex("[a-zA-Z0-9]{26,35}");
            String txid = generex.random();
            URL url = new URL(GerencianetPix.getEnvironmentUrl(environment) + "/v2/cob/" + txid);
            conn = (HttpsURLConnection)url.openConnection();
            conn.setDoOutput(true);
            conn.setRequestMethod("PUT");
            conn.setRequestProperty("Content-Type", "application/json");
            conn.setRequestProperty("Authorization", "Bearer " + accessToken);
            OutputStream os = conn.getOutputStream();
            os.write(payload.getBytes());
            os.flush();
            InputStreamReader reader = new InputStreamReader(conn.getInputStream());
            BufferedReader br = new BufferedReader(reader);
            while ((response = br.readLine()) != null) {
                responseBuilder.append(response);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return responseBuilder.toString();
    }

    @CronapiMetaData(type="function", name="{{getBilling}}", description="{{getBillingDesc}}", params={"{{token}}:{{tokenDesc}}", "TxId:{{txIdDesc}}"}, paramsType={CronapiMetaData.ObjectType.STRING, CronapiMetaData.ObjectType.STRING}, returnType=CronapiMetaData.ObjectType.STRING)
    public static String getCob(Var token, Var txId) throws Exception {
        JSONObject jsonObjectToken = new JSONObject(token.getObjectAsString());
        String environment = jsonObjectToken.getString("environment");
        String accessToken = jsonObjectToken.getString("access_token");
        String url = GerencianetPix.getEnvironmentUrl(environment) + "/v2/cob/" + txId.getObjectAsString();
        String endpointData = GerencianetPix.getEndpointDataByAccessToken(url, "GET", accessToken);
        return endpointData;
    }

    @CronapiMetaData(type="function", name="{{getPixByPeriod}}", description="{{getPixByPeriodDesc}}", params={"Token: {{tokenDesc}}", "{{initialDate}}: {{initialDateDesc}}", "{{finalDate}}: {{finalDateDesc}}"}, paramsType={CronapiMetaData.ObjectType.STRING, CronapiMetaData.ObjectType.DATETIME, CronapiMetaData.ObjectType.DATETIME}, returnType=CronapiMetaData.ObjectType.STRING)
    public static final Var getPixByPeriod(Var token, Var dataInicio, Var dataFim) throws Exception {
        JSONObject jsonObjectToken = new JSONObject(token.toString());
        String environment = jsonObjectToken.getString("environment");
        String accessToken = jsonObjectToken.getString("access_token");
        String url = GerencianetPix.getEnvironmentUrl(environment) + "/v2/pix?inicio=" + dataInicio + "&fim=" + dataFim;
        String endpointData = GerencianetPix.getEndpointDataByAccessToken(url, "GET", accessToken);
        return Var.valueOf((Object)endpointData);
    }

    @CronapiMetaData(type="function", name="{{getPixByEndToEndId}}", description="{{getPixByEndToEndIdDesc}}", params={"Token: {{tokenDesc}}", "{{endToEndId}}: {{endToEndIdDesc}}"}, paramsType={CronapiMetaData.ObjectType.STRING, CronapiMetaData.ObjectType.STRING}, returnType=CronapiMetaData.ObjectType.STRING)
    public static final Var getPixByE2EId(Var token, Var End2EndId) throws Exception {
        JSONObject jsonObjectToken = new JSONObject(token.toString());
        String environment = jsonObjectToken.getString("environment");
        String accessToken = jsonObjectToken.getString("access_token");
        String url = GerencianetPix.getEnvironmentUrl(environment) + "/v2/pix/" + End2EndId;
        String endpointData = GerencianetPix.getEndpointDataByAccessToken(url, "GET", accessToken);
        return Var.valueOf((Object)endpointData);
    }

    @CronapiMetaData(type="function", name="{{getQrCode}}", description="{{getQrCodeDesc}}", params={"Token: {{tokenDesc}}", "{{type}}: {{typeQrCodeDesc}}", " {{billingId}}: {{billingIdDesc}}"}, paramsType={CronapiMetaData.ObjectType.STRING, CronapiMetaData.ObjectType.STRING}, returnType=CronapiMetaData.ObjectType.STRING)
    public static String createQrCode(Var token, @ParamMetaData(blockType="util_dropdown", keys={"BASE64", "COPYANDPASTE", "FILE"}, values={"{{Base64}}", "{{copyAndPaste}}", "{{file}}"}) Var type, Var idCob) throws Exception {
        JSONObject jsonObjectToken = new JSONObject(token.toString());
        String environment = jsonObjectToken.getString("environment");
        String accessToken = jsonObjectToken.getString("access_token");
        String url = GerencianetPix.getEnvironmentUrl(environment) + "/v2/loc/" + idCob + "/qrcode";
        String endpointData = GerencianetPix.getEndpointDataByAccessToken(url, "GET", accessToken);
        String qrCodeData = GerencianetPix.getQrCodeDataByType(type.getObjectAsString(), endpointData);
        return qrCodeData;
    }

    private static String getEndpointDataByAccessToken(String urlEndpoint, String method, String accessToken) {
        String result = "";
        StringBuilder responseBuilder = new StringBuilder();
        HttpsURLConnection conn = null;
        try {
            String response;
            URL url = new URL(urlEndpoint);
            conn = (HttpsURLConnection)url.openConnection();
            conn.setDoOutput(true);
            conn.setRequestMethod(method);
            conn.setRequestProperty("Content-Type", "application/json");
            conn.setRequestProperty("Authorization", "Bearer " + accessToken);
            InputStreamReader reader = new InputStreamReader(conn.getInputStream());
            BufferedReader br = new BufferedReader(reader);
            while ((response = br.readLine()) != null) {
                responseBuilder.append(response);
            }
            result = responseBuilder.toString();
        }
        catch (Exception e) {
            System.out.println("Error on getting data.");
            e.printStackTrace();
        }
        return result;
    }

    private static String getEnvironmentUrl(String environment) {
        String environmentUrl = "";
        if (environment.equals("DEVELOPMENT")) {
            environmentUrl = "https://api-pix-h.gerencianet.com.br";
        } else if (environment.equals("PRODUCTION")) {
            environmentUrl = "https://api-pix.gerencianet.com.br";
        }
        return environmentUrl;
    }

    private static String getQrCodeDataByType(String typeQrCode, String endpointData) {
        Object qrCodeData = "";
        JSONObject jsonObjectQrCode = new JSONObject(endpointData.toString());
        if (typeQrCode.equals("BASE64")) {
            qrCodeData = jsonObjectQrCode.getString("imagemQrcode");
        } else if (typeQrCode.equals("COPYANDPASTE")) {
            qrCodeData = jsonObjectQrCode.getString("qrcode");
        } else if (typeQrCode.equals("FILE")) {
            String image = jsonObjectQrCode.getString("imagemQrcode");
            long timeMilis = System.currentTimeMillis();
            Object fileName = "";
            String base64Image = image.split(",")[1];
            byte[] imageBytes = DatatypeConverter.parseBase64Binary((String)base64Image);
            try {
                fileName = "QRCode_" + timeMilis + ".png";
                BufferedImage img = ImageIO.read(new ByteArrayInputStream(imageBytes));
                File outputfile = new File((String)fileName);
                ImageIO.write((RenderedImage)img, "png", outputfile);
                qrCodeData = fileName;
            }
            catch (Exception e) {
                System.out.println("Error on save image");
                e.printStackTrace();
                fileName = "";
            }
        }
        return qrCodeData;
    }

    private static String getFormattedPayload(String debtorDoc, String debtorName, Double cobValue, String pixKey, String solicitation) {
        String typeDebtorDoc = "";
        String debtorDocClean = debtorDoc.replace(".", "").replace("-", "").replace("/", "");
        if (debtorDocClean.length() == 11) {
            typeDebtorDoc = "cpf";
        } else if (debtorDocClean.length() == 14) {
            typeDebtorDoc = "cnpj";
        }
        String payload = "{\r\n  \"calendario\": {\r\n    \"expiracao\": 3600\r\n  },\r\n  \"devedor\": {\r\n    \"typedebtordoc\": \"\",\r\n    \"nome\": \"\"\r\n  },\r\n  \"valor\": {\r\n    \"original\": \"\"\r\n  },\r\n  \"chave\": \"\",\r\n  \"solicitacaoPagador\": \"\",\r\n}";
        payload = payload.replace("typedebtordoc", typeDebtorDoc);
        JSONObject jsonPayload = new JSONObject(payload);
        JSONObject jsonDebtorDoc = jsonPayload.getJSONObject("devedor");
        jsonDebtorDoc.put(typeDebtorDoc, (Object)debtorDocClean);
        jsonDebtorDoc.put("nome", (Object)debtorName);
        JSONObject jsonCobValue = jsonPayload.getJSONObject("valor");
        jsonCobValue.put("original", (Object)cobValue.toString());
        jsonPayload.put("chave", (Object)pixKey);
        jsonPayload.put("solicitacaoPagador", (Object)solicitation);
        return jsonPayload.toString();
    }
}

