/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.facebook.api.impl;

import org.springframework.social.facebook.api.Comment;
import org.springframework.social.facebook.api.CommentOperations;
import org.springframework.social.facebook.api.GraphApi;
import org.springframework.social.facebook.api.PagedList;
import org.springframework.social.facebook.api.PagingParameters;
import org.springframework.social.facebook.api.impl.PagedListUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

class CommentTemplate
implements CommentOperations {
    private final GraphApi graphApi;
    private static final String[] ALL_FIELDS = new String[]{"id", "attachment", "can_comment", "can_remove", "comment_count", "created_time", "from", "like_count", "message", "parent", "user_likes"};

    public CommentTemplate(GraphApi graphApi) {
        this.graphApi = graphApi;
    }

    @Override
    public PagedList<Comment> getComments(String objectId) {
        return this.getComments(objectId, new PagingParameters(25, 0, null, null));
    }

    @Override
    public PagedList<Comment> getComments(String objectId, PagingParameters pagedListParameters) {
        return this.graphApi.fetchConnections(objectId, "comments", Comment.class, PagedListUtils.getPagingParameters(pagedListParameters));
    }

    @Override
    public Comment getComment(String commentId) {
        return this.graphApi.fetchObject(commentId, Comment.class, ALL_FIELDS);
    }

    @Override
    public String addComment(String objectId, String message) {
        LinkedMultiValueMap map = new LinkedMultiValueMap();
        map.set((Object)"message", (Object)message);
        return this.graphApi.publish(objectId, "comments", (MultiValueMap<String, Object>)map);
    }

    @Override
    public void deleteComment(String objectId) {
        this.graphApi.delete(objectId);
    }
}

