/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.facebook.api.impl;

import org.springframework.social.facebook.api.Event;
import org.springframework.social.facebook.api.EventInvitee;
import org.springframework.social.facebook.api.EventOperations;
import org.springframework.social.facebook.api.GraphApi;
import org.springframework.social.facebook.api.ImageType;
import org.springframework.social.facebook.api.Invitation;
import org.springframework.social.facebook.api.PagedList;
import org.springframework.social.facebook.api.PagingParameters;
import org.springframework.social.facebook.api.impl.PagedListUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

class EventTemplate
implements EventOperations {
    private final GraphApi graphApi;
    private static final String[] ALL_FIELDS = new String[]{"id", "cover", "description", "end_time", "is_date_only", "name", "owner", "parent_group", "privacy", "start_time", "ticket_uri", "timezone", "updated_time", "place"};

    public EventTemplate(GraphApi graphApi) {
        this.graphApi = graphApi;
    }

    @Override
    public Event getEvent(String eventId) {
        return this.graphApi.fetchObject(eventId, Event.class, ALL_FIELDS);
    }

    @Override
    public byte[] getEventImage(String eventId) {
        return this.getEventImage(eventId, ImageType.NORMAL);
    }

    @Override
    public byte[] getEventImage(String eventId, ImageType imageType) {
        return this.graphApi.fetchImage(eventId, "picture", imageType);
    }

    @Override
    public PagedList<EventInvitee> getInvited(String eventId) {
        return this.graphApi.fetchConnections(eventId, "invited", EventInvitee.class, new String[0]);
    }

    @Override
    public PagedList<Invitation> getCreated() {
        return this.getEventsForUserByStatus("me", "created", new PagingParameters(25, 0, null, null));
    }

    @Override
    public PagedList<Invitation> getCreated(PagingParameters pagingParams) {
        return this.getEventsForUserByStatus("me", "created", pagingParams);
    }

    @Override
    public PagedList<Invitation> getAttending() {
        return this.getEventsForUserByStatus("me", "attending", new PagingParameters(25, 0, null, null));
    }

    @Override
    public PagedList<Invitation> getAttending(PagingParameters pagingParams) {
        return this.getEventsForUserByStatus("me", "attending", pagingParams);
    }

    @Override
    public PagedList<EventInvitee> getAttending(String eventId) {
        return this.graphApi.fetchConnections(eventId, "attending", EventInvitee.class, new String[0]);
    }

    @Override
    public PagedList<Invitation> getMaybeAttending() {
        return this.getEventsForUserByStatus("me", "maybe", new PagingParameters(25, 0, null, null));
    }

    @Override
    public PagedList<Invitation> getMaybeAttending(PagingParameters pagingParams) {
        return this.getEventsForUserByStatus("me", "maybe", pagingParams);
    }

    @Override
    public PagedList<EventInvitee> getMaybeAttending(String eventId) {
        return this.graphApi.fetchConnections(eventId, "maybe", EventInvitee.class, new String[0]);
    }

    @Override
    public PagedList<Invitation> getNoReplies() {
        return this.getEventsForUserByStatus("me", "not_replied", new PagingParameters(25, 0, null, null));
    }

    @Override
    public PagedList<Invitation> getNoReplies(PagingParameters pagingParams) {
        return this.getEventsForUserByStatus("me", "not_replied", pagingParams);
    }

    @Override
    public PagedList<EventInvitee> getNoReplies(String eventId) {
        return this.graphApi.fetchConnections(eventId, "noreply", EventInvitee.class, new String[0]);
    }

    @Override
    public PagedList<Invitation> getDeclined() {
        return this.getEventsForUserByStatus("me", "declined", new PagingParameters(25, 0, null, null));
    }

    @Override
    public PagedList<Invitation> getDeclined(PagingParameters pagingParams) {
        return this.getEventsForUserByStatus("me", "declined", pagingParams);
    }

    @Override
    public PagedList<EventInvitee> getDeclined(String eventId) {
        return this.graphApi.fetchConnections(eventId, "declined", EventInvitee.class, new String[0]);
    }

    @Override
    public void acceptInvitation(String eventId) {
        this.graphApi.post(eventId, "attending", (MultiValueMap<String, Object>)new LinkedMultiValueMap());
    }

    @Override
    public void maybeInvitation(String eventId) {
        this.graphApi.post(eventId, "maybe", (MultiValueMap<String, Object>)new LinkedMultiValueMap());
    }

    @Override
    public void declineInvitation(String eventId) {
        this.graphApi.post(eventId, "declined", (MultiValueMap<String, Object>)new LinkedMultiValueMap());
    }

    @Override
    public PagedList<Event> search(String query) {
        return this.search(query, new PagingParameters(25, 0, null, null));
    }

    @Override
    public PagedList<Event> search(String query, PagingParameters pagedListParameters) {
        MultiValueMap<String, String> queryMap = PagedListUtils.getPagingParameters(pagedListParameters);
        queryMap.add((Object)"q", (Object)query);
        queryMap.add((Object)"type", (Object)"event");
        return this.graphApi.fetchConnections("search", null, Event.class, queryMap);
    }

    private PagedList<Invitation> getEventsForUserByStatus(String userId, String status, PagingParameters pagingParams) {
        MultiValueMap<String, String> parameters = PagedListUtils.getPagingParameters(pagingParams);
        return this.graphApi.fetchConnections(userId, "events/" + status, Invitation.class, parameters);
    }
}

