/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.facebook.api.impl;

import org.springframework.social.facebook.api.ActionMetadata;
import org.springframework.social.facebook.api.OpenGraphOperations;
import org.springframework.social.facebook.api.VideoActions;
import org.springframework.util.MultiValueMap;

public class VideoActionsTemplate
implements VideoActions {
    private OpenGraphOperations openGraphOperations;

    public VideoActionsTemplate(OpenGraphOperations openGraphOperations) {
        this.openGraphOperations = openGraphOperations;
    }

    @Override
    public String watchMovie(String movieUrl) {
        return this.watchMovie(movieUrl, OpenGraphOperations.EMPTY_ACTION_METADATA);
    }

    @Override
    public String watchMovie(String movieUrl, ActionMetadata metadata) {
        return this.watchVideo("movie", movieUrl, metadata);
    }

    @Override
    public String watchTvShow(String tvShowUrl) {
        return this.watchTvShow(tvShowUrl, OpenGraphOperations.EMPTY_ACTION_METADATA);
    }

    @Override
    public String watchTvShow(String tvShowUrl, ActionMetadata metadata) {
        return this.watchVideo("tv_show", tvShowUrl, metadata);
    }

    @Override
    public String watchTvEpisode(String tvEpisodeUrl) {
        return this.watchTvEpisode(tvEpisodeUrl, OpenGraphOperations.EMPTY_ACTION_METADATA);
    }

    @Override
    public String watchTvEpisode(String tvShowUrl, ActionMetadata metadata) {
        return this.watchVideo("tv_episode", tvShowUrl, metadata);
    }

    @Override
    public String watchEpisode(String episodeUrl) {
        return this.watchEpisode(episodeUrl, OpenGraphOperations.EMPTY_ACTION_METADATA);
    }

    @Override
    public String watchEpisode(String episodeUrl, ActionMetadata metadata) {
        return this.watchVideo("episode", episodeUrl, metadata);
    }

    @Override
    public String watchVideo(String videoUrl) {
        return this.watchVideo(videoUrl, OpenGraphOperations.EMPTY_ACTION_METADATA);
    }

    @Override
    public String watchVideo(String videoUrl, ActionMetadata metadata) {
        return this.watchVideo("video", videoUrl, metadata);
    }

    @Override
    public String watchVideo(String videoType, String videoUrl, ActionMetadata metadata) {
        MultiValueMap<String, Object> parameters = metadata.toParameters();
        parameters.set((Object)videoType, (Object)videoUrl);
        return this.openGraphOperations.publishAction("video.watches", parameters, true);
    }

    @Override
    public String rateMovie(String movieUrl, float rating, int scale) {
        return this.rateMovie(movieUrl, rating, scale, OpenGraphOperations.EMPTY_ACTION_METADATA);
    }

    @Override
    public String rateMovie(String movieUrl, float rating, int scale, ActionMetadata metadata) {
        return this.rateVideo("movie", movieUrl, rating, scale, metadata);
    }

    @Override
    public String rateEpisode(String episodeUrl, float rating, int scale) {
        return this.rateEpisode(episodeUrl, rating, scale, OpenGraphOperations.EMPTY_ACTION_METADATA);
    }

    @Override
    public String rateEpisode(String episodeUrl, float rating, int scale, ActionMetadata metadata) {
        return this.rateVideo("episode", episodeUrl, rating, scale, metadata);
    }

    @Override
    public String rateTvShow(String tvShowUrl, float rating, int scale) {
        return this.rateTvShow(tvShowUrl, rating, scale, OpenGraphOperations.EMPTY_ACTION_METADATA);
    }

    @Override
    public String rateTvShow(String tvShowUrl, float rating, int scale, ActionMetadata metadata) {
        return this.rateVideo("tv_show", tvShowUrl, rating, scale, metadata);
    }

    @Override
    public String rateVideo(String otherUrl, float rating, int scale) {
        return this.rateVideo(otherUrl, rating, scale, OpenGraphOperations.EMPTY_ACTION_METADATA);
    }

    @Override
    public String rateVideo(String otherUrl, float rating, int scale, ActionMetadata metadata) {
        return this.rateVideo("other", otherUrl, rating, scale, metadata);
    }

    @Override
    public String rateVideo(String videoType, String videoUrl, float rating, int scale, ActionMetadata metadata) {
        MultiValueMap<String, Object> parameters = metadata.toParameters();
        parameters.set((Object)videoType, (Object)videoUrl);
        parameters.set((Object)"rating:value", (Object)String.valueOf(rating));
        parameters.set((Object)"rating:scale", (Object)String.valueOf(scale));
        return this.openGraphOperations.publishAction("video.rates", parameters, true);
    }

    @Override
    public String wantsToWatchMovie(String movieUrl) {
        return this.wantsToWatchMovie(movieUrl, OpenGraphOperations.EMPTY_ACTION_METADATA);
    }

    @Override
    public String wantsToWatchMovie(String movieUrl, ActionMetadata metadata) {
        return this.wantsToWatch("movie", movieUrl, metadata);
    }

    @Override
    public String wantsToWatchTvShow(String tvShowUrl) {
        return this.wantsToWatchTvShow(tvShowUrl, OpenGraphOperations.EMPTY_ACTION_METADATA);
    }

    @Override
    public String wantsToWatchTvShow(String tvShowUrl, ActionMetadata metadata) {
        return this.wantsToWatch("tv_show", tvShowUrl, metadata);
    }

    @Override
    public String wantsToWatchEpisode(String episodeUrl) {
        return this.wantsToWatchEpisode(episodeUrl, OpenGraphOperations.EMPTY_ACTION_METADATA);
    }

    @Override
    public String wantsToWatchEpisode(String episodeUrl, ActionMetadata metadata) {
        return this.wantsToWatch("episode", episodeUrl, metadata);
    }

    @Override
    public String wantsToWatchVideo(String otherUrl) {
        return this.wantsToWatchVideo(otherUrl, OpenGraphOperations.EMPTY_ACTION_METADATA);
    }

    @Override
    public String wantsToWatchVideo(String otherUrl, ActionMetadata metadata) {
        return this.wantsToWatch("other", otherUrl, metadata);
    }

    @Override
    public String wantsToWatch(String videoType, String videoUrl, ActionMetadata metadata) {
        MultiValueMap<String, Object> parameters = metadata.toParameters();
        parameters.set((Object)videoType, (Object)videoUrl);
        return this.openGraphOperations.publishAction("video.wants_to_watch", parameters, true);
    }
}

