/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.api;

import com.google.gson.reflect.TypeToken;
import io.cryptoapis.sdk.ApiCallback;
import io.cryptoapis.sdk.ApiClient;
import io.cryptoapis.sdk.ApiException;
import io.cryptoapis.sdk.ApiResponse;
import io.cryptoapis.sdk.Configuration;
import io.cryptoapis.sdk.Pair;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;
import org.openapitools.client.model.GetAddressDetailsR;
import org.openapitools.client.model.GetBlockDetailsByBlockHashR;
import org.openapitools.client.model.GetBlockDetailsByBlockHeightR;
import org.openapitools.client.model.GetFeeRecommendationsR;
import org.openapitools.client.model.GetLatestMinedBlockR;
import org.openapitools.client.model.GetTransactionDetailsByTransactionIDR;
import org.openapitools.client.model.ListTransactionsByAddressR;
import org.openapitools.client.model.ListTransactionsByBlockHashR;
import org.openapitools.client.model.ListTransactionsByBlockHeightR;

public class UnifiedEndpointsApi {
    private ApiClient localVarApiClient;

    public UnifiedEndpointsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public UnifiedEndpointsApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public Call getAddressDetailsCall(String blockchain, String network, String address, String context, ApiCallback _callback) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/blockchain-data/{blockchain}/{network}/addresses/{address}".replaceAll("\\{blockchain\\}", this.localVarApiClient.escapeString(blockchain.toString())).replaceAll("\\{network\\}", this.localVarApiClient.escapeString(network.toString())).replaceAll("\\{address\\}", this.localVarApiClient.escapeString(address.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (context != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("context", context));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getAddressDetailsValidateBeforeCall(String blockchain, String network, String address, String context, ApiCallback _callback) throws ApiException {
        if (blockchain == null) {
            throw new ApiException("Missing the required parameter 'blockchain' when calling getAddressDetails(Async)");
        }
        if (network == null) {
            throw new ApiException("Missing the required parameter 'network' when calling getAddressDetails(Async)");
        }
        if (address == null) {
            throw new ApiException("Missing the required parameter 'address' when calling getAddressDetails(Async)");
        }
        Call localVarCall = this.getAddressDetailsCall(blockchain, network, address, context, _callback);
        return localVarCall;
    }

    public GetAddressDetailsR getAddressDetails(String blockchain, String network, String address, String context) throws ApiException {
        ApiResponse<GetAddressDetailsR> localVarResp = this.getAddressDetailsWithHttpInfo(blockchain, network, address, context);
        return localVarResp.getData();
    }

    public ApiResponse<GetAddressDetailsR> getAddressDetailsWithHttpInfo(String blockchain, String network, String address, String context) throws ApiException {
        Call localVarCall = this.getAddressDetailsValidateBeforeCall(blockchain, network, address, context, null);
        Type localVarReturnType = new TypeToken<GetAddressDetailsR>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getAddressDetailsAsync(String blockchain, String network, String address, String context, ApiCallback<GetAddressDetailsR> _callback) throws ApiException {
        Call localVarCall = this.getAddressDetailsValidateBeforeCall(blockchain, network, address, context, _callback);
        Type localVarReturnType = new TypeToken<GetAddressDetailsR>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getBlockDetailsByBlockHashCall(String blockchain, String network, String blockHash, String context, ApiCallback _callback) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/blockchain-data/{blockchain}/{network}/blocks/hash/{blockHash}".replaceAll("\\{blockchain\\}", this.localVarApiClient.escapeString(blockchain.toString())).replaceAll("\\{network\\}", this.localVarApiClient.escapeString(network.toString())).replaceAll("\\{blockHash\\}", this.localVarApiClient.escapeString(blockHash.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (context != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("context", context));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getBlockDetailsByBlockHashValidateBeforeCall(String blockchain, String network, String blockHash, String context, ApiCallback _callback) throws ApiException {
        if (blockchain == null) {
            throw new ApiException("Missing the required parameter 'blockchain' when calling getBlockDetailsByBlockHash(Async)");
        }
        if (network == null) {
            throw new ApiException("Missing the required parameter 'network' when calling getBlockDetailsByBlockHash(Async)");
        }
        if (blockHash == null) {
            throw new ApiException("Missing the required parameter 'blockHash' when calling getBlockDetailsByBlockHash(Async)");
        }
        Call localVarCall = this.getBlockDetailsByBlockHashCall(blockchain, network, blockHash, context, _callback);
        return localVarCall;
    }

    public GetBlockDetailsByBlockHashR getBlockDetailsByBlockHash(String blockchain, String network, String blockHash, String context) throws ApiException {
        ApiResponse<GetBlockDetailsByBlockHashR> localVarResp = this.getBlockDetailsByBlockHashWithHttpInfo(blockchain, network, blockHash, context);
        return localVarResp.getData();
    }

    public ApiResponse<GetBlockDetailsByBlockHashR> getBlockDetailsByBlockHashWithHttpInfo(String blockchain, String network, String blockHash, String context) throws ApiException {
        Call localVarCall = this.getBlockDetailsByBlockHashValidateBeforeCall(blockchain, network, blockHash, context, null);
        Type localVarReturnType = new TypeToken<GetBlockDetailsByBlockHashR>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getBlockDetailsByBlockHashAsync(String blockchain, String network, String blockHash, String context, ApiCallback<GetBlockDetailsByBlockHashR> _callback) throws ApiException {
        Call localVarCall = this.getBlockDetailsByBlockHashValidateBeforeCall(blockchain, network, blockHash, context, _callback);
        Type localVarReturnType = new TypeToken<GetBlockDetailsByBlockHashR>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getBlockDetailsByBlockHeightCall(String blockchain, String network, Integer height, String context, ApiCallback _callback) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/blockchain-data/{blockchain}/{network}/blocks/height/{height}".replaceAll("\\{blockchain\\}", this.localVarApiClient.escapeString(blockchain.toString())).replaceAll("\\{network\\}", this.localVarApiClient.escapeString(network.toString())).replaceAll("\\{height\\}", this.localVarApiClient.escapeString(height.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (context != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("context", context));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getBlockDetailsByBlockHeightValidateBeforeCall(String blockchain, String network, Integer height, String context, ApiCallback _callback) throws ApiException {
        if (blockchain == null) {
            throw new ApiException("Missing the required parameter 'blockchain' when calling getBlockDetailsByBlockHeight(Async)");
        }
        if (network == null) {
            throw new ApiException("Missing the required parameter 'network' when calling getBlockDetailsByBlockHeight(Async)");
        }
        if (height == null) {
            throw new ApiException("Missing the required parameter 'height' when calling getBlockDetailsByBlockHeight(Async)");
        }
        Call localVarCall = this.getBlockDetailsByBlockHeightCall(blockchain, network, height, context, _callback);
        return localVarCall;
    }

    public GetBlockDetailsByBlockHeightR getBlockDetailsByBlockHeight(String blockchain, String network, Integer height, String context) throws ApiException {
        ApiResponse<GetBlockDetailsByBlockHeightR> localVarResp = this.getBlockDetailsByBlockHeightWithHttpInfo(blockchain, network, height, context);
        return localVarResp.getData();
    }

    public ApiResponse<GetBlockDetailsByBlockHeightR> getBlockDetailsByBlockHeightWithHttpInfo(String blockchain, String network, Integer height, String context) throws ApiException {
        Call localVarCall = this.getBlockDetailsByBlockHeightValidateBeforeCall(blockchain, network, height, context, null);
        Type localVarReturnType = new TypeToken<GetBlockDetailsByBlockHeightR>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getBlockDetailsByBlockHeightAsync(String blockchain, String network, Integer height, String context, ApiCallback<GetBlockDetailsByBlockHeightR> _callback) throws ApiException {
        Call localVarCall = this.getBlockDetailsByBlockHeightValidateBeforeCall(blockchain, network, height, context, _callback);
        Type localVarReturnType = new TypeToken<GetBlockDetailsByBlockHeightR>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getFeeRecommendationsCall(String blockchain, String network, String context, ApiCallback _callback) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/blockchain-data/{blockchain}/{network}/mempool/fees".replaceAll("\\{blockchain\\}", this.localVarApiClient.escapeString(blockchain.toString())).replaceAll("\\{network\\}", this.localVarApiClient.escapeString(network.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (context != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("context", context));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getFeeRecommendationsValidateBeforeCall(String blockchain, String network, String context, ApiCallback _callback) throws ApiException {
        if (blockchain == null) {
            throw new ApiException("Missing the required parameter 'blockchain' when calling getFeeRecommendations(Async)");
        }
        if (network == null) {
            throw new ApiException("Missing the required parameter 'network' when calling getFeeRecommendations(Async)");
        }
        Call localVarCall = this.getFeeRecommendationsCall(blockchain, network, context, _callback);
        return localVarCall;
    }

    public GetFeeRecommendationsR getFeeRecommendations(String blockchain, String network, String context) throws ApiException {
        ApiResponse<GetFeeRecommendationsR> localVarResp = this.getFeeRecommendationsWithHttpInfo(blockchain, network, context);
        return localVarResp.getData();
    }

    public ApiResponse<GetFeeRecommendationsR> getFeeRecommendationsWithHttpInfo(String blockchain, String network, String context) throws ApiException {
        Call localVarCall = this.getFeeRecommendationsValidateBeforeCall(blockchain, network, context, null);
        Type localVarReturnType = new TypeToken<GetFeeRecommendationsR>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getFeeRecommendationsAsync(String blockchain, String network, String context, ApiCallback<GetFeeRecommendationsR> _callback) throws ApiException {
        Call localVarCall = this.getFeeRecommendationsValidateBeforeCall(blockchain, network, context, _callback);
        Type localVarReturnType = new TypeToken<GetFeeRecommendationsR>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getLatestMinedBlockCall(String blockchain, String network, String context, ApiCallback _callback) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/blockchain-data/{blockchain}/{network}/blocks/last".replaceAll("\\{blockchain\\}", this.localVarApiClient.escapeString(blockchain.toString())).replaceAll("\\{network\\}", this.localVarApiClient.escapeString(network.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (context != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("context", context));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getLatestMinedBlockValidateBeforeCall(String blockchain, String network, String context, ApiCallback _callback) throws ApiException {
        if (blockchain == null) {
            throw new ApiException("Missing the required parameter 'blockchain' when calling getLatestMinedBlock(Async)");
        }
        if (network == null) {
            throw new ApiException("Missing the required parameter 'network' when calling getLatestMinedBlock(Async)");
        }
        Call localVarCall = this.getLatestMinedBlockCall(blockchain, network, context, _callback);
        return localVarCall;
    }

    public GetLatestMinedBlockR getLatestMinedBlock(String blockchain, String network, String context) throws ApiException {
        ApiResponse<GetLatestMinedBlockR> localVarResp = this.getLatestMinedBlockWithHttpInfo(blockchain, network, context);
        return localVarResp.getData();
    }

    public ApiResponse<GetLatestMinedBlockR> getLatestMinedBlockWithHttpInfo(String blockchain, String network, String context) throws ApiException {
        Call localVarCall = this.getLatestMinedBlockValidateBeforeCall(blockchain, network, context, null);
        Type localVarReturnType = new TypeToken<GetLatestMinedBlockR>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getLatestMinedBlockAsync(String blockchain, String network, String context, ApiCallback<GetLatestMinedBlockR> _callback) throws ApiException {
        Call localVarCall = this.getLatestMinedBlockValidateBeforeCall(blockchain, network, context, _callback);
        Type localVarReturnType = new TypeToken<GetLatestMinedBlockR>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getTransactionDetailsByTransactionIDCall(String blockchain, String network, String transactionId, String context, ApiCallback _callback) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/blockchain-data/{blockchain}/{network}/transactions/{transactionId}".replaceAll("\\{blockchain\\}", this.localVarApiClient.escapeString(blockchain.toString())).replaceAll("\\{network\\}", this.localVarApiClient.escapeString(network.toString())).replaceAll("\\{transactionId\\}", this.localVarApiClient.escapeString(transactionId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (context != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("context", context));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getTransactionDetailsByTransactionIDValidateBeforeCall(String blockchain, String network, String transactionId, String context, ApiCallback _callback) throws ApiException {
        if (blockchain == null) {
            throw new ApiException("Missing the required parameter 'blockchain' when calling getTransactionDetailsByTransactionID(Async)");
        }
        if (network == null) {
            throw new ApiException("Missing the required parameter 'network' when calling getTransactionDetailsByTransactionID(Async)");
        }
        if (transactionId == null) {
            throw new ApiException("Missing the required parameter 'transactionId' when calling getTransactionDetailsByTransactionID(Async)");
        }
        Call localVarCall = this.getTransactionDetailsByTransactionIDCall(blockchain, network, transactionId, context, _callback);
        return localVarCall;
    }

    public GetTransactionDetailsByTransactionIDR getTransactionDetailsByTransactionID(String blockchain, String network, String transactionId, String context) throws ApiException {
        ApiResponse<GetTransactionDetailsByTransactionIDR> localVarResp = this.getTransactionDetailsByTransactionIDWithHttpInfo(blockchain, network, transactionId, context);
        return localVarResp.getData();
    }

    public ApiResponse<GetTransactionDetailsByTransactionIDR> getTransactionDetailsByTransactionIDWithHttpInfo(String blockchain, String network, String transactionId, String context) throws ApiException {
        Call localVarCall = this.getTransactionDetailsByTransactionIDValidateBeforeCall(blockchain, network, transactionId, context, null);
        Type localVarReturnType = new TypeToken<GetTransactionDetailsByTransactionIDR>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getTransactionDetailsByTransactionIDAsync(String blockchain, String network, String transactionId, String context, ApiCallback<GetTransactionDetailsByTransactionIDR> _callback) throws ApiException {
        Call localVarCall = this.getTransactionDetailsByTransactionIDValidateBeforeCall(blockchain, network, transactionId, context, _callback);
        Type localVarReturnType = new TypeToken<GetTransactionDetailsByTransactionIDR>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listTransactionsByAddressCall(String blockchain, String network, String address, String context, Integer limit, Integer offset, ApiCallback _callback) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/blockchain-data/{blockchain}/{network}/addresses/{address}/transactions".replaceAll("\\{blockchain\\}", this.localVarApiClient.escapeString(blockchain.toString())).replaceAll("\\{network\\}", this.localVarApiClient.escapeString(network.toString())).replaceAll("\\{address\\}", this.localVarApiClient.escapeString(address.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (context != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("context", context));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (offset != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("offset", offset));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listTransactionsByAddressValidateBeforeCall(String blockchain, String network, String address, String context, Integer limit, Integer offset, ApiCallback _callback) throws ApiException {
        if (blockchain == null) {
            throw new ApiException("Missing the required parameter 'blockchain' when calling listTransactionsByAddress(Async)");
        }
        if (network == null) {
            throw new ApiException("Missing the required parameter 'network' when calling listTransactionsByAddress(Async)");
        }
        if (address == null) {
            throw new ApiException("Missing the required parameter 'address' when calling listTransactionsByAddress(Async)");
        }
        Call localVarCall = this.listTransactionsByAddressCall(blockchain, network, address, context, limit, offset, _callback);
        return localVarCall;
    }

    public ListTransactionsByAddressR listTransactionsByAddress(String blockchain, String network, String address, String context, Integer limit, Integer offset) throws ApiException {
        ApiResponse<ListTransactionsByAddressR> localVarResp = this.listTransactionsByAddressWithHttpInfo(blockchain, network, address, context, limit, offset);
        return localVarResp.getData();
    }

    public ApiResponse<ListTransactionsByAddressR> listTransactionsByAddressWithHttpInfo(String blockchain, String network, String address, String context, Integer limit, Integer offset) throws ApiException {
        Call localVarCall = this.listTransactionsByAddressValidateBeforeCall(blockchain, network, address, context, limit, offset, null);
        Type localVarReturnType = new TypeToken<ListTransactionsByAddressR>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listTransactionsByAddressAsync(String blockchain, String network, String address, String context, Integer limit, Integer offset, ApiCallback<ListTransactionsByAddressR> _callback) throws ApiException {
        Call localVarCall = this.listTransactionsByAddressValidateBeforeCall(blockchain, network, address, context, limit, offset, _callback);
        Type localVarReturnType = new TypeToken<ListTransactionsByAddressR>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listTransactionsByBlockHashCall(String blockchain, String network, String blockHash, String context, Integer limit, Integer offset, ApiCallback _callback) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/blockchain-data/{blockchain}/{network}/blocks/hash/{blockHash}/transactions".replaceAll("\\{blockchain\\}", this.localVarApiClient.escapeString(blockchain.toString())).replaceAll("\\{network\\}", this.localVarApiClient.escapeString(network.toString())).replaceAll("\\{blockHash\\}", this.localVarApiClient.escapeString(blockHash.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (context != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("context", context));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (offset != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("offset", offset));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listTransactionsByBlockHashValidateBeforeCall(String blockchain, String network, String blockHash, String context, Integer limit, Integer offset, ApiCallback _callback) throws ApiException {
        if (blockchain == null) {
            throw new ApiException("Missing the required parameter 'blockchain' when calling listTransactionsByBlockHash(Async)");
        }
        if (network == null) {
            throw new ApiException("Missing the required parameter 'network' when calling listTransactionsByBlockHash(Async)");
        }
        if (blockHash == null) {
            throw new ApiException("Missing the required parameter 'blockHash' when calling listTransactionsByBlockHash(Async)");
        }
        Call localVarCall = this.listTransactionsByBlockHashCall(blockchain, network, blockHash, context, limit, offset, _callback);
        return localVarCall;
    }

    public ListTransactionsByBlockHashR listTransactionsByBlockHash(String blockchain, String network, String blockHash, String context, Integer limit, Integer offset) throws ApiException {
        ApiResponse<ListTransactionsByBlockHashR> localVarResp = this.listTransactionsByBlockHashWithHttpInfo(blockchain, network, blockHash, context, limit, offset);
        return localVarResp.getData();
    }

    public ApiResponse<ListTransactionsByBlockHashR> listTransactionsByBlockHashWithHttpInfo(String blockchain, String network, String blockHash, String context, Integer limit, Integer offset) throws ApiException {
        Call localVarCall = this.listTransactionsByBlockHashValidateBeforeCall(blockchain, network, blockHash, context, limit, offset, null);
        Type localVarReturnType = new TypeToken<ListTransactionsByBlockHashR>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listTransactionsByBlockHashAsync(String blockchain, String network, String blockHash, String context, Integer limit, Integer offset, ApiCallback<ListTransactionsByBlockHashR> _callback) throws ApiException {
        Call localVarCall = this.listTransactionsByBlockHashValidateBeforeCall(blockchain, network, blockHash, context, limit, offset, _callback);
        Type localVarReturnType = new TypeToken<ListTransactionsByBlockHashR>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listTransactionsByBlockHeightCall(String blockchain, String network, Integer height, String context, Integer limit, Integer offset, ApiCallback _callback) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/blockchain-data/{blockchain}/{network}/blocks/height/{height}/transactions".replaceAll("\\{blockchain\\}", this.localVarApiClient.escapeString(blockchain.toString())).replaceAll("\\{network\\}", this.localVarApiClient.escapeString(network.toString())).replaceAll("\\{height\\}", this.localVarApiClient.escapeString(height.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (context != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("context", context));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (offset != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("offset", offset));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listTransactionsByBlockHeightValidateBeforeCall(String blockchain, String network, Integer height, String context, Integer limit, Integer offset, ApiCallback _callback) throws ApiException {
        if (blockchain == null) {
            throw new ApiException("Missing the required parameter 'blockchain' when calling listTransactionsByBlockHeight(Async)");
        }
        if (network == null) {
            throw new ApiException("Missing the required parameter 'network' when calling listTransactionsByBlockHeight(Async)");
        }
        if (height == null) {
            throw new ApiException("Missing the required parameter 'height' when calling listTransactionsByBlockHeight(Async)");
        }
        Call localVarCall = this.listTransactionsByBlockHeightCall(blockchain, network, height, context, limit, offset, _callback);
        return localVarCall;
    }

    public ListTransactionsByBlockHeightR listTransactionsByBlockHeight(String blockchain, String network, Integer height, String context, Integer limit, Integer offset) throws ApiException {
        ApiResponse<ListTransactionsByBlockHeightR> localVarResp = this.listTransactionsByBlockHeightWithHttpInfo(blockchain, network, height, context, limit, offset);
        return localVarResp.getData();
    }

    public ApiResponse<ListTransactionsByBlockHeightR> listTransactionsByBlockHeightWithHttpInfo(String blockchain, String network, Integer height, String context, Integer limit, Integer offset) throws ApiException {
        Call localVarCall = this.listTransactionsByBlockHeightValidateBeforeCall(blockchain, network, height, context, limit, offset, null);
        Type localVarReturnType = new TypeToken<ListTransactionsByBlockHeightR>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listTransactionsByBlockHeightAsync(String blockchain, String network, Integer height, String context, Integer limit, Integer offset, ApiCallback<ListTransactionsByBlockHeightR> _callback) throws ApiException {
        Call localVarCall = this.listTransactionsByBlockHeightValidateBeforeCall(blockchain, network, height, context, limit, offset, _callback);
        Type localVarReturnType = new TypeToken<ListTransactionsByBlockHeightR>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

