/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Objects;
import org.openapitools.client.model.AddressCoinsTransactionConfirmedEachConfirmationDataItemMinedInBlock;

@ApiModel(description="Defines an `item` as one result.")
public class AddressCoinsTransactionConfirmedEachConfirmationDataItem {
    public static final String SERIALIZED_NAME_BLOCKCHAIN = "blockchain";
    @SerializedName(value="blockchain")
    private String blockchain;
    public static final String SERIALIZED_NAME_NETWORK = "network";
    @SerializedName(value="network")
    private String network;
    public static final String SERIALIZED_NAME_ADDRESS = "address";
    @SerializedName(value="address")
    private String address;
    public static final String SERIALIZED_NAME_MINED_IN_BLOCK = "minedInBlock";
    @SerializedName(value="minedInBlock")
    private AddressCoinsTransactionConfirmedEachConfirmationDataItemMinedInBlock minedInBlock;
    public static final String SERIALIZED_NAME_TRANSACTION_ID = "transactionId";
    @SerializedName(value="transactionId")
    private String transactionId;
    public static final String SERIALIZED_NAME_CURRENT_CONFIRMATIONS = "currentConfirmations";
    @SerializedName(value="currentConfirmations")
    private Integer currentConfirmations;
    public static final String SERIALIZED_NAME_TARGET_CONFIRMATIONS = "targetConfirmations";
    @SerializedName(value="targetConfirmations")
    private Integer targetConfirmations;
    public static final String SERIALIZED_NAME_AMOUNT = "amount";
    @SerializedName(value="amount")
    private String amount;
    public static final String SERIALIZED_NAME_UNIT = "unit";
    @SerializedName(value="unit")
    private String unit;
    public static final String SERIALIZED_NAME_DIRECTION = "direction";
    @SerializedName(value="direction")
    private DirectionEnum direction;

    public AddressCoinsTransactionConfirmedEachConfirmationDataItem blockchain(String blockchain) {
        this.blockchain = blockchain;
        return this;
    }

    @ApiModelProperty(example="bitcoin", required=true, value="Represents the specific blockchain protocol name, e.g. Ethereum, Bitcoin, etc.")
    public String getBlockchain() {
        return this.blockchain;
    }

    public void setBlockchain(String blockchain) {
        this.blockchain = blockchain;
    }

    public AddressCoinsTransactionConfirmedEachConfirmationDataItem network(String network) {
        this.network = network;
        return this;
    }

    @ApiModelProperty(example="testnet", required=true, value="Represents the name of the blockchain network used; blockchain networks are usually identical as technology and software, but they differ in data, e.g. - \"mainnet\" is the live network with actual data while networks like \"testnet\", \"ropsten\", \"rinkeby\" are test networks.")
    public String getNetwork() {
        return this.network;
    }

    public void setNetwork(String network) {
        this.network = network;
    }

    public AddressCoinsTransactionConfirmedEachConfirmationDataItem address(String address) {
        this.address = address;
        return this;
    }

    @ApiModelProperty(example="15282N4BYEwYh3j1dTgJu64Ey5qWn9Po9F", required=true, value="Defines the specific address to which the transaction has been sent.")
    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public AddressCoinsTransactionConfirmedEachConfirmationDataItem minedInBlock(AddressCoinsTransactionConfirmedEachConfirmationDataItemMinedInBlock minedInBlock) {
        this.minedInBlock = minedInBlock;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public AddressCoinsTransactionConfirmedEachConfirmationDataItemMinedInBlock getMinedInBlock() {
        return this.minedInBlock;
    }

    public void setMinedInBlock(AddressCoinsTransactionConfirmedEachConfirmationDataItemMinedInBlock minedInBlock) {
        this.minedInBlock = minedInBlock;
    }

    public AddressCoinsTransactionConfirmedEachConfirmationDataItem transactionId(String transactionId) {
        this.transactionId = transactionId;
        return this;
    }

    @ApiModelProperty(example="cbd3dea703bd2bc78bca69ee61ca14e6ffcdd809d07ebbc3b8fea3c30ea38f33", required=true, value="Defines the unique ID of the specific transaction, i.e. its identification number.")
    public String getTransactionId() {
        return this.transactionId;
    }

    public void setTransactionId(String transactionId) {
        this.transactionId = transactionId;
    }

    public AddressCoinsTransactionConfirmedEachConfirmationDataItem currentConfirmations(Integer currentConfirmations) {
        this.currentConfirmations = currentConfirmations;
        return this;
    }

    @ApiModelProperty(example="8", required=true, value="Defines the number of currently received confirmations for the transaction.")
    public Integer getCurrentConfirmations() {
        return this.currentConfirmations;
    }

    public void setCurrentConfirmations(Integer currentConfirmations) {
        this.currentConfirmations = currentConfirmations;
    }

    public AddressCoinsTransactionConfirmedEachConfirmationDataItem targetConfirmations(Integer targetConfirmations) {
        this.targetConfirmations = targetConfirmations;
        return this;
    }

    @ApiModelProperty(example="12", required=true, value="Defines the number of confirmation transactions requested as callbacks, i.e. the system can notify till the n-th confirmation.")
    public Integer getTargetConfirmations() {
        return this.targetConfirmations;
    }

    public void setTargetConfirmations(Integer targetConfirmations) {
        this.targetConfirmations = targetConfirmations;
    }

    public AddressCoinsTransactionConfirmedEachConfirmationDataItem amount(String amount) {
        this.amount = amount;
        return this;
    }

    @ApiModelProperty(example="0.0611", required=true, value="Defines the amount of coins sent with the confirmed transaction.")
    public String getAmount() {
        return this.amount;
    }

    public void setAmount(String amount) {
        this.amount = amount;
    }

    public AddressCoinsTransactionConfirmedEachConfirmationDataItem unit(String unit) {
        this.unit = unit;
        return this;
    }

    @ApiModelProperty(example="BTC", required=true, value="Defines the unit of the transaction, e.g. BTC.")
    public String getUnit() {
        return this.unit;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public AddressCoinsTransactionConfirmedEachConfirmationDataItem direction(DirectionEnum direction) {
        this.direction = direction;
        return this;
    }

    @ApiModelProperty(example="incoming", required=true, value="Defines whether the transaction is \"incoming\" or \"outgoing\".")
    public DirectionEnum getDirection() {
        return this.direction;
    }

    public void setDirection(DirectionEnum direction) {
        this.direction = direction;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AddressCoinsTransactionConfirmedEachConfirmationDataItem addressCoinsTransactionConfirmedEachConfirmationDataItem = (AddressCoinsTransactionConfirmedEachConfirmationDataItem)o;
        return Objects.equals(this.blockchain, addressCoinsTransactionConfirmedEachConfirmationDataItem.blockchain) && Objects.equals(this.network, addressCoinsTransactionConfirmedEachConfirmationDataItem.network) && Objects.equals(this.address, addressCoinsTransactionConfirmedEachConfirmationDataItem.address) && Objects.equals(this.minedInBlock, addressCoinsTransactionConfirmedEachConfirmationDataItem.minedInBlock) && Objects.equals(this.transactionId, addressCoinsTransactionConfirmedEachConfirmationDataItem.transactionId) && Objects.equals(this.currentConfirmations, addressCoinsTransactionConfirmedEachConfirmationDataItem.currentConfirmations) && Objects.equals(this.targetConfirmations, addressCoinsTransactionConfirmedEachConfirmationDataItem.targetConfirmations) && Objects.equals(this.amount, addressCoinsTransactionConfirmedEachConfirmationDataItem.amount) && Objects.equals(this.unit, addressCoinsTransactionConfirmedEachConfirmationDataItem.unit) && Objects.equals((Object)this.direction, (Object)addressCoinsTransactionConfirmedEachConfirmationDataItem.direction);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.blockchain, this.network, this.address, this.minedInBlock, this.transactionId, this.currentConfirmations, this.targetConfirmations, this.amount, this.unit, this.direction});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AddressCoinsTransactionConfirmedEachConfirmationDataItem {\n");
        sb.append("    blockchain: ").append(this.toIndentedString(this.blockchain)).append("\n");
        sb.append("    network: ").append(this.toIndentedString(this.network)).append("\n");
        sb.append("    address: ").append(this.toIndentedString(this.address)).append("\n");
        sb.append("    minedInBlock: ").append(this.toIndentedString(this.minedInBlock)).append("\n");
        sb.append("    transactionId: ").append(this.toIndentedString(this.transactionId)).append("\n");
        sb.append("    currentConfirmations: ").append(this.toIndentedString(this.currentConfirmations)).append("\n");
        sb.append("    targetConfirmations: ").append(this.toIndentedString(this.targetConfirmations)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    unit: ").append(this.toIndentedString(this.unit)).append("\n");
        sb.append("    direction: ").append(this.toIndentedString((Object)this.direction)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum DirectionEnum {
        INCOMING("incoming"),
        OUTGOING("outgoing");

        private String value;

        private DirectionEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static DirectionEnum fromValue(String value) {
            for (DirectionEnum b : DirectionEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<DirectionEnum> {
            public void write(JsonWriter jsonWriter, DirectionEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public DirectionEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return DirectionEnum.fromValue(value);
            }
        }
    }
}

