/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Objects;

@ApiModel(description="Defines an `item` as one result.")
public class AddressCoinsTransactionUnconfirmedDataItem {
    public static final String SERIALIZED_NAME_BLOCKCHAIN = "blockchain";
    @SerializedName(value="blockchain")
    private String blockchain;
    public static final String SERIALIZED_NAME_NETWORK = "network";
    @SerializedName(value="network")
    private String network;
    public static final String SERIALIZED_NAME_ADDRESS = "address";
    @SerializedName(value="address")
    private String address;
    public static final String SERIALIZED_NAME_TRANSACTION_ID = "transactionId";
    @SerializedName(value="transactionId")
    private String transactionId;
    public static final String SERIALIZED_NAME_AMOUNT = "amount";
    @SerializedName(value="amount")
    private String amount;
    public static final String SERIALIZED_NAME_UNIT = "unit";
    @SerializedName(value="unit")
    private UnitEnum unit;
    public static final String SERIALIZED_NAME_DIRECTION = "direction";
    @SerializedName(value="direction")
    private DirectionEnum direction;
    public static final String SERIALIZED_NAME_FIRST_SEEN_IN_MEMPOOL_TIMESTAMP = "firstSeenInMempoolTimestamp";
    @SerializedName(value="firstSeenInMempoolTimestamp")
    private Integer firstSeenInMempoolTimestamp;

    public AddressCoinsTransactionUnconfirmedDataItem blockchain(String blockchain) {
        this.blockchain = blockchain;
        return this;
    }

    @ApiModelProperty(example="bitcoin", required=true, value="Represents the specific blockchain protocol name, e.g. Ethereum, Bitcoin, etc.")
    public String getBlockchain() {
        return this.blockchain;
    }

    public void setBlockchain(String blockchain) {
        this.blockchain = blockchain;
    }

    public AddressCoinsTransactionUnconfirmedDataItem network(String network) {
        this.network = network;
        return this;
    }

    @ApiModelProperty(example="testnet", required=true, value="Represents the name of the blockchain network used; blockchain networks are usually identical as technology and software, but they differ in data, e.g. - \"mainnet\" is the live network with actual data while networks like \"testnet\", \"ropsten\", \"rinkeby\" are test networks.")
    public String getNetwork() {
        return this.network;
    }

    public void setNetwork(String network) {
        this.network = network;
    }

    public AddressCoinsTransactionUnconfirmedDataItem address(String address) {
        this.address = address;
        return this;
    }

    @ApiModelProperty(example="3CzKAnCXt7ePb5NCp5qrAEimrxjY81oLoT", required=true, value="Defines the specific address to which the coin transaction has been sent and is pending confirmation.")
    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public AddressCoinsTransactionUnconfirmedDataItem transactionId(String transactionId) {
        this.transactionId = transactionId;
        return this;
    }

    @ApiModelProperty(example="4b2159770f75a7200ea168eb56ebbf3303b025d838f743fb6e785bc32d5ac65b", required=true, value="Defines the unique ID of the specific transaction, i.e. its identification number.")
    public String getTransactionId() {
        return this.transactionId;
    }

    public void setTransactionId(String transactionId) {
        this.transactionId = transactionId;
    }

    public AddressCoinsTransactionUnconfirmedDataItem amount(String amount) {
        this.amount = amount;
        return this;
    }

    @ApiModelProperty(example="0.6508984", required=true, value="Defines the amount of coins sent with the transaction that is pending confirmation.")
    public String getAmount() {
        return this.amount;
    }

    public void setAmount(String amount) {
        this.amount = amount;
    }

    public AddressCoinsTransactionUnconfirmedDataItem unit(UnitEnum unit) {
        this.unit = unit;
        return this;
    }

    @ApiModelProperty(example="BTC", required=true, value="Defines the unit of the transaction, e.g. BTC.")
    public UnitEnum getUnit() {
        return this.unit;
    }

    public void setUnit(UnitEnum unit) {
        this.unit = unit;
    }

    public AddressCoinsTransactionUnconfirmedDataItem direction(DirectionEnum direction) {
        this.direction = direction;
        return this;
    }

    @ApiModelProperty(example="incoming", required=true, value="Defines whether the transaction is \"incoming\" or \"outgoing\".")
    public DirectionEnum getDirection() {
        return this.direction;
    }

    public void setDirection(DirectionEnum direction) {
        this.direction = direction;
    }

    public AddressCoinsTransactionUnconfirmedDataItem firstSeenInMempoolTimestamp(Integer firstSeenInMempoolTimestamp) {
        this.firstSeenInMempoolTimestamp = firstSeenInMempoolTimestamp;
        return this;
    }

    @ApiModelProperty(example="1610365615", required=true, value="Defines the exact time the transaction has been first accepted into the mempool to await confirmation as timestamp.")
    public Integer getFirstSeenInMempoolTimestamp() {
        return this.firstSeenInMempoolTimestamp;
    }

    public void setFirstSeenInMempoolTimestamp(Integer firstSeenInMempoolTimestamp) {
        this.firstSeenInMempoolTimestamp = firstSeenInMempoolTimestamp;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AddressCoinsTransactionUnconfirmedDataItem addressCoinsTransactionUnconfirmedDataItem = (AddressCoinsTransactionUnconfirmedDataItem)o;
        return Objects.equals(this.blockchain, addressCoinsTransactionUnconfirmedDataItem.blockchain) && Objects.equals(this.network, addressCoinsTransactionUnconfirmedDataItem.network) && Objects.equals(this.address, addressCoinsTransactionUnconfirmedDataItem.address) && Objects.equals(this.transactionId, addressCoinsTransactionUnconfirmedDataItem.transactionId) && Objects.equals(this.amount, addressCoinsTransactionUnconfirmedDataItem.amount) && Objects.equals((Object)this.unit, (Object)addressCoinsTransactionUnconfirmedDataItem.unit) && Objects.equals((Object)this.direction, (Object)addressCoinsTransactionUnconfirmedDataItem.direction) && Objects.equals(this.firstSeenInMempoolTimestamp, addressCoinsTransactionUnconfirmedDataItem.firstSeenInMempoolTimestamp);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.blockchain, this.network, this.address, this.transactionId, this.amount, this.unit, this.direction, this.firstSeenInMempoolTimestamp});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AddressCoinsTransactionUnconfirmedDataItem {\n");
        sb.append("    blockchain: ").append(this.toIndentedString(this.blockchain)).append("\n");
        sb.append("    network: ").append(this.toIndentedString(this.network)).append("\n");
        sb.append("    address: ").append(this.toIndentedString(this.address)).append("\n");
        sb.append("    transactionId: ").append(this.toIndentedString(this.transactionId)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    unit: ").append(this.toIndentedString((Object)this.unit)).append("\n");
        sb.append("    direction: ").append(this.toIndentedString((Object)this.direction)).append("\n");
        sb.append("    firstSeenInMempoolTimestamp: ").append(this.toIndentedString(this.firstSeenInMempoolTimestamp)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum DirectionEnum {
        INCOMING("incoming"),
        OUTGOING("outgoing");

        private String value;

        private DirectionEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static DirectionEnum fromValue(String value) {
            for (DirectionEnum b : DirectionEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<DirectionEnum> {
            public void write(JsonWriter jsonWriter, DirectionEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public DirectionEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return DirectionEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum UnitEnum {
        BTC("btc"),
        SATOSHI("satoshi"),
        WEI("wei"),
        GWEI("gwei"),
        ETH("eth"),
        DOGE("doge"),
        DASH("dash"),
        ETC("etc"),
        XRP("xrp"),
        ZIL("zil");

        private String value;

        private UnitEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static UnitEnum fromValue(String value) {
            for (UnitEnum b : UnitEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<UnitEnum> {
            public void write(JsonWriter jsonWriter, UnitEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public UnitEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return UnitEnum.fromValue(value);
            }
        }
    }
}

