/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Refers to the specific block the transaction was mined in.")
public class AddressTokensTransactionConfirmedDataItemMinedInBlock {
    public static final String SERIALIZED_NAME_HEIGHT = "height";
    @SerializedName(value="height")
    private Integer height;
    public static final String SERIALIZED_NAME_HASH = "hash";
    @SerializedName(value="hash")
    private String hash;
    public static final String SERIALIZED_NAME_TIMESTAMP = "timestamp";
    @SerializedName(value="timestamp")
    private Integer timestamp;

    public AddressTokensTransactionConfirmedDataItemMinedInBlock height(Integer height) {
        this.height = height;
        return this;
    }

    @ApiModelProperty(example="657915", required=true, value="Defines the number of blocks in the blockchain preceding this specific block.")
    public Integer getHeight() {
        return this.height;
    }

    public void setHeight(Integer height) {
        this.height = height;
    }

    public AddressTokensTransactionConfirmedDataItemMinedInBlock hash(String hash) {
        this.hash = hash;
        return this;
    }

    @ApiModelProperty(example="269b0de44db95beddb6aecc520b375ba8f91f3dc5558a24aa4c26979eb00c7e2", required=true, value="Represents the hash of the block's header, i.e. an output that has a fixed length.")
    public String getHash() {
        return this.hash;
    }

    public void setHash(String hash) {
        this.hash = hash;
    }

    public AddressTokensTransactionConfirmedDataItemMinedInBlock timestamp(Integer timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    @ApiModelProperty(example="1586365500", required=true, value="Defines the exact date/time when this transaction was mined in seconds since Unix Epoch time.")
    public Integer getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(Integer timestamp) {
        this.timestamp = timestamp;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AddressTokensTransactionConfirmedDataItemMinedInBlock addressTokensTransactionConfirmedDataItemMinedInBlock = (AddressTokensTransactionConfirmedDataItemMinedInBlock)o;
        return Objects.equals(this.height, addressTokensTransactionConfirmedDataItemMinedInBlock.height) && Objects.equals(this.hash, addressTokensTransactionConfirmedDataItemMinedInBlock.hash) && Objects.equals(this.timestamp, addressTokensTransactionConfirmedDataItemMinedInBlock.timestamp);
    }

    public int hashCode() {
        return Objects.hash(this.height, this.hash, this.timestamp);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AddressTokensTransactionConfirmedDataItemMinedInBlock {\n");
        sb.append("    height: ").append(this.toIndentedString(this.height)).append("\n");
        sb.append("    hash: ").append(this.toIndentedString(this.hash)).append("\n");
        sb.append("    timestamp: ").append(this.toIndentedString(this.timestamp)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

