/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Objects;
import org.openapitools.client.model.AddressTokensTransactionConfirmedEachConfirmationDataItemMinedInBlock;
import org.openapitools.client.model.AddressTokensTransactionConfirmedEachConfirmationToken;

@ApiModel(description="Defines an `item` as one result.")
public class AddressTokensTransactionConfirmedEachConfirmationDataItem {
    public static final String SERIALIZED_NAME_BLOCKCHAIN = "blockchain";
    @SerializedName(value="blockchain")
    private String blockchain;
    public static final String SERIALIZED_NAME_NETWORK = "network";
    @SerializedName(value="network")
    private String network;
    public static final String SERIALIZED_NAME_ADDRESS = "address";
    @SerializedName(value="address")
    private String address;
    public static final String SERIALIZED_NAME_MINED_IN_BLOCK = "minedInBlock";
    @SerializedName(value="minedInBlock")
    private AddressTokensTransactionConfirmedEachConfirmationDataItemMinedInBlock minedInBlock;
    public static final String SERIALIZED_NAME_TRANSACTION_ID = "transactionId";
    @SerializedName(value="transactionId")
    private String transactionId;
    public static final String SERIALIZED_NAME_CURRENT_CONFIRMATIONS = "currentConfirmations";
    @SerializedName(value="currentConfirmations")
    private Integer currentConfirmations;
    public static final String SERIALIZED_NAME_TARGET_CONFIRMATIONS = "targetConfirmations";
    @SerializedName(value="targetConfirmations")
    private Integer targetConfirmations;
    public static final String SERIALIZED_NAME_TOKEN_TYPE = "tokenType";
    @SerializedName(value="tokenType")
    private TokenTypeEnum tokenType;
    public static final String SERIALIZED_NAME_TOKEN = "token";
    @SerializedName(value="token")
    private AddressTokensTransactionConfirmedEachConfirmationToken token;
    public static final String SERIALIZED_NAME_DIRECTION = "direction";
    @SerializedName(value="direction")
    private DirectionEnum direction;

    public AddressTokensTransactionConfirmedEachConfirmationDataItem blockchain(String blockchain) {
        this.blockchain = blockchain;
        return this;
    }

    @ApiModelProperty(example="bitcoin", required=true, value="Represents the specific blockchain protocol name, e.g. Ethereum, Bitcoin, etc.")
    public String getBlockchain() {
        return this.blockchain;
    }

    public void setBlockchain(String blockchain) {
        this.blockchain = blockchain;
    }

    public AddressTokensTransactionConfirmedEachConfirmationDataItem network(String network) {
        this.network = network;
        return this;
    }

    @ApiModelProperty(example="testnet", required=true, value="Represents the name of the blockchain network used; blockchain networks are usually identical as technology and software, but they differ in data, e.g. - \"mainnet\" is the live network with actual data while networks like \"testnet\", \"ropsten\", \"rinkeby\" are test networks.")
    public String getNetwork() {
        return this.network;
    }

    public void setNetwork(String network) {
        this.network = network;
    }

    public AddressTokensTransactionConfirmedEachConfirmationDataItem address(String address) {
        this.address = address;
        return this;
    }

    @ApiModelProperty(example="12dRugNcdxK39288NjcDV4GX7rMsKCGn6B", required=true, value="Defines the specific address to which the transaction has been sent.")
    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public AddressTokensTransactionConfirmedEachConfirmationDataItem minedInBlock(AddressTokensTransactionConfirmedEachConfirmationDataItemMinedInBlock minedInBlock) {
        this.minedInBlock = minedInBlock;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public AddressTokensTransactionConfirmedEachConfirmationDataItemMinedInBlock getMinedInBlock() {
        return this.minedInBlock;
    }

    public void setMinedInBlock(AddressTokensTransactionConfirmedEachConfirmationDataItemMinedInBlock minedInBlock) {
        this.minedInBlock = minedInBlock;
    }

    public AddressTokensTransactionConfirmedEachConfirmationDataItem transactionId(String transactionId) {
        this.transactionId = transactionId;
        return this;
    }

    @ApiModelProperty(example="c2163e3a0ac22a7256fd1e8b0391a27e3479723e72f5efed1676d0eea9ed6ef4", required=true, value="Defines the unique ID of the specific transaction, i.e. its identification number.")
    public String getTransactionId() {
        return this.transactionId;
    }

    public void setTransactionId(String transactionId) {
        this.transactionId = transactionId;
    }

    public AddressTokensTransactionConfirmedEachConfirmationDataItem currentConfirmations(Integer currentConfirmations) {
        this.currentConfirmations = currentConfirmations;
        return this;
    }

    @ApiModelProperty(example="6", required=true, value="Defines the number of currently received confirmations for the transaction.")
    public Integer getCurrentConfirmations() {
        return this.currentConfirmations;
    }

    public void setCurrentConfirmations(Integer currentConfirmations) {
        this.currentConfirmations = currentConfirmations;
    }

    public AddressTokensTransactionConfirmedEachConfirmationDataItem targetConfirmations(Integer targetConfirmations) {
        this.targetConfirmations = targetConfirmations;
        return this;
    }

    @ApiModelProperty(example="15", required=true, value="Defines the number of confirmation transactions requested as callbacks, i.e. the system can notify till the n-th confirmation.")
    public Integer getTargetConfirmations() {
        return this.targetConfirmations;
    }

    public void setTargetConfirmations(Integer targetConfirmations) {
        this.targetConfirmations = targetConfirmations;
    }

    public AddressTokensTransactionConfirmedEachConfirmationDataItem tokenType(TokenTypeEnum tokenType) {
        this.tokenType = tokenType;
        return this;
    }

    @ApiModelProperty(example="It could be one of: \"ethereumERC20Token\", \"ethereumERC721Token\", \"omniLayerToken\"", required=true, value="Defines the type of token sent with the transaction, e.g. ERC 20.")
    public TokenTypeEnum getTokenType() {
        return this.tokenType;
    }

    public void setTokenType(TokenTypeEnum tokenType) {
        this.tokenType = tokenType;
    }

    public AddressTokensTransactionConfirmedEachConfirmationDataItem token(AddressTokensTransactionConfirmedEachConfirmationToken token) {
        this.token = token;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public AddressTokensTransactionConfirmedEachConfirmationToken getToken() {
        return this.token;
    }

    public void setToken(AddressTokensTransactionConfirmedEachConfirmationToken token) {
        this.token = token;
    }

    public AddressTokensTransactionConfirmedEachConfirmationDataItem direction(DirectionEnum direction) {
        this.direction = direction;
        return this;
    }

    @ApiModelProperty(example="incoming", required=true, value="Defines whether the transaction is \"incoming\" or \"outgoing\".")
    public DirectionEnum getDirection() {
        return this.direction;
    }

    public void setDirection(DirectionEnum direction) {
        this.direction = direction;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AddressTokensTransactionConfirmedEachConfirmationDataItem addressTokensTransactionConfirmedEachConfirmationDataItem = (AddressTokensTransactionConfirmedEachConfirmationDataItem)o;
        return Objects.equals(this.blockchain, addressTokensTransactionConfirmedEachConfirmationDataItem.blockchain) && Objects.equals(this.network, addressTokensTransactionConfirmedEachConfirmationDataItem.network) && Objects.equals(this.address, addressTokensTransactionConfirmedEachConfirmationDataItem.address) && Objects.equals(this.minedInBlock, addressTokensTransactionConfirmedEachConfirmationDataItem.minedInBlock) && Objects.equals(this.transactionId, addressTokensTransactionConfirmedEachConfirmationDataItem.transactionId) && Objects.equals(this.currentConfirmations, addressTokensTransactionConfirmedEachConfirmationDataItem.currentConfirmations) && Objects.equals(this.targetConfirmations, addressTokensTransactionConfirmedEachConfirmationDataItem.targetConfirmations) && Objects.equals((Object)this.tokenType, (Object)addressTokensTransactionConfirmedEachConfirmationDataItem.tokenType) && Objects.equals(this.token, addressTokensTransactionConfirmedEachConfirmationDataItem.token) && Objects.equals((Object)this.direction, (Object)addressTokensTransactionConfirmedEachConfirmationDataItem.direction);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.blockchain, this.network, this.address, this.minedInBlock, this.transactionId, this.currentConfirmations, this.targetConfirmations, this.tokenType, this.token, this.direction});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AddressTokensTransactionConfirmedEachConfirmationDataItem {\n");
        sb.append("    blockchain: ").append(this.toIndentedString(this.blockchain)).append("\n");
        sb.append("    network: ").append(this.toIndentedString(this.network)).append("\n");
        sb.append("    address: ").append(this.toIndentedString(this.address)).append("\n");
        sb.append("    minedInBlock: ").append(this.toIndentedString(this.minedInBlock)).append("\n");
        sb.append("    transactionId: ").append(this.toIndentedString(this.transactionId)).append("\n");
        sb.append("    currentConfirmations: ").append(this.toIndentedString(this.currentConfirmations)).append("\n");
        sb.append("    targetConfirmations: ").append(this.toIndentedString(this.targetConfirmations)).append("\n");
        sb.append("    tokenType: ").append(this.toIndentedString((Object)this.tokenType)).append("\n");
        sb.append("    token: ").append(this.toIndentedString(this.token)).append("\n");
        sb.append("    direction: ").append(this.toIndentedString((Object)this.direction)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum DirectionEnum {
        INCOMING("incoming"),
        OUTGOING("outgoing");

        private String value;

        private DirectionEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static DirectionEnum fromValue(String value) {
            for (DirectionEnum b : DirectionEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<DirectionEnum> {
            public void write(JsonWriter jsonWriter, DirectionEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public DirectionEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return DirectionEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum TokenTypeEnum {
        ETHEREUMERC20TOKEN("ethereumERC20Token"),
        ETHEREUMERC721TOKEN("ethereumERC721Token"),
        OMNILAYERTOKEN("omniLayerToken");

        private String value;

        private TokenTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static TokenTypeEnum fromValue(String value) {
            for (TokenTypeEnum b : TokenTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<TokenTypeEnum> {
            public void write(JsonWriter jsonWriter, TokenTypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public TokenTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return TokenTypeEnum.fromValue(value);
            }
        }
    }
}

