/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Defines an `item` as one result.")
public class BlockMinedDataItem {
    public static final String SERIALIZED_NAME_BLOCKCHAIN = "blockchain";
    @SerializedName(value="blockchain")
    private String blockchain;
    public static final String SERIALIZED_NAME_NETWORK = "network";
    @SerializedName(value="network")
    private String network;
    public static final String SERIALIZED_NAME_HEIGHT = "height";
    @SerializedName(value="height")
    private Integer height;
    public static final String SERIALIZED_NAME_HASH = "hash";
    @SerializedName(value="hash")
    private String hash;
    public static final String SERIALIZED_NAME_TIMESTAMP = "timestamp";
    @SerializedName(value="timestamp")
    private Integer timestamp;

    public BlockMinedDataItem blockchain(String blockchain) {
        this.blockchain = blockchain;
        return this;
    }

    @ApiModelProperty(example="bitcoin", required=true, value="Represents the specific blockchain protocol name, e.g. Ethereum, Bitcoin, etc.")
    public String getBlockchain() {
        return this.blockchain;
    }

    public void setBlockchain(String blockchain) {
        this.blockchain = blockchain;
    }

    public BlockMinedDataItem network(String network) {
        this.network = network;
        return this;
    }

    @ApiModelProperty(example="testnet", required=true, value="Represents the name of the blockchain network used; blockchain networks are usually identical as technology and software, but they differ in data, e.g. - \"mainnet\" is the live network with actual data while networks like \"testnet\", \"ropsten\", \"rinkeby\" are test networks.")
    public String getNetwork() {
        return this.network;
    }

    public void setNetwork(String network) {
        this.network = network;
    }

    public BlockMinedDataItem height(Integer height) {
        this.height = height;
        return this;
    }

    @ApiModelProperty(example="570008", required=true, value="Defines the number of blocks in the blockchain preceding this specific block.")
    public Integer getHeight() {
        return this.height;
    }

    public void setHeight(Integer height) {
        this.height = height;
    }

    public BlockMinedDataItem hash(String hash) {
        this.hash = hash;
        return this;
    }

    @ApiModelProperty(example="00000000000000000006ddb5e854505f8b792122b0ac9469c07eb26db414f6fb", required=true, value="Represents the hash of the block's header, i.e. an output that has a fixed length.")
    public String getHash() {
        return this.hash;
    }

    public void setHash(String hash) {
        this.hash = hash;
    }

    public BlockMinedDataItem timestamp(Integer timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    @ApiModelProperty(example="1610365615", required=true, value="Defines the exact date/time when this block was mined in seconds since Unix Epoch time.")
    public Integer getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(Integer timestamp) {
        this.timestamp = timestamp;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BlockMinedDataItem blockMinedDataItem = (BlockMinedDataItem)o;
        return Objects.equals(this.blockchain, blockMinedDataItem.blockchain) && Objects.equals(this.network, blockMinedDataItem.network) && Objects.equals(this.height, blockMinedDataItem.height) && Objects.equals(this.hash, blockMinedDataItem.hash) && Objects.equals(this.timestamp, blockMinedDataItem.timestamp);
    }

    public int hashCode() {
        return Objects.hash(this.blockchain, this.network, this.height, this.hash, this.timestamp);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BlockMinedDataItem {\n");
        sb.append("    blockchain: ").append(this.toIndentedString(this.blockchain)).append("\n");
        sb.append("    network: ").append(this.toIndentedString(this.network)).append("\n");
        sb.append("    height: ").append(this.toIndentedString(this.height)).append("\n");
        sb.append("    hash: ").append(this.toIndentedString(this.hash)).append("\n");
        sb.append("    timestamp: ").append(this.toIndentedString(this.timestamp)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

