/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Defines an `item` as one result.")
public class BroadcastTransactionFailDataItem {
    public static final String SERIALIZED_NAME_BLOCKCHAIN = "blockchain";
    @SerializedName(value="blockchain")
    private String blockchain;
    public static final String SERIALIZED_NAME_NETWORK = "network";
    @SerializedName(value="network")
    private String network;
    public static final String SERIALIZED_NAME_TRANSACTION_ID = "transactionId";
    @SerializedName(value="transactionId")
    private String transactionId;
    public static final String SERIALIZED_NAME_ERROR_MESSAGE = "errorMessage";
    @SerializedName(value="errorMessage")
    private String errorMessage;

    public BroadcastTransactionFailDataItem blockchain(String blockchain) {
        this.blockchain = blockchain;
        return this;
    }

    @ApiModelProperty(example="Bitcoin/Ethereum (whichever applicable)", required=true, value="Represents the specific blockchain protocol name, e.g. Ethereum, Bitcoin, etc.")
    public String getBlockchain() {
        return this.blockchain;
    }

    public void setBlockchain(String blockchain) {
        this.blockchain = blockchain;
    }

    public BroadcastTransactionFailDataItem network(String network) {
        this.network = network;
        return this;
    }

    @ApiModelProperty(example="Testnet/Mainnet (whichever applicable)", required=true, value="Represents the name of the blockchain network used; blockchain networks are usually identical as technology and software, but they differ in data, e.g. - \"mainnet\" is the live network with actual data while networks like \"testnet\", \"ropsten\", \"rinkeby\" are test networks.")
    public String getNetwork() {
        return this.network;
    }

    public void setNetwork(String network) {
        this.network = network;
    }

    public BroadcastTransactionFailDataItem transactionId(String transactionId) {
        this.transactionId = transactionId;
        return this;
    }

    @ApiModelProperty(example="d83c75dd0f73425a1a85023ba25bc7ff47333c823a0ea19fac28d4abe59fd612", required=true, value="Defines the unique ID of the specific transaction, i.e. its identification number.")
    public String getTransactionId() {
        return this.transactionId;
    }

    public void setTransactionId(String transactionId) {
        this.transactionId = transactionId;
    }

    public BroadcastTransactionFailDataItem errorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
        return this;
    }

    @ApiModelProperty(example="Transaction already in block chain", required=true, value="Represents the error message received for the transaction.")
    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BroadcastTransactionFailDataItem broadcastTransactionFailDataItem = (BroadcastTransactionFailDataItem)o;
        return Objects.equals(this.blockchain, broadcastTransactionFailDataItem.blockchain) && Objects.equals(this.network, broadcastTransactionFailDataItem.network) && Objects.equals(this.transactionId, broadcastTransactionFailDataItem.transactionId) && Objects.equals(this.errorMessage, broadcastTransactionFailDataItem.errorMessage);
    }

    public int hashCode() {
        return Objects.hash(this.blockchain, this.network, this.transactionId, this.errorMessage);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BroadcastTransactionFailDataItem {\n");
        sb.append("    blockchain: ").append(this.toIndentedString(this.blockchain)).append("\n");
        sb.append("    network: ").append(this.toIndentedString(this.network)).append("\n");
        sb.append("    transactionId: ").append(this.toIndentedString(this.transactionId)).append("\n");
        sb.append("    errorMessage: ").append(this.toIndentedString(this.errorMessage)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

