/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Defines an `item` as one result.")
public class BroadcastTransactionSuccessDataItem {
    public static final String SERIALIZED_NAME_BLOCKCHAIN = "blockchain";
    @SerializedName(value="blockchain")
    private String blockchain;
    public static final String SERIALIZED_NAME_NETWORK = "network";
    @SerializedName(value="network")
    private String network;
    public static final String SERIALIZED_NAME_TRANSACTION_ID = "transactionId";
    @SerializedName(value="transactionId")
    private String transactionId;

    public BroadcastTransactionSuccessDataItem blockchain(String blockchain) {
        this.blockchain = blockchain;
        return this;
    }

    @ApiModelProperty(example="Bitcoin/Ethereum (whichever applicable)", required=true, value="Represents the specific blockchain protocol name, e.g. Ethereum, Bitcoin, etc.")
    public String getBlockchain() {
        return this.blockchain;
    }

    public void setBlockchain(String blockchain) {
        this.blockchain = blockchain;
    }

    public BroadcastTransactionSuccessDataItem network(String network) {
        this.network = network;
        return this;
    }

    @ApiModelProperty(example="Testnet/Mainnet (whichever applicable)", required=true, value="Represents the name of the blockchain network used; blockchain networks are usually identical as technology and software, but they differ in data, e.g. - \"mainnet\" is the live network with actual data while networks like \"testnet\", \"ropsten\", \"rinkeby\" are test networks.")
    public String getNetwork() {
        return this.network;
    }

    public void setNetwork(String network) {
        this.network = network;
    }

    public BroadcastTransactionSuccessDataItem transactionId(String transactionId) {
        this.transactionId = transactionId;
        return this;
    }

    @ApiModelProperty(example="347d96855d41b77f1e23048fff11c18e9fe699ee69b0b402338f34189734e0a2", required=true, value="Defines the unique ID of the specific transaction, i.e. its identification number.")
    public String getTransactionId() {
        return this.transactionId;
    }

    public void setTransactionId(String transactionId) {
        this.transactionId = transactionId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BroadcastTransactionSuccessDataItem broadcastTransactionSuccessDataItem = (BroadcastTransactionSuccessDataItem)o;
        return Objects.equals(this.blockchain, broadcastTransactionSuccessDataItem.blockchain) && Objects.equals(this.network, broadcastTransactionSuccessDataItem.network) && Objects.equals(this.transactionId, broadcastTransactionSuccessDataItem.transactionId);
    }

    public int hashCode() {
        return Objects.hash(this.blockchain, this.network, this.transactionId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BroadcastTransactionSuccessDataItem {\n");
        sb.append("    blockchain: ").append(this.toIndentedString(this.blockchain)).append("\n");
        sb.append("    network: ").append(this.toIndentedString(this.network)).append("\n");
        sb.append("    transactionId: ").append(this.toIndentedString(this.transactionId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

