/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Defines an `item` as one result.")
public class CoinsForwardingSuccessDataItem {
    public static final String SERIALIZED_NAME_BLOCKCHAIN = "blockchain";
    @SerializedName(value="blockchain")
    private String blockchain;
    public static final String SERIALIZED_NAME_NETWORK = "network";
    @SerializedName(value="network")
    private String network;
    public static final String SERIALIZED_NAME_FROM_ADDRESS = "fromAddress";
    @SerializedName(value="fromAddress")
    private String fromAddress;
    public static final String SERIALIZED_NAME_TO_ADDRESS = "toAddress";
    @SerializedName(value="toAddress")
    private String toAddress;
    public static final String SERIALIZED_NAME_FORWARDED_AMOUNT = "forwardedAmount";
    @SerializedName(value="forwardedAmount")
    private String forwardedAmount;
    public static final String SERIALIZED_NAME_FORWARDED_UNIT = "forwardedUnit";
    @SerializedName(value="forwardedUnit")
    private String forwardedUnit;
    public static final String SERIALIZED_NAME_SPENT_FEES_AMOUNT = "spentFeesAmount";
    @SerializedName(value="spentFeesAmount")
    private String spentFeesAmount;
    public static final String SERIALIZED_NAME_SPENT_FEES_UNIT = "spentFeesUnit";
    @SerializedName(value="spentFeesUnit")
    private String spentFeesUnit;
    public static final String SERIALIZED_NAME_TRIGGER_TRANSACTION_ID = "triggerTransactionId";
    @SerializedName(value="triggerTransactionId")
    private String triggerTransactionId;
    public static final String SERIALIZED_NAME_FORWARDING_TRANSACTION_ID = "forwardingTransactionId";
    @SerializedName(value="forwardingTransactionId")
    private String forwardingTransactionId;

    public CoinsForwardingSuccessDataItem blockchain(String blockchain) {
        this.blockchain = blockchain;
        return this;
    }

    @ApiModelProperty(example="bitcoin", required=true, value="Represents the specific blockchain protocol name, e.g. Ethereum, Bitcoin, etc.")
    public String getBlockchain() {
        return this.blockchain;
    }

    public void setBlockchain(String blockchain) {
        this.blockchain = blockchain;
    }

    public CoinsForwardingSuccessDataItem network(String network) {
        this.network = network;
        return this;
    }

    @ApiModelProperty(example="testnet", required=true, value="Represents the name of the blockchain network used; blockchain networks are usually identical as technology and software, but they differ in data, e.g. - \"mainnet\" is the live network with actual data while networks like \"testnet\", \"ropsten\", \"rinkeby\" are test networks.")
    public String getNetwork() {
        return this.network;
    }

    public void setNetwork(String network) {
        this.network = network;
    }

    public CoinsForwardingSuccessDataItem fromAddress(String fromAddress) {
        this.fromAddress = fromAddress;
        return this;
    }

    @ApiModelProperty(example="mmd963W1fECjLyaDCHcioSCZYHkRwjkGST", required=true, value="Represents the hash of the address that provides the coins.")
    public String getFromAddress() {
        return this.fromAddress;
    }

    public void setFromAddress(String fromAddress) {
        this.fromAddress = fromAddress;
    }

    public CoinsForwardingSuccessDataItem toAddress(String toAddress) {
        this.toAddress = toAddress;
        return this;
    }

    @ApiModelProperty(example="ms4KNsbNpoU8g424pzmEjbkFbfAHae1msB", required=true, value="Represents the hash of the address to forward the coins to.")
    public String getToAddress() {
        return this.toAddress;
    }

    public void setToAddress(String toAddress) {
        this.toAddress = toAddress;
    }

    public CoinsForwardingSuccessDataItem forwardedAmount(String forwardedAmount) {
        this.forwardedAmount = forwardedAmount;
        return this;
    }

    @ApiModelProperty(example="00059441", required=true, value="Represents the amount of coins that have been forwarded.")
    public String getForwardedAmount() {
        return this.forwardedAmount;
    }

    public void setForwardedAmount(String forwardedAmount) {
        this.forwardedAmount = forwardedAmount;
    }

    public CoinsForwardingSuccessDataItem forwardedUnit(String forwardedUnit) {
        this.forwardedUnit = forwardedUnit;
        return this;
    }

    @ApiModelProperty(example="BTC", required=true, value="Represents the unit of coins that have been forwarded, e.g. BTC.")
    public String getForwardedUnit() {
        return this.forwardedUnit;
    }

    public void setForwardedUnit(String forwardedUnit) {
        this.forwardedUnit = forwardedUnit;
    }

    public CoinsForwardingSuccessDataItem spentFeesAmount(String spentFeesAmount) {
        this.spentFeesAmount = spentFeesAmount;
        return this;
    }

    @ApiModelProperty(example="0.00022827", required=true, value="Represents the amount of the fee spent for the coins to be forwarded.")
    public String getSpentFeesAmount() {
        return this.spentFeesAmount;
    }

    public void setSpentFeesAmount(String spentFeesAmount) {
        this.spentFeesAmount = spentFeesAmount;
    }

    public CoinsForwardingSuccessDataItem spentFeesUnit(String spentFeesUnit) {
        this.spentFeesUnit = spentFeesUnit;
        return this;
    }

    @ApiModelProperty(example="BTC", required=true, value="Represents the unit of the fee spent for the coins to be forwarded, e.g. BTC.")
    public String getSpentFeesUnit() {
        return this.spentFeesUnit;
    }

    public void setSpentFeesUnit(String spentFeesUnit) {
        this.spentFeesUnit = spentFeesUnit;
    }

    public CoinsForwardingSuccessDataItem triggerTransactionId(String triggerTransactionId) {
        this.triggerTransactionId = triggerTransactionId;
        return this;
    }

    @ApiModelProperty(example="86a7546bde4ac28b34504909d138592a6d6fc1277ea1f8f2f9c75dc04bdf3b7b", required=true, value="Defines the unique Transaction ID that triggered the coin forwarding.")
    public String getTriggerTransactionId() {
        return this.triggerTransactionId;
    }

    public void setTriggerTransactionId(String triggerTransactionId) {
        this.triggerTransactionId = triggerTransactionId;
    }

    public CoinsForwardingSuccessDataItem forwardingTransactionId(String forwardingTransactionId) {
        this.forwardingTransactionId = forwardingTransactionId;
        return this;
    }

    @ApiModelProperty(example="2241b5264fac8acb92e9fc597035b99cdd22f6578d63c6f52b099729f7c4f979", required=true, value="Defines the unique Transaction ID that forwarded the coins.")
    public String getForwardingTransactionId() {
        return this.forwardingTransactionId;
    }

    public void setForwardingTransactionId(String forwardingTransactionId) {
        this.forwardingTransactionId = forwardingTransactionId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CoinsForwardingSuccessDataItem coinsForwardingSuccessDataItem = (CoinsForwardingSuccessDataItem)o;
        return Objects.equals(this.blockchain, coinsForwardingSuccessDataItem.blockchain) && Objects.equals(this.network, coinsForwardingSuccessDataItem.network) && Objects.equals(this.fromAddress, coinsForwardingSuccessDataItem.fromAddress) && Objects.equals(this.toAddress, coinsForwardingSuccessDataItem.toAddress) && Objects.equals(this.forwardedAmount, coinsForwardingSuccessDataItem.forwardedAmount) && Objects.equals(this.forwardedUnit, coinsForwardingSuccessDataItem.forwardedUnit) && Objects.equals(this.spentFeesAmount, coinsForwardingSuccessDataItem.spentFeesAmount) && Objects.equals(this.spentFeesUnit, coinsForwardingSuccessDataItem.spentFeesUnit) && Objects.equals(this.triggerTransactionId, coinsForwardingSuccessDataItem.triggerTransactionId) && Objects.equals(this.forwardingTransactionId, coinsForwardingSuccessDataItem.forwardingTransactionId);
    }

    public int hashCode() {
        return Objects.hash(this.blockchain, this.network, this.fromAddress, this.toAddress, this.forwardedAmount, this.forwardedUnit, this.spentFeesAmount, this.spentFeesUnit, this.triggerTransactionId, this.forwardingTransactionId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CoinsForwardingSuccessDataItem {\n");
        sb.append("    blockchain: ").append(this.toIndentedString(this.blockchain)).append("\n");
        sb.append("    network: ").append(this.toIndentedString(this.network)).append("\n");
        sb.append("    fromAddress: ").append(this.toIndentedString(this.fromAddress)).append("\n");
        sb.append("    toAddress: ").append(this.toIndentedString(this.toAddress)).append("\n");
        sb.append("    forwardedAmount: ").append(this.toIndentedString(this.forwardedAmount)).append("\n");
        sb.append("    forwardedUnit: ").append(this.toIndentedString(this.forwardedUnit)).append("\n");
        sb.append("    spentFeesAmount: ").append(this.toIndentedString(this.spentFeesAmount)).append("\n");
        sb.append("    spentFeesUnit: ").append(this.toIndentedString(this.spentFeesUnit)).append("\n");
        sb.append("    triggerTransactionId: ").append(this.toIndentedString(this.triggerTransactionId)).append("\n");
        sb.append("    forwardingTransactionId: ").append(this.toIndentedString(this.forwardingTransactionId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

