/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.openapitools.client.model.CreateCoinsTransactionRequestFromAddressRIRecipients;
import org.openapitools.client.model.CreateCoinsTransactionRequestFromAddressRISenders;

public class CreateCoinsTransactionRequestFromAddressRI {
    public static final String SERIALIZED_NAME_CALLBACK_SECRET_KEY = "callbackSecretKey";
    @SerializedName(value="callbackSecretKey")
    private String callbackSecretKey;
    public static final String SERIALIZED_NAME_CALLBACK_URL = "callbackUrl";
    @SerializedName(value="callbackUrl")
    private String callbackUrl;
    public static final String SERIALIZED_NAME_FEE_PRIORITY = "feePriority";
    @SerializedName(value="feePriority")
    private FeePriorityEnum feePriority;
    public static final String SERIALIZED_NAME_RECIPIENTS = "recipients";
    @SerializedName(value="recipients")
    private List<CreateCoinsTransactionRequestFromAddressRIRecipients> recipients = new ArrayList<CreateCoinsTransactionRequestFromAddressRIRecipients>();
    public static final String SERIALIZED_NAME_SENDERS = "senders";
    @SerializedName(value="senders")
    private CreateCoinsTransactionRequestFromAddressRISenders senders;
    public static final String SERIALIZED_NAME_TRANSACTION_REQUEST_STATUS = "transactionRequestStatus";
    @SerializedName(value="transactionRequestStatus")
    private TransactionRequestStatusEnum transactionRequestStatus;

    public CreateCoinsTransactionRequestFromAddressRI callbackSecretKey(String callbackSecretKey) {
        this.callbackSecretKey = callbackSecretKey;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="yourSecretString", value="Represents the Secret Key value provided by the customer. This field is used for security purposes during the callback notification, in order to prove the sender of the callback as Crypto APIs.")
    public String getCallbackSecretKey() {
        return this.callbackSecretKey;
    }

    public void setCallbackSecretKey(String callbackSecretKey) {
        this.callbackSecretKey = callbackSecretKey;
    }

    public CreateCoinsTransactionRequestFromAddressRI callbackUrl(String callbackUrl) {
        this.callbackUrl = callbackUrl;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="https://example.com", value="Verified URL for sending callbacks")
    public String getCallbackUrl() {
        return this.callbackUrl;
    }

    public void setCallbackUrl(String callbackUrl) {
        this.callbackUrl = callbackUrl;
    }

    public CreateCoinsTransactionRequestFromAddressRI feePriority(FeePriorityEnum feePriority) {
        this.feePriority = feePriority;
        return this;
    }

    @ApiModelProperty(example="standard", required=true, value="Represents the fee priority of the automation, whether it is \"slow\", \"standard\" or \"fast\".")
    public FeePriorityEnum getFeePriority() {
        return this.feePriority;
    }

    public void setFeePriority(FeePriorityEnum feePriority) {
        this.feePriority = feePriority;
    }

    public CreateCoinsTransactionRequestFromAddressRI recipients(List<CreateCoinsTransactionRequestFromAddressRIRecipients> recipients) {
        this.recipients = recipients;
        return this;
    }

    public CreateCoinsTransactionRequestFromAddressRI addRecipientsItem(CreateCoinsTransactionRequestFromAddressRIRecipients recipientsItem) {
        this.recipients.add(recipientsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="Defines the destination for the transaction, i.e. the recipient(s).")
    public List<CreateCoinsTransactionRequestFromAddressRIRecipients> getRecipients() {
        return this.recipients;
    }

    public void setRecipients(List<CreateCoinsTransactionRequestFromAddressRIRecipients> recipients) {
        this.recipients = recipients;
    }

    public CreateCoinsTransactionRequestFromAddressRI senders(CreateCoinsTransactionRequestFromAddressRISenders senders) {
        this.senders = senders;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public CreateCoinsTransactionRequestFromAddressRISenders getSenders() {
        return this.senders;
    }

    public void setSenders(CreateCoinsTransactionRequestFromAddressRISenders senders) {
        this.senders = senders;
    }

    public CreateCoinsTransactionRequestFromAddressRI transactionRequestStatus(TransactionRequestStatusEnum transactionRequestStatus) {
        this.transactionRequestStatus = transactionRequestStatus;
        return this;
    }

    @ApiModelProperty(example="created", required=true, value="Defines the status of the transaction request, e.g. \"created, \"await_approval\", \"pending\", \"prepared\", \"signed\", \"broadcasted\", \"success\", \"failed\", \"rejected\", mined\".")
    public TransactionRequestStatusEnum getTransactionRequestStatus() {
        return this.transactionRequestStatus;
    }

    public void setTransactionRequestStatus(TransactionRequestStatusEnum transactionRequestStatus) {
        this.transactionRequestStatus = transactionRequestStatus;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateCoinsTransactionRequestFromAddressRI createCoinsTransactionRequestFromAddressRI = (CreateCoinsTransactionRequestFromAddressRI)o;
        return Objects.equals(this.callbackSecretKey, createCoinsTransactionRequestFromAddressRI.callbackSecretKey) && Objects.equals(this.callbackUrl, createCoinsTransactionRequestFromAddressRI.callbackUrl) && Objects.equals((Object)this.feePriority, (Object)createCoinsTransactionRequestFromAddressRI.feePriority) && Objects.equals(this.recipients, createCoinsTransactionRequestFromAddressRI.recipients) && Objects.equals(this.senders, createCoinsTransactionRequestFromAddressRI.senders) && Objects.equals((Object)this.transactionRequestStatus, (Object)createCoinsTransactionRequestFromAddressRI.transactionRequestStatus);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.callbackSecretKey, this.callbackUrl, this.feePriority, this.recipients, this.senders, this.transactionRequestStatus});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateCoinsTransactionRequestFromAddressRI {\n");
        sb.append("    callbackSecretKey: ").append(this.toIndentedString(this.callbackSecretKey)).append("\n");
        sb.append("    callbackUrl: ").append(this.toIndentedString(this.callbackUrl)).append("\n");
        sb.append("    feePriority: ").append(this.toIndentedString((Object)this.feePriority)).append("\n");
        sb.append("    recipients: ").append(this.toIndentedString(this.recipients)).append("\n");
        sb.append("    senders: ").append(this.toIndentedString(this.senders)).append("\n");
        sb.append("    transactionRequestStatus: ").append(this.toIndentedString((Object)this.transactionRequestStatus)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum TransactionRequestStatusEnum {
        CREATED("created"),
        AWAIT_APPROVAL("await-approval"),
        PENDING("pending"),
        PREPARED("prepared"),
        SIGNED("signed"),
        BROADCASTED("broadcasted"),
        SUCCESS("success"),
        FAILED("failed"),
        REJECTED("rejected"),
        MINED("mined");

        private String value;

        private TransactionRequestStatusEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static TransactionRequestStatusEnum fromValue(String value) {
            for (TransactionRequestStatusEnum b : TransactionRequestStatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<TransactionRequestStatusEnum> {
            public void write(JsonWriter jsonWriter, TransactionRequestStatusEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public TransactionRequestStatusEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return TransactionRequestStatusEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum FeePriorityEnum {
        SLOW("slow"),
        STANDARD("standard"),
        FAST("fast");

        private String value;

        private FeePriorityEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static FeePriorityEnum fromValue(String value) {
            for (FeePriorityEnum b : FeePriorityEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<FeePriorityEnum> {
            public void write(JsonWriter jsonWriter, FeePriorityEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public FeePriorityEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return FeePriorityEnum.fromValue(value);
            }
        }
    }
}

