/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Objects;
import javax.annotation.Nullable;

public class CreateTokensTransactionRequestFromAddressRBDataItem {
    public static final String SERIALIZED_NAME_AMOUNT = "amount";
    @SerializedName(value="amount")
    private String amount;
    public static final String SERIALIZED_NAME_CALLBACK_SECRET_KEY = "callbackSecretKey";
    @SerializedName(value="callbackSecretKey")
    private String callbackSecretKey;
    public static final String SERIALIZED_NAME_CALLBACK_URL = "callbackUrl";
    @SerializedName(value="callbackUrl")
    private String callbackUrl;
    public static final String SERIALIZED_NAME_FEE_PRIORITY = "feePriority";
    @SerializedName(value="feePriority")
    private FeePriorityEnum feePriority;
    public static final String SERIALIZED_NAME_RECIPIENT_ADDRESS = "recipientAddress";
    @SerializedName(value="recipientAddress")
    private String recipientAddress;
    public static final String SERIALIZED_NAME_TOKEN_IDENTIFIER = "tokenIdentifier";
    @SerializedName(value="tokenIdentifier")
    private String tokenIdentifier;

    public CreateTokensTransactionRequestFromAddressRBDataItem amount(String amount) {
        this.amount = amount;
        return this;
    }

    @ApiModelProperty(example="0.2", required=true, value="Represents the specific amount of the transaction.")
    public String getAmount() {
        return this.amount;
    }

    public void setAmount(String amount) {
        this.amount = amount;
    }

    public CreateTokensTransactionRequestFromAddressRBDataItem callbackSecretKey(String callbackSecretKey) {
        this.callbackSecretKey = callbackSecretKey;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="yourSecretString", value="Represents the Secret Key value provided by the customer. This field is used for security purposes during the callback notification, in order to prove the sender of the callback as Crypto APIs.")
    public String getCallbackSecretKey() {
        return this.callbackSecretKey;
    }

    public void setCallbackSecretKey(String callbackSecretKey) {
        this.callbackSecretKey = callbackSecretKey;
    }

    public CreateTokensTransactionRequestFromAddressRBDataItem callbackUrl(String callbackUrl) {
        this.callbackUrl = callbackUrl;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="https://example.com", value="Verified URL for sending callbacks")
    public String getCallbackUrl() {
        return this.callbackUrl;
    }

    public void setCallbackUrl(String callbackUrl) {
        this.callbackUrl = callbackUrl;
    }

    public CreateTokensTransactionRequestFromAddressRBDataItem feePriority(FeePriorityEnum feePriority) {
        this.feePriority = feePriority;
        return this;
    }

    @ApiModelProperty(example="standard", required=true, value="Represents the fee priority of the automation, whether it is \"slow\", \"standard\" or \"fast\".")
    public FeePriorityEnum getFeePriority() {
        return this.feePriority;
    }

    public void setFeePriority(FeePriorityEnum feePriority) {
        this.feePriority = feePriority;
    }

    public CreateTokensTransactionRequestFromAddressRBDataItem recipientAddress(String recipientAddress) {
        this.recipientAddress = recipientAddress;
        return this;
    }

    @ApiModelProperty(example="0xc065b539490f81b6c297c37b1925c3be2f190732", required=true, value="Defines the specific recipient address for the transaction.")
    public String getRecipientAddress() {
        return this.recipientAddress;
    }

    public void setRecipientAddress(String recipientAddress) {
        this.recipientAddress = recipientAddress;
    }

    public CreateTokensTransactionRequestFromAddressRBDataItem tokenIdentifier(String tokenIdentifier) {
        this.tokenIdentifier = tokenIdentifier;
        return this;
    }

    @ApiModelProperty(example="1", required=true, value="Defines the specific token identifier. For Bitcoin-based transactions it should be the `propertyId` and for Ethereum-based transactions - the `contract`.")
    public String getTokenIdentifier() {
        return this.tokenIdentifier;
    }

    public void setTokenIdentifier(String tokenIdentifier) {
        this.tokenIdentifier = tokenIdentifier;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateTokensTransactionRequestFromAddressRBDataItem createTokensTransactionRequestFromAddressRBDataItem = (CreateTokensTransactionRequestFromAddressRBDataItem)o;
        return Objects.equals(this.amount, createTokensTransactionRequestFromAddressRBDataItem.amount) && Objects.equals(this.callbackSecretKey, createTokensTransactionRequestFromAddressRBDataItem.callbackSecretKey) && Objects.equals(this.callbackUrl, createTokensTransactionRequestFromAddressRBDataItem.callbackUrl) && Objects.equals((Object)this.feePriority, (Object)createTokensTransactionRequestFromAddressRBDataItem.feePriority) && Objects.equals(this.recipientAddress, createTokensTransactionRequestFromAddressRBDataItem.recipientAddress) && Objects.equals(this.tokenIdentifier, createTokensTransactionRequestFromAddressRBDataItem.tokenIdentifier);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.amount, this.callbackSecretKey, this.callbackUrl, this.feePriority, this.recipientAddress, this.tokenIdentifier});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateTokensTransactionRequestFromAddressRBDataItem {\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    callbackSecretKey: ").append(this.toIndentedString(this.callbackSecretKey)).append("\n");
        sb.append("    callbackUrl: ").append(this.toIndentedString(this.callbackUrl)).append("\n");
        sb.append("    feePriority: ").append(this.toIndentedString((Object)this.feePriority)).append("\n");
        sb.append("    recipientAddress: ").append(this.toIndentedString(this.recipientAddress)).append("\n");
        sb.append("    tokenIdentifier: ").append(this.toIndentedString(this.tokenIdentifier)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum FeePriorityEnum {
        SLOW("slow"),
        STANDARD("standard"),
        FAST("fast");

        private String value;

        private FeePriorityEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static FeePriorityEnum fromValue(String value) {
            for (FeePriorityEnum b : FeePriorityEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<FeePriorityEnum> {
            public void write(JsonWriter jsonWriter, FeePriorityEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public FeePriorityEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return FeePriorityEnum.fromValue(value);
            }
        }
    }
}

