/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Ethereum Classic")
public class GetBlockDetailsByBlockHashRIBSEC {
    public static final String SERIALIZED_NAME_DIFFICULTY = "difficulty";
    @SerializedName(value="difficulty")
    private String difficulty;
    public static final String SERIALIZED_NAME_NONCE = "nonce";
    @SerializedName(value="nonce")
    private Integer nonce;
    public static final String SERIALIZED_NAME_SIZE = "size";
    @SerializedName(value="size")
    private Integer size;
    public static final String SERIALIZED_NAME_EXTRA_DATA = "extraData";
    @SerializedName(value="extraData")
    private String extraData;
    public static final String SERIALIZED_NAME_GAS_LIMIT = "gasLimit";
    @SerializedName(value="gasLimit")
    private String gasLimit;
    public static final String SERIALIZED_NAME_GAS_USED = "gasUsed";
    @SerializedName(value="gasUsed")
    private String gasUsed;
    public static final String SERIALIZED_NAME_MINED_IN_SECONDS = "minedInSeconds";
    @SerializedName(value="minedInSeconds")
    private Integer minedInSeconds;
    public static final String SERIALIZED_NAME_SHA3_UNCLES = "sha3Uncles";
    @SerializedName(value="sha3Uncles")
    private String sha3Uncles;
    public static final String SERIALIZED_NAME_TOTAL_DIFFICULTY = "totalDifficulty";
    @SerializedName(value="totalDifficulty")
    private String totalDifficulty;
    public static final String SERIALIZED_NAME_UNCLES = "uncles";
    @SerializedName(value="uncles")
    private List<String> uncles = new ArrayList<String>();

    public GetBlockDetailsByBlockHashRIBSEC difficulty(String difficulty) {
        this.difficulty = difficulty;
        return this;
    }

    @ApiModelProperty(example="209515044.4071968", required=true, value="Represents a mathematical value of how hard it is to find a valid hash for this block.")
    public String getDifficulty() {
        return this.difficulty;
    }

    public void setDifficulty(String difficulty) {
        this.difficulty = difficulty;
    }

    public GetBlockDetailsByBlockHashRIBSEC nonce(Integer nonce) {
        this.nonce = nonce;
        return this;
    }

    @ApiModelProperty(example="1535290446", required=true, value="Represents a random value that can be adjusted to satisfy the Proof of Work.")
    public Integer getNonce() {
        return this.nonce;
    }

    public void setNonce(Integer nonce) {
        this.nonce = nonce;
    }

    public GetBlockDetailsByBlockHashRIBSEC size(Integer size) {
        this.size = size;
        return this;
    }

    @ApiModelProperty(example="53598", required=true, value="Represents the total size of the block in Bytes.")
    public Integer getSize() {
        return this.size;
    }

    public void setSize(Integer size) {
        this.size = size;
    }

    public GetBlockDetailsByBlockHashRIBSEC extraData(String extraData) {
        this.extraData = extraData;
        return this;
    }

    @ApiModelProperty(required=true, value="Represents any data that can be included by the miner in the block.")
    public String getExtraData() {
        return this.extraData;
    }

    public void setExtraData(String extraData) {
        this.extraData = extraData;
    }

    public GetBlockDetailsByBlockHashRIBSEC gasLimit(String gasLimit) {
        this.gasLimit = gasLimit;
        return this;
    }

    @ApiModelProperty(example="7999992", required=true, value="Defines the total gas limit of all transactions in the block.")
    public String getGasLimit() {
        return this.gasLimit;
    }

    public void setGasLimit(String gasLimit) {
        this.gasLimit = gasLimit;
    }

    public GetBlockDetailsByBlockHashRIBSEC gasUsed(String gasUsed) {
        this.gasUsed = gasUsed;
        return this;
    }

    @ApiModelProperty(example="21000", required=true, value="Represents the total amount of gas used by all transactions in this block.")
    public String getGasUsed() {
        return this.gasUsed;
    }

    public void setGasUsed(String gasUsed) {
        this.gasUsed = gasUsed;
    }

    public GetBlockDetailsByBlockHashRIBSEC minedInSeconds(Integer minedInSeconds) {
        this.minedInSeconds = minedInSeconds;
        return this;
    }

    @ApiModelProperty(example="12", required=true, value="Specifies the amount of time required for the block to be mined in seconds.")
    public Integer getMinedInSeconds() {
        return this.minedInSeconds;
    }

    public void setMinedInSeconds(Integer minedInSeconds) {
        this.minedInSeconds = minedInSeconds;
    }

    public GetBlockDetailsByBlockHashRIBSEC sha3Uncles(String sha3Uncles) {
        this.sha3Uncles = sha3Uncles;
        return this;
    }

    @ApiModelProperty(example="0x1dcc4de8dec75d7aab85b567b6ccd41ad312451b948a7413f0a142fd40d49347", required=true, value="Defines the combined hash of all uncles for a given parent.")
    public String getSha3Uncles() {
        return this.sha3Uncles;
    }

    public void setSha3Uncles(String sha3Uncles) {
        this.sha3Uncles = sha3Uncles;
    }

    public GetBlockDetailsByBlockHashRIBSEC totalDifficulty(String totalDifficulty) {
        this.totalDifficulty = totalDifficulty;
        return this;
    }

    @ApiModelProperty(example="1088214928417257646845", required=true, value="Defines the total difficulty of the chain until this block, i.e. how difficult it is for a specific miner to mine a new block.")
    public String getTotalDifficulty() {
        return this.totalDifficulty;
    }

    public void setTotalDifficulty(String totalDifficulty) {
        this.totalDifficulty = totalDifficulty;
    }

    public GetBlockDetailsByBlockHashRIBSEC uncles(List<String> uncles) {
        this.uncles = uncles;
        return this;
    }

    public GetBlockDetailsByBlockHashRIBSEC addUnclesItem(String unclesItem) {
        this.uncles.add(unclesItem);
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public List<String> getUncles() {
        return this.uncles;
    }

    public void setUncles(List<String> uncles) {
        this.uncles = uncles;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetBlockDetailsByBlockHashRIBSEC getBlockDetailsByBlockHashRIBSEC = (GetBlockDetailsByBlockHashRIBSEC)o;
        return Objects.equals(this.difficulty, getBlockDetailsByBlockHashRIBSEC.difficulty) && Objects.equals(this.nonce, getBlockDetailsByBlockHashRIBSEC.nonce) && Objects.equals(this.size, getBlockDetailsByBlockHashRIBSEC.size) && Objects.equals(this.extraData, getBlockDetailsByBlockHashRIBSEC.extraData) && Objects.equals(this.gasLimit, getBlockDetailsByBlockHashRIBSEC.gasLimit) && Objects.equals(this.gasUsed, getBlockDetailsByBlockHashRIBSEC.gasUsed) && Objects.equals(this.minedInSeconds, getBlockDetailsByBlockHashRIBSEC.minedInSeconds) && Objects.equals(this.sha3Uncles, getBlockDetailsByBlockHashRIBSEC.sha3Uncles) && Objects.equals(this.totalDifficulty, getBlockDetailsByBlockHashRIBSEC.totalDifficulty) && Objects.equals(this.uncles, getBlockDetailsByBlockHashRIBSEC.uncles);
    }

    public int hashCode() {
        return Objects.hash(this.difficulty, this.nonce, this.size, this.extraData, this.gasLimit, this.gasUsed, this.minedInSeconds, this.sha3Uncles, this.totalDifficulty, this.uncles);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class GetBlockDetailsByBlockHashRIBSEC {\n");
        sb.append("    difficulty: ").append(this.toIndentedString(this.difficulty)).append("\n");
        sb.append("    nonce: ").append(this.toIndentedString(this.nonce)).append("\n");
        sb.append("    size: ").append(this.toIndentedString(this.size)).append("\n");
        sb.append("    extraData: ").append(this.toIndentedString(this.extraData)).append("\n");
        sb.append("    gasLimit: ").append(this.toIndentedString(this.gasLimit)).append("\n");
        sb.append("    gasUsed: ").append(this.toIndentedString(this.gasUsed)).append("\n");
        sb.append("    minedInSeconds: ").append(this.toIndentedString(this.minedInSeconds)).append("\n");
        sb.append("    sha3Uncles: ").append(this.toIndentedString(this.sha3Uncles)).append("\n");
        sb.append("    totalDifficulty: ").append(this.toIndentedString(this.totalDifficulty)).append("\n");
        sb.append("    uncles: ").append(this.toIndentedString(this.uncles)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

