/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import org.openapitools.client.model.GetLatestMinedBlockRIBS;

public class GetLatestMinedBlockRI {
    public static final String SERIALIZED_NAME_HASH = "hash";
    @SerializedName(value="hash")
    private String hash;
    public static final String SERIALIZED_NAME_HEIGHT = "height";
    @SerializedName(value="height")
    private Integer height;
    public static final String SERIALIZED_NAME_PREVIOUS_BLOCK_HASH = "previousBlockHash";
    @SerializedName(value="previousBlockHash")
    private String previousBlockHash;
    public static final String SERIALIZED_NAME_TIMESTAMP = "timestamp";
    @SerializedName(value="timestamp")
    private Integer timestamp;
    public static final String SERIALIZED_NAME_TRANSACTIONS_COUNT = "transactionsCount";
    @SerializedName(value="transactionsCount")
    private Integer transactionsCount;
    public static final String SERIALIZED_NAME_BLOCKCHAIN_SPECIFIC = "blockchainSpecific";
    @SerializedName(value="blockchainSpecific")
    private GetLatestMinedBlockRIBS blockchainSpecific;

    public GetLatestMinedBlockRI hash(String hash) {
        this.hash = hash;
        return this;
    }

    @ApiModelProperty(example="00000000000000000002ad6f9c74faf503bb055c54e0d0746ef34f888f95890f", required=true, value="Represents the hash of the block, which is its unique identifier. It represents a cryptographic digital fingerprint made by hashing the block header twice through the SHA256 algorithm.")
    public String getHash() {
        return this.hash;
    }

    public void setHash(String hash) {
        this.hash = hash;
    }

    public GetLatestMinedBlockRI height(Integer height) {
        this.height = height;
        return this;
    }

    @ApiModelProperty(example="673852", required=true, value="Represents the number of blocks in the blockchain preceding this specific block. Block numbers have no gaps. A blockchain usually starts with block 0 called the \"Genesis block\".")
    public Integer getHeight() {
        return this.height;
    }

    public void setHeight(Integer height) {
        this.height = height;
    }

    public GetLatestMinedBlockRI previousBlockHash(String previousBlockHash) {
        this.previousBlockHash = previousBlockHash;
        return this;
    }

    @ApiModelProperty(example="00000000000000000008953625613e60b56194ea31f07aad43c7505fbddce77f", required=true, value="Represents the hash of the previous block, also known as the parent block.")
    public String getPreviousBlockHash() {
        return this.previousBlockHash;
    }

    public void setPreviousBlockHash(String previousBlockHash) {
        this.previousBlockHash = previousBlockHash;
    }

    public GetLatestMinedBlockRI timestamp(Integer timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    @ApiModelProperty(example="1610365615", required=true, value="Defines the exact date/time when this block was mined in Unix Timestamp.")
    public Integer getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(Integer timestamp) {
        this.timestamp = timestamp;
    }

    public GetLatestMinedBlockRI transactionsCount(Integer transactionsCount) {
        this.transactionsCount = transactionsCount;
        return this;
    }

    @ApiModelProperty(example="2755", required=true, value="Represents the total number of all transactions as part of this block.")
    public Integer getTransactionsCount() {
        return this.transactionsCount;
    }

    public void setTransactionsCount(Integer transactionsCount) {
        this.transactionsCount = transactionsCount;
    }

    public GetLatestMinedBlockRI blockchainSpecific(GetLatestMinedBlockRIBS blockchainSpecific) {
        this.blockchainSpecific = blockchainSpecific;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public GetLatestMinedBlockRIBS getBlockchainSpecific() {
        return this.blockchainSpecific;
    }

    public void setBlockchainSpecific(GetLatestMinedBlockRIBS blockchainSpecific) {
        this.blockchainSpecific = blockchainSpecific;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetLatestMinedBlockRI getLatestMinedBlockRI = (GetLatestMinedBlockRI)o;
        return Objects.equals(this.hash, getLatestMinedBlockRI.hash) && Objects.equals(this.height, getLatestMinedBlockRI.height) && Objects.equals(this.previousBlockHash, getLatestMinedBlockRI.previousBlockHash) && Objects.equals(this.timestamp, getLatestMinedBlockRI.timestamp) && Objects.equals(this.transactionsCount, getLatestMinedBlockRI.transactionsCount) && Objects.equals(this.blockchainSpecific, getLatestMinedBlockRI.blockchainSpecific);
    }

    public int hashCode() {
        return Objects.hash(this.hash, this.height, this.previousBlockHash, this.timestamp, this.transactionsCount, this.blockchainSpecific);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class GetLatestMinedBlockRI {\n");
        sb.append("    hash: ").append(this.toIndentedString(this.hash)).append("\n");
        sb.append("    height: ").append(this.toIndentedString(this.height)).append("\n");
        sb.append("    previousBlockHash: ").append(this.toIndentedString(this.previousBlockHash)).append("\n");
        sb.append("    timestamp: ").append(this.toIndentedString(this.timestamp)).append("\n");
        sb.append("    transactionsCount: ").append(this.toIndentedString(this.transactionsCount)).append("\n");
        sb.append("    blockchainSpecific: ").append(this.toIndentedString(this.blockchainSpecific)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

