/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Specifies the required signatures.")
public class GetTransactionDetailsByTransactionIDRIBSD2ScriptSig {
    public static final String SERIALIZED_NAME_ASM = "asm";
    @SerializedName(value="asm")
    private String asm;
    public static final String SERIALIZED_NAME_HEX = "hex";
    @SerializedName(value="hex")
    private String hex;
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private String type;

    public GetTransactionDetailsByTransactionIDRIBSD2ScriptSig asm(String asm) {
        this.asm = asm;
        return this;
    }

    @ApiModelProperty(example="OP_DUP OP_HASH160 1fd680935cd42f95702493d44c8de964a42656b5 OP_EQUALVERIFY OP_CHECKSIG", required=true, value="The asm strands for assembly, which is the symbolic representation of the Bitcoin's Script language op-codes.")
    public String getAsm() {
        return this.asm;
    }

    public void setAsm(String asm) {
        this.asm = asm;
    }

    public GetTransactionDetailsByTransactionIDRIBSD2ScriptSig hex(String hex) {
        this.hex = hex;
        return this;
    }

    @ApiModelProperty(example="4197968cb34bfba488b4a2399f7959b823fefad79ca0b5ed3f3a4bec4c0286cab55b896b28bbbcd4e61cf584cecfd47063b18b481d8d680eafbf869ada1a02c52441210237a84e6d70e775f274e4cbd9f30f9f8b1a426e8b08a9f802a851ce501c930011", required=true, value="Represents the hex of the public key of the address.")
    public String getHex() {
        return this.hex;
    }

    public void setHex(String hex) {
        this.hex = hex;
    }

    public GetTransactionDetailsByTransactionIDRIBSD2ScriptSig type(String type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(example="scripthash", required=true, value="Represents the script type of the reference transaction identifier.")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetTransactionDetailsByTransactionIDRIBSD2ScriptSig getTransactionDetailsByTransactionIDRIBSD2ScriptSig = (GetTransactionDetailsByTransactionIDRIBSD2ScriptSig)o;
        return Objects.equals(this.asm, getTransactionDetailsByTransactionIDRIBSD2ScriptSig.asm) && Objects.equals(this.hex, getTransactionDetailsByTransactionIDRIBSD2ScriptSig.hex) && Objects.equals(this.type, getTransactionDetailsByTransactionIDRIBSD2ScriptSig.type);
    }

    public int hashCode() {
        return Objects.hash(this.asm, this.hex, this.type);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class GetTransactionDetailsByTransactionIDRIBSD2ScriptSig {\n");
        sb.append("    asm: ").append(this.toIndentedString(this.asm)).append("\n");
        sb.append("    hex: ").append(this.toIndentedString(this.hex)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

