/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Objects;

@ApiModel(description="Crypto Type Data")
public class ListAssetsDetailsRISC {
    public static final String SERIALIZED_NAME_1HOUR_PRICE_CHANGE_IN_PERCENTAGE = "1HourPriceChangeInPercentage";
    @SerializedName(value="1HourPriceChangeInPercentage")
    private String _1hourPriceChangeInPercentage;
    public static final String SERIALIZED_NAME_1WEEK_PRICE_CHANGE_IN_PERCENTAGE = "1WeekPriceChangeInPercentage";
    @SerializedName(value="1WeekPriceChangeInPercentage")
    private String _1weekPriceChangeInPercentage;
    public static final String SERIALIZED_NAME_24HOURS_PRICE_CHANGE_IN_PERCENTAGE = "24HoursPriceChangeInPercentage";
    @SerializedName(value="24HoursPriceChangeInPercentage")
    private String _24hoursPriceChangeInPercentage;
    public static final String SERIALIZED_NAME_24HOURS_TRADING_VOLUME = "24HoursTradingVolume";
    @SerializedName(value="24HoursTradingVolume")
    private String _24hoursTradingVolume;
    public static final String SERIALIZED_NAME_ASSET_TYPE = "assetType";
    @SerializedName(value="assetType")
    private AssetTypeEnum assetType;
    public static final String SERIALIZED_NAME_CIRCULATING_SUPPLY = "circulatingSupply";
    @SerializedName(value="circulatingSupply")
    private String circulatingSupply;
    public static final String SERIALIZED_NAME_MARKET_CAP_IN_U_S_D = "marketCapInUSD";
    @SerializedName(value="marketCapInUSD")
    private String marketCapInUSD;
    public static final String SERIALIZED_NAME_MAX_SUPPLY = "maxSupply";
    @SerializedName(value="maxSupply")
    private String maxSupply;

    public ListAssetsDetailsRISC _1hourPriceChangeInPercentage(String _1hourPriceChangeInPercentage) {
        this._1hourPriceChangeInPercentage = _1hourPriceChangeInPercentage;
        return this;
    }

    @ApiModelProperty(example="-2.52", required=true, value="Represents the percentage of the asset's current price against the its price from 1 hour ago.")
    public String get1hourPriceChangeInPercentage() {
        return this._1hourPriceChangeInPercentage;
    }

    public void set1hourPriceChangeInPercentage(String _1hourPriceChangeInPercentage) {
        this._1hourPriceChangeInPercentage = _1hourPriceChangeInPercentage;
    }

    public ListAssetsDetailsRISC _1weekPriceChangeInPercentage(String _1weekPriceChangeInPercentage) {
        this._1weekPriceChangeInPercentage = _1weekPriceChangeInPercentage;
        return this;
    }

    @ApiModelProperty(example="-10.18", required=true, value="Represents the percentage of the asset's current price against the its price from 1 week ago.")
    public String get1weekPriceChangeInPercentage() {
        return this._1weekPriceChangeInPercentage;
    }

    public void set1weekPriceChangeInPercentage(String _1weekPriceChangeInPercentage) {
        this._1weekPriceChangeInPercentage = _1weekPriceChangeInPercentage;
    }

    public ListAssetsDetailsRISC _24hoursPriceChangeInPercentage(String _24hoursPriceChangeInPercentage) {
        this._24hoursPriceChangeInPercentage = _24hoursPriceChangeInPercentage;
        return this;
    }

    @ApiModelProperty(example="-3.37", required=true, value="Represents the percentage of the asset's current price against the its price from 24 hours ago.")
    public String get24hoursPriceChangeInPercentage() {
        return this._24hoursPriceChangeInPercentage;
    }

    public void set24hoursPriceChangeInPercentage(String _24hoursPriceChangeInPercentage) {
        this._24hoursPriceChangeInPercentage = _24hoursPriceChangeInPercentage;
    }

    public ListAssetsDetailsRISC _24hoursTradingVolume(String _24hoursTradingVolume) {
        this._24hoursTradingVolume = _24hoursTradingVolume;
        return this;
    }

    @ApiModelProperty(example="2871630447", required=true, value="Represents the trading volume of the asset for the time frame of 24 hours.")
    public String get24hoursTradingVolume() {
        return this._24hoursTradingVolume;
    }

    public void set24hoursTradingVolume(String _24hoursTradingVolume) {
        this._24hoursTradingVolume = _24hoursTradingVolume;
    }

    public ListAssetsDetailsRISC assetType(AssetTypeEnum assetType) {
        this.assetType = assetType;
        return this;
    }

    @ApiModelProperty(example="coin", required=true, value="Subtype of the crypto assets. Could be COIN or TOKEN")
    public AssetTypeEnum getAssetType() {
        return this.assetType;
    }

    public void setAssetType(AssetTypeEnum assetType) {
        this.assetType = assetType;
    }

    public ListAssetsDetailsRISC circulatingSupply(String circulatingSupply) {
        this.circulatingSupply = circulatingSupply;
        return this;
    }

    @ApiModelProperty(example="123564.25", required=true, value="Represents the amount of the asset that is circulating on the market and in public hands.")
    public String getCirculatingSupply() {
        return this.circulatingSupply;
    }

    public void setCirculatingSupply(String circulatingSupply) {
        this.circulatingSupply = circulatingSupply;
    }

    public ListAssetsDetailsRISC marketCapInUSD(String marketCapInUSD) {
        this.marketCapInUSD = marketCapInUSD;
        return this;
    }

    @ApiModelProperty(example="1,056,050,713,184", required=true, value="Defines the total market value of the asset's circulating supply in USD.")
    public String getMarketCapInUSD() {
        return this.marketCapInUSD;
    }

    public void setMarketCapInUSD(String marketCapInUSD) {
        this.marketCapInUSD = marketCapInUSD;
    }

    public ListAssetsDetailsRISC maxSupply(String maxSupply) {
        this.maxSupply = maxSupply;
        return this;
    }

    @ApiModelProperty(example="18,562,881", required=true, value="Represents the maximum amount of all coins of a specific asset that will ever exist in its lifetime.")
    public String getMaxSupply() {
        return this.maxSupply;
    }

    public void setMaxSupply(String maxSupply) {
        this.maxSupply = maxSupply;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ListAssetsDetailsRISC listAssetsDetailsRISC = (ListAssetsDetailsRISC)o;
        return Objects.equals(this._1hourPriceChangeInPercentage, listAssetsDetailsRISC._1hourPriceChangeInPercentage) && Objects.equals(this._1weekPriceChangeInPercentage, listAssetsDetailsRISC._1weekPriceChangeInPercentage) && Objects.equals(this._24hoursPriceChangeInPercentage, listAssetsDetailsRISC._24hoursPriceChangeInPercentage) && Objects.equals(this._24hoursTradingVolume, listAssetsDetailsRISC._24hoursTradingVolume) && Objects.equals((Object)this.assetType, (Object)listAssetsDetailsRISC.assetType) && Objects.equals(this.circulatingSupply, listAssetsDetailsRISC.circulatingSupply) && Objects.equals(this.marketCapInUSD, listAssetsDetailsRISC.marketCapInUSD) && Objects.equals(this.maxSupply, listAssetsDetailsRISC.maxSupply);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this._1hourPriceChangeInPercentage, this._1weekPriceChangeInPercentage, this._24hoursPriceChangeInPercentage, this._24hoursTradingVolume, this.assetType, this.circulatingSupply, this.marketCapInUSD, this.maxSupply});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ListAssetsDetailsRISC {\n");
        sb.append("    _1hourPriceChangeInPercentage: ").append(this.toIndentedString(this._1hourPriceChangeInPercentage)).append("\n");
        sb.append("    _1weekPriceChangeInPercentage: ").append(this.toIndentedString(this._1weekPriceChangeInPercentage)).append("\n");
        sb.append("    _24hoursPriceChangeInPercentage: ").append(this.toIndentedString(this._24hoursPriceChangeInPercentage)).append("\n");
        sb.append("    _24hoursTradingVolume: ").append(this.toIndentedString(this._24hoursTradingVolume)).append("\n");
        sb.append("    assetType: ").append(this.toIndentedString((Object)this.assetType)).append("\n");
        sb.append("    circulatingSupply: ").append(this.toIndentedString(this.circulatingSupply)).append("\n");
        sb.append("    marketCapInUSD: ").append(this.toIndentedString(this.marketCapInUSD)).append("\n");
        sb.append("    maxSupply: ").append(this.toIndentedString(this.maxSupply)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum AssetTypeEnum {
        COIN("coin"),
        TOKEN("token");

        private String value;

        private AssetTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static AssetTypeEnum fromValue(String value) {
            for (AssetTypeEnum b : AssetTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<AssetTypeEnum> {
            public void write(JsonWriter jsonWriter, AssetTypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public AssetTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return AssetTypeEnum.fromValue(value);
            }
        }
    }
}

