/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

public class ListTokensTransfersByTransactionHashRI {
    public static final String SERIALIZED_NAME_CONTRACT_ADDRESS = "contractAddress";
    @SerializedName(value="contractAddress")
    private String contractAddress;
    public static final String SERIALIZED_NAME_MINED_IN_BLOCK_HEIGHT = "minedInBlockHeight";
    @SerializedName(value="minedInBlockHeight")
    private Integer minedInBlockHeight;
    public static final String SERIALIZED_NAME_RECIPIENT_ADDRESS = "recipientAddress";
    @SerializedName(value="recipientAddress")
    private String recipientAddress;
    public static final String SERIALIZED_NAME_SENDER_ADDRESS = "senderAddress";
    @SerializedName(value="senderAddress")
    private String senderAddress;
    public static final String SERIALIZED_NAME_TOKEN_DECIMALS = "tokenDecimals";
    @SerializedName(value="tokenDecimals")
    private Integer tokenDecimals;
    public static final String SERIALIZED_NAME_TOKEN_NAME = "tokenName";
    @SerializedName(value="tokenName")
    private String tokenName;
    public static final String SERIALIZED_NAME_TOKEN_SYMBOL = "tokenSymbol";
    @SerializedName(value="tokenSymbol")
    private String tokenSymbol;
    public static final String SERIALIZED_NAME_TOKEN_TYPE = "tokenType";
    @SerializedName(value="tokenType")
    private String tokenType;
    public static final String SERIALIZED_NAME_TOKENS_AMOUNT = "tokensAmount";
    @SerializedName(value="tokensAmount")
    private String tokensAmount;
    public static final String SERIALIZED_NAME_TRANSACTION_HASH = "transactionHash";
    @SerializedName(value="transactionHash")
    private String transactionHash;
    public static final String SERIALIZED_NAME_TRANSACTION_TIMESTAMP = "transactionTimestamp";
    @SerializedName(value="transactionTimestamp")
    private Integer transactionTimestamp;

    public ListTokensTransfersByTransactionHashRI contractAddress(String contractAddress) {
        this.contractAddress = contractAddress;
        return this;
    }

    @ApiModelProperty(example="0x7495fede000c8a3b77eeae09cf70fa94cd2d53f5", required=true, value="Represents the contract address of the token, which controls its logic. It is not the address that holds the tokens.")
    public String getContractAddress() {
        return this.contractAddress;
    }

    public void setContractAddress(String contractAddress) {
        this.contractAddress = contractAddress;
    }

    public ListTokensTransfersByTransactionHashRI minedInBlockHeight(Integer minedInBlockHeight) {
        this.minedInBlockHeight = minedInBlockHeight;
        return this;
    }

    @ApiModelProperty(example="9841271", required=true, value="Defines the block height in which this transaction was confirmed/mined.")
    public Integer getMinedInBlockHeight() {
        return this.minedInBlockHeight;
    }

    public void setMinedInBlockHeight(Integer minedInBlockHeight) {
        this.minedInBlockHeight = minedInBlockHeight;
    }

    public ListTokensTransfersByTransactionHashRI recipientAddress(String recipientAddress) {
        this.recipientAddress = recipientAddress;
        return this;
    }

    @ApiModelProperty(example="0x9e91eb3a35b96f0f0fe71f3c17fe8d29eb406b16", required=true, value="Defines the address to which the recipient receives the transferred tokens.")
    public String getRecipientAddress() {
        return this.recipientAddress;
    }

    public void setRecipientAddress(String recipientAddress) {
        this.recipientAddress = recipientAddress;
    }

    public ListTokensTransfersByTransactionHashRI senderAddress(String senderAddress) {
        this.senderAddress = senderAddress;
        return this;
    }

    @ApiModelProperty(example="0x9df8a6441e8a3dda75019595d431f9aa0dec475c", required=true, value="Defines the address from which the sender transfers tokens.")
    public String getSenderAddress() {
        return this.senderAddress;
    }

    public void setSenderAddress(String senderAddress) {
        this.senderAddress = senderAddress;
    }

    public ListTokensTransfersByTransactionHashRI tokenDecimals(Integer tokenDecimals) {
        this.tokenDecimals = tokenDecimals;
        return this;
    }

    @ApiModelProperty(example="18", required=true, value="Defines the decimals of the token, i.e. the number of digits that come after the decimal coma of the token.")
    public Integer getTokenDecimals() {
        return this.tokenDecimals;
    }

    public void setTokenDecimals(Integer tokenDecimals) {
        this.tokenDecimals = tokenDecimals;
    }

    public ListTokensTransfersByTransactionHashRI tokenName(String tokenName) {
        this.tokenName = tokenName;
        return this;
    }

    @ApiModelProperty(example="Band Protocol", required=true, value="Defines the token's name as a string.")
    public String getTokenName() {
        return this.tokenName;
    }

    public void setTokenName(String tokenName) {
        this.tokenName = tokenName;
    }

    public ListTokensTransfersByTransactionHashRI tokenSymbol(String tokenSymbol) {
        this.tokenSymbol = tokenSymbol;
        return this;
    }

    @ApiModelProperty(example="BAND", required=true, value="Defines the token symbol by which the token contract is known. It is usually 3-4 characters in length.")
    public String getTokenSymbol() {
        return this.tokenSymbol;
    }

    public void setTokenSymbol(String tokenSymbol) {
        this.tokenSymbol = tokenSymbol;
    }

    public ListTokensTransfersByTransactionHashRI tokenType(String tokenType) {
        this.tokenType = tokenType;
        return this;
    }

    @ApiModelProperty(example="ERC-20", required=true, value="Defines the specific token type.")
    public String getTokenType() {
        return this.tokenType;
    }

    public void setTokenType(String tokenType) {
        this.tokenType = tokenType;
    }

    public ListTokensTransfersByTransactionHashRI tokensAmount(String tokensAmount) {
        this.tokensAmount = tokensAmount;
        return this;
    }

    @ApiModelProperty(example="0.001", required=true, value="Defines the token amount of the transfer.")
    public String getTokensAmount() {
        return this.tokensAmount;
    }

    public void setTokensAmount(String tokensAmount) {
        this.tokensAmount = tokensAmount;
    }

    public ListTokensTransfersByTransactionHashRI transactionHash(String transactionHash) {
        this.transactionHash = transactionHash;
        return this;
    }

    @ApiModelProperty(example="0x60ba3dded833e61f63b6b6d62afe5c7526c5ca09c6744749f13eef11afde2cb4", required=true, value="Represents the hash of the transaction, which is its unique identifier. It represents a cryptographic digital fingerprint made by hashing the block header twice through the SHA256 algorithm.")
    public String getTransactionHash() {
        return this.transactionHash;
    }

    public void setTransactionHash(String transactionHash) {
        this.transactionHash = transactionHash;
    }

    public ListTokensTransfersByTransactionHashRI transactionTimestamp(Integer transactionTimestamp) {
        this.transactionTimestamp = transactionTimestamp;
        return this;
    }

    @ApiModelProperty(example="1615818368", required=true, value="Defines the specific time/date when the transaction was created in Unix Timestamp.")
    public Integer getTransactionTimestamp() {
        return this.transactionTimestamp;
    }

    public void setTransactionTimestamp(Integer transactionTimestamp) {
        this.transactionTimestamp = transactionTimestamp;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ListTokensTransfersByTransactionHashRI listTokensTransfersByTransactionHashRI = (ListTokensTransfersByTransactionHashRI)o;
        return Objects.equals(this.contractAddress, listTokensTransfersByTransactionHashRI.contractAddress) && Objects.equals(this.minedInBlockHeight, listTokensTransfersByTransactionHashRI.minedInBlockHeight) && Objects.equals(this.recipientAddress, listTokensTransfersByTransactionHashRI.recipientAddress) && Objects.equals(this.senderAddress, listTokensTransfersByTransactionHashRI.senderAddress) && Objects.equals(this.tokenDecimals, listTokensTransfersByTransactionHashRI.tokenDecimals) && Objects.equals(this.tokenName, listTokensTransfersByTransactionHashRI.tokenName) && Objects.equals(this.tokenSymbol, listTokensTransfersByTransactionHashRI.tokenSymbol) && Objects.equals(this.tokenType, listTokensTransfersByTransactionHashRI.tokenType) && Objects.equals(this.tokensAmount, listTokensTransfersByTransactionHashRI.tokensAmount) && Objects.equals(this.transactionHash, listTokensTransfersByTransactionHashRI.transactionHash) && Objects.equals(this.transactionTimestamp, listTokensTransfersByTransactionHashRI.transactionTimestamp);
    }

    public int hashCode() {
        return Objects.hash(this.contractAddress, this.minedInBlockHeight, this.recipientAddress, this.senderAddress, this.tokenDecimals, this.tokenName, this.tokenSymbol, this.tokenType, this.tokensAmount, this.transactionHash, this.transactionTimestamp);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ListTokensTransfersByTransactionHashRI {\n");
        sb.append("    contractAddress: ").append(this.toIndentedString(this.contractAddress)).append("\n");
        sb.append("    minedInBlockHeight: ").append(this.toIndentedString(this.minedInBlockHeight)).append("\n");
        sb.append("    recipientAddress: ").append(this.toIndentedString(this.recipientAddress)).append("\n");
        sb.append("    senderAddress: ").append(this.toIndentedString(this.senderAddress)).append("\n");
        sb.append("    tokenDecimals: ").append(this.toIndentedString(this.tokenDecimals)).append("\n");
        sb.append("    tokenName: ").append(this.toIndentedString(this.tokenName)).append("\n");
        sb.append("    tokenSymbol: ").append(this.toIndentedString(this.tokenSymbol)).append("\n");
        sb.append("    tokenType: ").append(this.toIndentedString(this.tokenType)).append("\n");
        sb.append("    tokensAmount: ").append(this.toIndentedString(this.tokensAmount)).append("\n");
        sb.append("    transactionHash: ").append(this.toIndentedString(this.transactionHash)).append("\n");
        sb.append("    transactionTimestamp: ").append(this.toIndentedString(this.transactionTimestamp)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

