/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Specifies the required signatures.")
public class ListTransactionsByAddressRIBSDScriptSig {
    public static final String SERIALIZED_NAME_ASM = "asm";
    @SerializedName(value="asm")
    private String asm;
    public static final String SERIALIZED_NAME_HEX = "hex";
    @SerializedName(value="hex")
    private String hex;
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private String type;

    public ListTransactionsByAddressRIBSDScriptSig asm(String asm) {
        this.asm = asm;
        return this;
    }

    @ApiModelProperty(example="030483ff6271580681f4f7828c01df56d5aebfe982cbaa2922594be9eb6cf40206 OP_CHECKSIG", required=true, value="The asm strands for assembly, which is the symbolic representation of the Bitcoin's Script language op-codes.")
    public String getAsm() {
        return this.asm;
    }

    public void setAsm(String asm) {
        this.asm = asm;
    }

    public ListTransactionsByAddressRIBSDScriptSig hex(String hex) {
        this.hex = hex;
        return this;
    }

    @ApiModelProperty(example="21030483ff6271580681f4f7828c01df56d5aebfe982cbaa2922594be9eb6cf40206ac", required=true, value="Represents the hex of the public key of the address.")
    public String getHex() {
        return this.hex;
    }

    public void setHex(String hex) {
        this.hex = hex;
    }

    public ListTransactionsByAddressRIBSDScriptSig type(String type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(example="pubkey", required=true, value="Represents the script type of the reference transaction identifier.")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ListTransactionsByAddressRIBSDScriptSig listTransactionsByAddressRIBSDScriptSig = (ListTransactionsByAddressRIBSDScriptSig)o;
        return Objects.equals(this.asm, listTransactionsByAddressRIBSDScriptSig.asm) && Objects.equals(this.hex, listTransactionsByAddressRIBSDScriptSig.hex) && Objects.equals(this.type, listTransactionsByAddressRIBSDScriptSig.type);
    }

    public int hashCode() {
        return Objects.hash(this.asm, this.hex, this.type);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ListTransactionsByAddressRIBSDScriptSig {\n");
        sb.append("    asm: ").append(this.toIndentedString(this.asm)).append("\n");
        sb.append("    hex: ").append(this.toIndentedString(this.hex)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

