/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.openapitools.client.model.ListTransactionsByBlockHashRIBS;
import org.openapitools.client.model.ListTransactionsByBlockHashRIFee;
import org.openapitools.client.model.ListTransactionsByBlockHashRIRecipients;
import org.openapitools.client.model.ListTransactionsByBlockHashRISenders;

public class ListTransactionsByBlockHashRI {
    public static final String SERIALIZED_NAME_INDEX = "index";
    @SerializedName(value="index")
    private Integer index;
    public static final String SERIALIZED_NAME_MINED_IN_BLOCK_HASH = "minedInBlockHash";
    @SerializedName(value="minedInBlockHash")
    private String minedInBlockHash;
    public static final String SERIALIZED_NAME_MINED_IN_BLOCK_HEIGHT = "minedInBlockHeight";
    @SerializedName(value="minedInBlockHeight")
    private Integer minedInBlockHeight;
    public static final String SERIALIZED_NAME_RECIPIENTS = "recipients";
    @SerializedName(value="recipients")
    private List<ListTransactionsByBlockHashRIRecipients> recipients = new ArrayList<ListTransactionsByBlockHashRIRecipients>();
    public static final String SERIALIZED_NAME_SENDERS = "senders";
    @SerializedName(value="senders")
    private List<ListTransactionsByBlockHashRISenders> senders = new ArrayList<ListTransactionsByBlockHashRISenders>();
    public static final String SERIALIZED_NAME_TIMESTAMP = "timestamp";
    @SerializedName(value="timestamp")
    private Integer timestamp;
    public static final String SERIALIZED_NAME_TRANSACTION_HASH = "transactionHash";
    @SerializedName(value="transactionHash")
    private String transactionHash;
    public static final String SERIALIZED_NAME_TRANSACTION_ID = "transactionId";
    @SerializedName(value="transactionId")
    private String transactionId;
    public static final String SERIALIZED_NAME_FEE = "fee";
    @SerializedName(value="fee")
    private ListTransactionsByBlockHashRIFee fee;
    public static final String SERIALIZED_NAME_BLOCKCHAIN_SPECIFIC = "blockchainSpecific";
    @SerializedName(value="blockchainSpecific")
    private ListTransactionsByBlockHashRIBS blockchainSpecific;

    public ListTransactionsByBlockHashRI index(Integer index) {
        this.index = index;
        return this;
    }

    @ApiModelProperty(example="1", required=true, value="Represents the index position of the transaction in the specific block.")
    public Integer getIndex() {
        return this.index;
    }

    public void setIndex(Integer index) {
        this.index = index;
    }

    public ListTransactionsByBlockHashRI minedInBlockHash(String minedInBlockHash) {
        this.minedInBlockHash = minedInBlockHash;
        return this;
    }

    @ApiModelProperty(example="00000000000000127080d8bcf84f4ad830a71ea0aadce3632579b6b2f26cd94b", required=true, value="Represents the hash of the block where this transaction was mined/confirmed for first time. The hash is defined as a cryptographic digital fingerprint made by hashing the block header twice through the SHA256 algorithm.")
    public String getMinedInBlockHash() {
        return this.minedInBlockHash;
    }

    public void setMinedInBlockHash(String minedInBlockHash) {
        this.minedInBlockHash = minedInBlockHash;
    }

    public ListTransactionsByBlockHashRI minedInBlockHeight(Integer minedInBlockHeight) {
        this.minedInBlockHeight = minedInBlockHeight;
        return this;
    }

    @ApiModelProperty(example="1971147", required=true, value="Represents the hight of the block where this transaction was mined/confirmed for first time. The height is defined as the number of blocks in the blockchain preceding this specific block.")
    public Integer getMinedInBlockHeight() {
        return this.minedInBlockHeight;
    }

    public void setMinedInBlockHeight(Integer minedInBlockHeight) {
        this.minedInBlockHeight = minedInBlockHeight;
    }

    public ListTransactionsByBlockHashRI recipients(List<ListTransactionsByBlockHashRIRecipients> recipients) {
        this.recipients = recipients;
        return this;
    }

    public ListTransactionsByBlockHashRI addRecipientsItem(ListTransactionsByBlockHashRIRecipients recipientsItem) {
        this.recipients.add(recipientsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="Represents a list of recipient addresses with the respective amounts. In account-based protocols like Ethereum there is only one address in this list.")
    public List<ListTransactionsByBlockHashRIRecipients> getRecipients() {
        return this.recipients;
    }

    public void setRecipients(List<ListTransactionsByBlockHashRIRecipients> recipients) {
        this.recipients = recipients;
    }

    public ListTransactionsByBlockHashRI senders(List<ListTransactionsByBlockHashRISenders> senders) {
        this.senders = senders;
        return this;
    }

    public ListTransactionsByBlockHashRI addSendersItem(ListTransactionsByBlockHashRISenders sendersItem) {
        this.senders.add(sendersItem);
        return this;
    }

    @ApiModelProperty(required=true, value="Represents a list of sender addresses with the respective amounts. In account-based protocols like Ethereum there is only one address in this list.")
    public List<ListTransactionsByBlockHashRISenders> getSenders() {
        return this.senders;
    }

    public void setSenders(List<ListTransactionsByBlockHashRISenders> senders) {
        this.senders = senders;
    }

    public ListTransactionsByBlockHashRI timestamp(Integer timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    @ApiModelProperty(example="1618208236", required=true, value="Defines the exact date/time in Unix Timestamp when this transaction was mined, confirmed or first seen in Mempool, if it is unconfirmed.")
    public Integer getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(Integer timestamp) {
        this.timestamp = timestamp;
    }

    public ListTransactionsByBlockHashRI transactionHash(String transactionHash) {
        this.transactionHash = transactionHash;
        return this;
    }

    @ApiModelProperty(example="273eac351a2b76bb98196f3b310eabc787758cf157e8abe726250447185956ed", required=true, value="Represents the same as `transactionId` for account-based protocols like Ethereum, while it could be different in UTXO-based protocols like Bitcoin. E.g., in UTXO-based protocols `hash` is different from `transactionId` for SegWit transactions.")
    public String getTransactionHash() {
        return this.transactionHash;
    }

    public void setTransactionHash(String transactionHash) {
        this.transactionHash = transactionHash;
    }

    public ListTransactionsByBlockHashRI transactionId(String transactionId) {
        this.transactionId = transactionId;
        return this;
    }

    @ApiModelProperty(example="4340d9463f0a5e3b3bc5844c17af78e20fa141f976f20732de630b0e6e4cd571", required=true, value="Represents the unique identifier of a transaction, i.e. it could be `transactionId` in UTXO-based protocols like Bitcoin, and transaction `hash` in Ethereum blockchain.")
    public String getTransactionId() {
        return this.transactionId;
    }

    public void setTransactionId(String transactionId) {
        this.transactionId = transactionId;
    }

    public ListTransactionsByBlockHashRI fee(ListTransactionsByBlockHashRIFee fee) {
        this.fee = fee;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public ListTransactionsByBlockHashRIFee getFee() {
        return this.fee;
    }

    public void setFee(ListTransactionsByBlockHashRIFee fee) {
        this.fee = fee;
    }

    public ListTransactionsByBlockHashRI blockchainSpecific(ListTransactionsByBlockHashRIBS blockchainSpecific) {
        this.blockchainSpecific = blockchainSpecific;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public ListTransactionsByBlockHashRIBS getBlockchainSpecific() {
        return this.blockchainSpecific;
    }

    public void setBlockchainSpecific(ListTransactionsByBlockHashRIBS blockchainSpecific) {
        this.blockchainSpecific = blockchainSpecific;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ListTransactionsByBlockHashRI listTransactionsByBlockHashRI = (ListTransactionsByBlockHashRI)o;
        return Objects.equals(this.index, listTransactionsByBlockHashRI.index) && Objects.equals(this.minedInBlockHash, listTransactionsByBlockHashRI.minedInBlockHash) && Objects.equals(this.minedInBlockHeight, listTransactionsByBlockHashRI.minedInBlockHeight) && Objects.equals(this.recipients, listTransactionsByBlockHashRI.recipients) && Objects.equals(this.senders, listTransactionsByBlockHashRI.senders) && Objects.equals(this.timestamp, listTransactionsByBlockHashRI.timestamp) && Objects.equals(this.transactionHash, listTransactionsByBlockHashRI.transactionHash) && Objects.equals(this.transactionId, listTransactionsByBlockHashRI.transactionId) && Objects.equals(this.fee, listTransactionsByBlockHashRI.fee) && Objects.equals(this.blockchainSpecific, listTransactionsByBlockHashRI.blockchainSpecific);
    }

    public int hashCode() {
        return Objects.hash(this.index, this.minedInBlockHash, this.minedInBlockHeight, this.recipients, this.senders, this.timestamp, this.transactionHash, this.transactionId, this.fee, this.blockchainSpecific);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ListTransactionsByBlockHashRI {\n");
        sb.append("    index: ").append(this.toIndentedString(this.index)).append("\n");
        sb.append("    minedInBlockHash: ").append(this.toIndentedString(this.minedInBlockHash)).append("\n");
        sb.append("    minedInBlockHeight: ").append(this.toIndentedString(this.minedInBlockHeight)).append("\n");
        sb.append("    recipients: ").append(this.toIndentedString(this.recipients)).append("\n");
        sb.append("    senders: ").append(this.toIndentedString(this.senders)).append("\n");
        sb.append("    timestamp: ").append(this.toIndentedString(this.timestamp)).append("\n");
        sb.append("    transactionHash: ").append(this.toIndentedString(this.transactionHash)).append("\n");
        sb.append("    transactionId: ").append(this.toIndentedString(this.transactionId)).append("\n");
        sb.append("    fee: ").append(this.toIndentedString(this.fee)).append("\n");
        sb.append("    blockchainSpecific: ").append(this.toIndentedString(this.blockchainSpecific)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

