/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Objects;

@ApiModel(description="Defines an `item` as one result.")
public class TokensForwardingFailDataItem {
    public static final String SERIALIZED_NAME_BLOCKCHAIN = "blockchain";
    @SerializedName(value="blockchain")
    private String blockchain;
    public static final String SERIALIZED_NAME_NETWORK = "network";
    @SerializedName(value="network")
    private String network;
    public static final String SERIALIZED_NAME_FROM_ADDRESS = "fromAddress";
    @SerializedName(value="fromAddress")
    private String fromAddress;
    public static final String SERIALIZED_NAME_TO_ADDRESS = "toAddress";
    @SerializedName(value="toAddress")
    private String toAddress;
    public static final String SERIALIZED_NAME_TRIGGER_TRANSACTION_ID = "triggerTransactionId";
    @SerializedName(value="triggerTransactionId")
    private String triggerTransactionId;
    public static final String SERIALIZED_NAME_ERROR_CODE = "errorCode";
    @SerializedName(value="errorCode")
    private ErrorCodeEnum errorCode;
    public static final String SERIALIZED_NAME_ERROR_MESSAGE = "errorMessage";
    @SerializedName(value="errorMessage")
    private String errorMessage;

    public TokensForwardingFailDataItem blockchain(String blockchain) {
        this.blockchain = blockchain;
        return this;
    }

    @ApiModelProperty(example="bitcoin", required=true, value="Represents the specific blockchain protocol name, e.g. Ethereum, Bitcoin, etc.")
    public String getBlockchain() {
        return this.blockchain;
    }

    public void setBlockchain(String blockchain) {
        this.blockchain = blockchain;
    }

    public TokensForwardingFailDataItem network(String network) {
        this.network = network;
        return this;
    }

    @ApiModelProperty(example="testnet", required=true, value="Represents the name of the blockchain network used; blockchain networks are usually identical as technology and software, but they differ in data, e.g. - \"mainnet\" is the live network with actual data while networks like \"testnet\", \"ropsten\", \"rinkeby\" are test networks.")
    public String getNetwork() {
        return this.network;
    }

    public void setNetwork(String network) {
        this.network = network;
    }

    public TokensForwardingFailDataItem fromAddress(String fromAddress) {
        this.fromAddress = fromAddress;
        return this;
    }

    @ApiModelProperty(example="bc1qy4tncwfr6nw3rd8hcr6psxlrkufe6cq44tlfvv", required=true, value="Represents the hash of the address that provides the tokens.")
    public String getFromAddress() {
        return this.fromAddress;
    }

    public void setFromAddress(String fromAddress) {
        this.fromAddress = fromAddress;
    }

    public TokensForwardingFailDataItem toAddress(String toAddress) {
        this.toAddress = toAddress;
        return this;
    }

    @ApiModelProperty(example="32Dv1CCNFagLcEdmC1uamj2k2jVDdokVQL", required=true, value="Represents the hash of the address to forward the tokens to.")
    public String getToAddress() {
        return this.toAddress;
    }

    public void setToAddress(String toAddress) {
        this.toAddress = toAddress;
    }

    public TokensForwardingFailDataItem triggerTransactionId(String triggerTransactionId) {
        this.triggerTransactionId = triggerTransactionId;
        return this;
    }

    @ApiModelProperty(example="044681d8571cb55047d9425b7095272fbb8fe4f325b0cd822d374b6153af12a1", required=true, value="Defines the unique Transaction ID that triggered the token forwarding.")
    public String getTriggerTransactionId() {
        return this.triggerTransactionId;
    }

    public void setTriggerTransactionId(String triggerTransactionId) {
        this.triggerTransactionId = triggerTransactionId;
    }

    public TokensForwardingFailDataItem errorCode(ErrorCodeEnum errorCode) {
        this.errorCode = errorCode;
        return this;
    }

    @ApiModelProperty(example="FEE_ADDRESS_OUT_OF_FUNDS", required=true, value="Represents the error code received for the failed token forwarding.")
    public ErrorCodeEnum getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(ErrorCodeEnum errorCode) {
        this.errorCode = errorCode;
    }

    public TokensForwardingFailDataItem errorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
        return this;
    }

    @ApiModelProperty(example="The specified URI has not been found. Check the URI and try again.", required=true, value="Represents the error message received for the failed token forwarding.")
    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TokensForwardingFailDataItem tokensForwardingFailDataItem = (TokensForwardingFailDataItem)o;
        return Objects.equals(this.blockchain, tokensForwardingFailDataItem.blockchain) && Objects.equals(this.network, tokensForwardingFailDataItem.network) && Objects.equals(this.fromAddress, tokensForwardingFailDataItem.fromAddress) && Objects.equals(this.toAddress, tokensForwardingFailDataItem.toAddress) && Objects.equals(this.triggerTransactionId, tokensForwardingFailDataItem.triggerTransactionId) && Objects.equals((Object)this.errorCode, (Object)tokensForwardingFailDataItem.errorCode) && Objects.equals(this.errorMessage, tokensForwardingFailDataItem.errorMessage);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.blockchain, this.network, this.fromAddress, this.toAddress, this.triggerTransactionId, this.errorCode, this.errorMessage});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TokensForwardingFailDataItem {\n");
        sb.append("    blockchain: ").append(this.toIndentedString(this.blockchain)).append("\n");
        sb.append("    network: ").append(this.toIndentedString(this.network)).append("\n");
        sb.append("    fromAddress: ").append(this.toIndentedString(this.fromAddress)).append("\n");
        sb.append("    toAddress: ").append(this.toIndentedString(this.toAddress)).append("\n");
        sb.append("    triggerTransactionId: ").append(this.toIndentedString(this.triggerTransactionId)).append("\n");
        sb.append("    errorCode: ").append(this.toIndentedString((Object)this.errorCode)).append("\n");
        sb.append("    errorMessage: ").append(this.toIndentedString(this.errorMessage)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum ErrorCodeEnum {
        NOT_ENOUGH_CREDITS("NOT_ENOUGH_CREDITS"),
        FEE_ADDRESS_OUT_OF_FUNDS("FEE_ADDRESS_OUT_OF_FUNDS"),
        WRONG_ADDRESS_CREDENTIALS("WRONG_ADDRESS_CREDENTIALS");

        private String value;

        private ErrorCodeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static ErrorCodeEnum fromValue(String value) {
            for (ErrorCodeEnum b : ErrorCodeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<ErrorCodeEnum> {
            public void write(JsonWriter jsonWriter, ErrorCodeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public ErrorCodeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return ErrorCodeEnum.fromValue(value);
            }
        }
    }
}

