/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Objects;
import org.openapitools.client.model.TokensForwardingSuccessToken;

@ApiModel(description="Defines an `item` as one result.")
public class TokensForwardingSuccessDataItem {
    public static final String SERIALIZED_NAME_BLOCKCHAIN = "blockchain";
    @SerializedName(value="blockchain")
    private String blockchain;
    public static final String SERIALIZED_NAME_NETWORK = "network";
    @SerializedName(value="network")
    private String network;
    public static final String SERIALIZED_NAME_FROM_ADDRESS = "fromAddress";
    @SerializedName(value="fromAddress")
    private String fromAddress;
    public static final String SERIALIZED_NAME_TO_ADDRESS = "toAddress";
    @SerializedName(value="toAddress")
    private String toAddress;
    public static final String SERIALIZED_NAME_SPENT_FEES_AMOUNT = "spentFeesAmount";
    @SerializedName(value="spentFeesAmount")
    private String spentFeesAmount;
    public static final String SERIALIZED_NAME_SPENT_FEES_UNIT = "spentFeesUnit";
    @SerializedName(value="spentFeesUnit")
    private String spentFeesUnit;
    public static final String SERIALIZED_NAME_TRIGGER_TRANSACTION_ID = "triggerTransactionId";
    @SerializedName(value="triggerTransactionId")
    private String triggerTransactionId;
    public static final String SERIALIZED_NAME_FORWARDING_TRANSACTION_ID = "forwardingTransactionId";
    @SerializedName(value="forwardingTransactionId")
    private String forwardingTransactionId;
    public static final String SERIALIZED_NAME_TOKEN_TYPE = "tokenType";
    @SerializedName(value="tokenType")
    private TokenTypeEnum tokenType;
    public static final String SERIALIZED_NAME_TOKEN = "token";
    @SerializedName(value="token")
    private TokensForwardingSuccessToken token;

    public TokensForwardingSuccessDataItem blockchain(String blockchain) {
        this.blockchain = blockchain;
        return this;
    }

    @ApiModelProperty(example="bitcoin", required=true, value="Represents the specific blockchain protocol name, e.g. Ethereum, Bitcoin, etc.")
    public String getBlockchain() {
        return this.blockchain;
    }

    public void setBlockchain(String blockchain) {
        this.blockchain = blockchain;
    }

    public TokensForwardingSuccessDataItem network(String network) {
        this.network = network;
        return this;
    }

    @ApiModelProperty(example="testnet", required=true, value="Represents the name of the blockchain network used; blockchain networks are usually identical as technology and software, but they differ in data, e.g. - \"mainnet\" is the live network with actual data while networks like \"testnet\", \"ropsten\", \"rinkeby\" are test networks.")
    public String getNetwork() {
        return this.network;
    }

    public void setNetwork(String network) {
        this.network = network;
    }

    public TokensForwardingSuccessDataItem fromAddress(String fromAddress) {
        this.fromAddress = fromAddress;
        return this;
    }

    @ApiModelProperty(example="mh8E9c2YDQvn8uRf47Wy4zCv2zHQzcdgkk", required=true, value="Represents the hash of the address that provides the tokens.")
    public String getFromAddress() {
        return this.fromAddress;
    }

    public void setFromAddress(String fromAddress) {
        this.fromAddress = fromAddress;
    }

    public TokensForwardingSuccessDataItem toAddress(String toAddress) {
        this.toAddress = toAddress;
        return this;
    }

    @ApiModelProperty(example="ms4KNsbNpoU8g424pzmEjbkFbfAHae1msB", required=true, value="Represents the hash of the address to forward the tokens to.")
    public String getToAddress() {
        return this.toAddress;
    }

    public void setToAddress(String toAddress) {
        this.toAddress = toAddress;
    }

    public TokensForwardingSuccessDataItem spentFeesAmount(String spentFeesAmount) {
        this.spentFeesAmount = spentFeesAmount;
        return this;
    }

    @ApiModelProperty(example="0.00013601", required=true, value="Represents the amount of the fee spent for the tokens to be forwarded.")
    public String getSpentFeesAmount() {
        return this.spentFeesAmount;
    }

    public void setSpentFeesAmount(String spentFeesAmount) {
        this.spentFeesAmount = spentFeesAmount;
    }

    public TokensForwardingSuccessDataItem spentFeesUnit(String spentFeesUnit) {
        this.spentFeesUnit = spentFeesUnit;
        return this;
    }

    @ApiModelProperty(example="BTC", required=true, value="Represents the unit of the fee spent for the tokens to be forwarded, e.g. BTC.")
    public String getSpentFeesUnit() {
        return this.spentFeesUnit;
    }

    public void setSpentFeesUnit(String spentFeesUnit) {
        this.spentFeesUnit = spentFeesUnit;
    }

    public TokensForwardingSuccessDataItem triggerTransactionId(String triggerTransactionId) {
        this.triggerTransactionId = triggerTransactionId;
        return this;
    }

    @ApiModelProperty(example="6ed1f1c8f2887a78ee8c45a975d928ca63eafc7b63def56324606ddd3cc9854f", required=true, value="Defines the unique Transaction ID that triggered the token forwarding.")
    public String getTriggerTransactionId() {
        return this.triggerTransactionId;
    }

    public void setTriggerTransactionId(String triggerTransactionId) {
        this.triggerTransactionId = triggerTransactionId;
    }

    public TokensForwardingSuccessDataItem forwardingTransactionId(String forwardingTransactionId) {
        this.forwardingTransactionId = forwardingTransactionId;
        return this;
    }

    @ApiModelProperty(example="b15ab5bbaf5107d551ae1b50181f4c55959205c4ff843e3c10d86d00e690fc72", required=true, value="Defines the unique Transaction ID that forwarded the tokens.")
    public String getForwardingTransactionId() {
        return this.forwardingTransactionId;
    }

    public void setForwardingTransactionId(String forwardingTransactionId) {
        this.forwardingTransactionId = forwardingTransactionId;
    }

    public TokensForwardingSuccessDataItem tokenType(TokenTypeEnum tokenType) {
        this.tokenType = tokenType;
        return this;
    }

    @ApiModelProperty(example="omniLayerToken", required=true, value="Defines the type of token sent with the transaction, e.g. ERC 20.")
    public TokenTypeEnum getTokenType() {
        return this.tokenType;
    }

    public void setTokenType(TokenTypeEnum tokenType) {
        this.tokenType = tokenType;
    }

    public TokensForwardingSuccessDataItem token(TokensForwardingSuccessToken token) {
        this.token = token;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public TokensForwardingSuccessToken getToken() {
        return this.token;
    }

    public void setToken(TokensForwardingSuccessToken token) {
        this.token = token;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TokensForwardingSuccessDataItem tokensForwardingSuccessDataItem = (TokensForwardingSuccessDataItem)o;
        return Objects.equals(this.blockchain, tokensForwardingSuccessDataItem.blockchain) && Objects.equals(this.network, tokensForwardingSuccessDataItem.network) && Objects.equals(this.fromAddress, tokensForwardingSuccessDataItem.fromAddress) && Objects.equals(this.toAddress, tokensForwardingSuccessDataItem.toAddress) && Objects.equals(this.spentFeesAmount, tokensForwardingSuccessDataItem.spentFeesAmount) && Objects.equals(this.spentFeesUnit, tokensForwardingSuccessDataItem.spentFeesUnit) && Objects.equals(this.triggerTransactionId, tokensForwardingSuccessDataItem.triggerTransactionId) && Objects.equals(this.forwardingTransactionId, tokensForwardingSuccessDataItem.forwardingTransactionId) && Objects.equals((Object)this.tokenType, (Object)tokensForwardingSuccessDataItem.tokenType) && Objects.equals(this.token, tokensForwardingSuccessDataItem.token);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.blockchain, this.network, this.fromAddress, this.toAddress, this.spentFeesAmount, this.spentFeesUnit, this.triggerTransactionId, this.forwardingTransactionId, this.tokenType, this.token});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TokensForwardingSuccessDataItem {\n");
        sb.append("    blockchain: ").append(this.toIndentedString(this.blockchain)).append("\n");
        sb.append("    network: ").append(this.toIndentedString(this.network)).append("\n");
        sb.append("    fromAddress: ").append(this.toIndentedString(this.fromAddress)).append("\n");
        sb.append("    toAddress: ").append(this.toIndentedString(this.toAddress)).append("\n");
        sb.append("    spentFeesAmount: ").append(this.toIndentedString(this.spentFeesAmount)).append("\n");
        sb.append("    spentFeesUnit: ").append(this.toIndentedString(this.spentFeesUnit)).append("\n");
        sb.append("    triggerTransactionId: ").append(this.toIndentedString(this.triggerTransactionId)).append("\n");
        sb.append("    forwardingTransactionId: ").append(this.toIndentedString(this.forwardingTransactionId)).append("\n");
        sb.append("    tokenType: ").append(this.toIndentedString((Object)this.tokenType)).append("\n");
        sb.append("    token: ").append(this.toIndentedString(this.token)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum TokenTypeEnum {
        ETHEREUMERC20TOKEN("ethereumERC20Token"),
        ETHEREUMERC721TOKEN("ethereumERC721Token"),
        OMNILAYERTOKEN("omniLayerToken");

        private String value;

        private TokenTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static TokenTypeEnum fromValue(String value) {
            for (TokenTypeEnum b : TokenTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<TokenTypeEnum> {
            public void write(JsonWriter jsonWriter, TokenTypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public TokenTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return TokenTypeEnum.fromValue(value);
            }
        }
    }
}

