/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Defines an `item` as one result.")
public class TransactionRequestApprovalDataItem {
    public static final String SERIALIZED_NAME_BLOCKCHAIN = "blockchain";
    @SerializedName(value="blockchain")
    private String blockchain;
    public static final String SERIALIZED_NAME_NETWORK = "network";
    @SerializedName(value="network")
    private String network;
    public static final String SERIALIZED_NAME_REQUIRED_APPROVALS = "requiredApprovals";
    @SerializedName(value="requiredApprovals")
    private Integer requiredApprovals;
    public static final String SERIALIZED_NAME_REQUIRED_REJECTIONS = "requiredRejections";
    @SerializedName(value="requiredRejections")
    private Integer requiredRejections;
    public static final String SERIALIZED_NAME_CURRENT_APPROVALS = "currentApprovals";
    @SerializedName(value="currentApprovals")
    private Integer currentApprovals;
    public static final String SERIALIZED_NAME_CURRENT_REJECTIONS = "currentRejections";
    @SerializedName(value="currentRejections")
    private Integer currentRejections;

    public TransactionRequestApprovalDataItem blockchain(String blockchain) {
        this.blockchain = blockchain;
        return this;
    }

    @ApiModelProperty(example="bitcoin", required=true, value="Represents the specific blockchain protocol name, e.g. Ethereum, Bitcoin, etc.")
    public String getBlockchain() {
        return this.blockchain;
    }

    public void setBlockchain(String blockchain) {
        this.blockchain = blockchain;
    }

    public TransactionRequestApprovalDataItem network(String network) {
        this.network = network;
        return this;
    }

    @ApiModelProperty(example="testnet", required=true, value="Represents the name of the blockchain network used; blockchain networks are usually identical as technology and software, but they differ in data, e.g. - \"mainnet\" is the live network with actual data while networks like \"testnet\", \"ropsten\", \"rinkeby\" are test networks.")
    public String getNetwork() {
        return this.network;
    }

    public void setNetwork(String network) {
        this.network = network;
    }

    public TransactionRequestApprovalDataItem requiredApprovals(Integer requiredApprovals) {
        this.requiredApprovals = requiredApprovals;
        return this;
    }

    @ApiModelProperty(example="2", required=true, value="The required number of approvals needed to approve the transaction.")
    public Integer getRequiredApprovals() {
        return this.requiredApprovals;
    }

    public void setRequiredApprovals(Integer requiredApprovals) {
        this.requiredApprovals = requiredApprovals;
    }

    public TransactionRequestApprovalDataItem requiredRejections(Integer requiredRejections) {
        this.requiredRejections = requiredRejections;
        return this;
    }

    @ApiModelProperty(example="2", required=true, value="The required number of rejections needed to reject the transaction.")
    public Integer getRequiredRejections() {
        return this.requiredRejections;
    }

    public void setRequiredRejections(Integer requiredRejections) {
        this.requiredRejections = requiredRejections;
    }

    public TransactionRequestApprovalDataItem currentApprovals(Integer currentApprovals) {
        this.currentApprovals = currentApprovals;
        return this;
    }

    @ApiModelProperty(example="1", required=true, value="The current number of approvals given for the transaction.")
    public Integer getCurrentApprovals() {
        return this.currentApprovals;
    }

    public void setCurrentApprovals(Integer currentApprovals) {
        this.currentApprovals = currentApprovals;
    }

    public TransactionRequestApprovalDataItem currentRejections(Integer currentRejections) {
        this.currentRejections = currentRejections;
        return this;
    }

    @ApiModelProperty(example="0", required=true, value="The current number of rejections given for the transaction.")
    public Integer getCurrentRejections() {
        return this.currentRejections;
    }

    public void setCurrentRejections(Integer currentRejections) {
        this.currentRejections = currentRejections;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransactionRequestApprovalDataItem transactionRequestApprovalDataItem = (TransactionRequestApprovalDataItem)o;
        return Objects.equals(this.blockchain, transactionRequestApprovalDataItem.blockchain) && Objects.equals(this.network, transactionRequestApprovalDataItem.network) && Objects.equals(this.requiredApprovals, transactionRequestApprovalDataItem.requiredApprovals) && Objects.equals(this.requiredRejections, transactionRequestApprovalDataItem.requiredRejections) && Objects.equals(this.currentApprovals, transactionRequestApprovalDataItem.currentApprovals) && Objects.equals(this.currentRejections, transactionRequestApprovalDataItem.currentRejections);
    }

    public int hashCode() {
        return Objects.hash(this.blockchain, this.network, this.requiredApprovals, this.requiredRejections, this.currentApprovals, this.currentRejections);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TransactionRequestApprovalDataItem {\n");
        sb.append("    blockchain: ").append(this.toIndentedString(this.blockchain)).append("\n");
        sb.append("    network: ").append(this.toIndentedString(this.network)).append("\n");
        sb.append("    requiredApprovals: ").append(this.toIndentedString(this.requiredApprovals)).append("\n");
        sb.append("    requiredRejections: ").append(this.toIndentedString(this.requiredRejections)).append("\n");
        sb.append("    currentApprovals: ").append(this.toIndentedString(this.currentApprovals)).append("\n");
        sb.append("    currentRejections: ").append(this.toIndentedString(this.currentRejections)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

