/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.core.stepexpression;

import io.cucumber.core.backend.ParameterInfo;
import io.cucumber.core.backend.StepDefinition;
import io.cucumber.core.eventbus.EventBus;
import io.cucumber.core.exception.CucumberException;
import io.cucumber.core.stepexpression.DocStringTransformer;
import io.cucumber.core.stepexpression.RawTableTransformer;
import io.cucumber.core.stepexpression.StepExpression;
import io.cucumber.core.stepexpression.StepTypeRegistry;
import io.cucumber.cucumberexpressions.Expression;
import io.cucumber.cucumberexpressions.ExpressionFactory;
import io.cucumber.cucumberexpressions.UndefinedParameterTypeException;
import io.cucumber.datatable.DataTable;
import io.cucumber.datatable.DataTableTypeRegistryTableConverter;
import io.cucumber.docstring.DocString;
import io.cucumber.docstring.DocStringTypeRegistryDocStringConverter;
import io.cucumber.messages.Messages;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;

public final class StepExpressionFactory {
    private final ExpressionFactory expressionFactory;
    private final DataTableTypeRegistryTableConverter tableConverter;
    private final DocStringTypeRegistryDocStringConverter docStringConverter;
    private final EventBus bus;

    public StepExpressionFactory(StepTypeRegistry registry, EventBus bus) {
        this.expressionFactory = new ExpressionFactory(registry.parameterTypeRegistry());
        this.tableConverter = new DataTableTypeRegistryTableConverter(registry.dataTableTypeRegistry());
        this.docStringConverter = new DocStringTypeRegistryDocStringConverter(registry.docStringTypeRegistry());
        this.bus = bus;
    }

    public StepExpression createExpression(StepDefinition stepDefinition) {
        List<ParameterInfo> parameterInfos = stepDefinition.parameterInfos();
        if (parameterInfos.isEmpty()) {
            return this.createExpression(stepDefinition.getPattern(), StepExpressionFactory.stepDefinitionDoesNotTakeAnyParameter(stepDefinition), false);
        }
        ParameterInfo parameterInfo = parameterInfos.get(parameterInfos.size() - 1);
        return this.createExpression(stepDefinition.getPattern(), parameterInfo.getTypeResolver()::resolve, parameterInfo.isTransposed());
    }

    private StepExpression createExpression(String expressionString, Supplier<Type> tableOrDocStringType, boolean transpose) {
        Objects.requireNonNull(expressionString, "expressionString can not be null");
        Objects.requireNonNull(tableOrDocStringType, "tableOrDocStringType can not be null");
        Expression expression = this.crateExpression(expressionString);
        RawTableTransformer<Object> tableTransform = raw -> {
            DataTable dataTable = DataTable.create((List)raw, (DataTable.TableConverter)this.tableConverter);
            Type targetType = (Type)tableOrDocStringType.get();
            return dataTable.convert((Type)(Object.class.equals((Object)targetType) ? DataTable.class : targetType), transpose);
        };
        DocStringTransformer<Object> docStringTransform = (text, contentType) -> {
            DocString docString = DocString.create((String)text, (String)contentType, (DocString.DocStringConverter)this.docStringConverter);
            Type targetType = (Type)tableOrDocStringType.get();
            return docString.convert((Type)(Object.class.equals((Object)targetType) ? DocString.class : targetType));
        };
        return new StepExpression(expression, docStringTransform, tableTransform);
    }

    private Expression crateExpression(String expressionString) {
        Expression expression;
        try {
            expression = this.expressionFactory.createExpression(expressionString);
        }
        catch (UndefinedParameterTypeException e) {
            this.bus.send(Messages.Envelope.newBuilder().setUndefinedParameterType(Messages.UndefinedParameterType.newBuilder().setExpression(expressionString).setName(e.getUndefinedParameterTypeName())).build());
            throw this.registerTypeInConfiguration(expressionString, e);
        }
        return expression;
    }

    private static Supplier<Type> stepDefinitionDoesNotTakeAnyParameter(StepDefinition stepDefinition) {
        return () -> {
            throw new CucumberException(String.format("step definition at %s does not take any parameters", stepDefinition.getLocation()));
        };
    }

    private CucumberException registerTypeInConfiguration(String expressionString, UndefinedParameterTypeException e) {
        return new CucumberException(String.format("Could not create a cucumber expression for '%s'.\nIt appears you did not register a parameter type.", expressionString), e);
    }
}

