package io.dangernoodle.github.repo.setup;

import java.io.IOException;

import io.dangernoodle.github.GithubClient;
import io.dangernoodle.github.repo.setup.settings.GithubRepositorySettings;
import io.dangernoodle.scm.setup.RepositorySetupException;


public class GithubFindOrCreateRepository extends GithubRepositorySetupStep
{
    public GithubFindOrCreateRepository(GithubClient client)
    {
        super(client);
    }

    @Override
    protected void execute(String organization, String repository, GithubRepositorySettings settings) throws RepositorySetupException
    {
        try
        {
            if (repositoryExists(organization, repository))
            {
                logger.info("requested repository [{}] for organization already exists, skipping creation", repository, organization);
            }
            else
            {
                logger.info("creating repository [{}] under organization [{}]", repository, organization);
                client.createRepository(organization, repository, settings);
            }
        }
        catch (IOException e)
        {
            logger.error("failed to create repository [{}] under organization [{}]", repository, organization);
            throw new RepositorySetupException(e, "failed to create repository [%s] in [%s]", repository, organization);
        }
    }

    private boolean repositoryExists(String organization, String repository) throws IOException
    {
        // TODO: this may need some special error handling...
        return (client.getRepository(organization, repository) != null);
    }
}
