package io.dangernoodle.github.repo.setup;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import io.dangernoodle.Project;
import io.dangernoodle.github.GithubClient;
import io.dangernoodle.github.repo.setup.settings.GithubRepositorySettings;
import io.dangernoodle.scm.ScmException;
import io.dangernoodle.scm.setup.RepositorySetupStep;


public abstract class GithubRepositorySetupStep implements RepositorySetupStep
{
    protected GithubClient client;

    protected final Logger logger;

    public GithubRepositorySetupStep(GithubClient client)
    {
        this.client = client;
        this.logger = LoggerFactory.getLogger(getClass());
    }

    @Override
    public void execute(Project project) throws ScmException
    {
        GithubRepositorySettings settings = project.getRepositorySettings();

        String repository = project.getName();
        String organization = settings.getOrganization();

        execute(organization, repository, settings);
    }

    protected abstract void execute(String organization, String repository, GithubRepositorySettings settings) throws ScmException;
}
