package io.dangernoodle.github.repo.setup.settings;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;


public class GithubRepositoryOverrideStore implements GithubRepositorySettings
{
    private final GithubRepositorySettingsStore defaults;
    private final GithubRepositorySettingsStore overrides;

    public GithubRepositoryOverrideStore(GithubRepositorySettingsStore defaults, GithubRepositorySettingsStore overrides)
    {
        this.defaults = settingsOrEmpty(defaults);
        this.overrides = settingsOrEmpty(overrides);
    }

    @Override
    public Collection<String> getCollaborators()
    {
        return merge(defaults.getCollaborators(), overrides.getCollaborators());
    }

    @Override
    public Map<String, Color> getLabels()
    {
        return merge(defaults.getLabels(), overrides.getLabels());
    }

    @Override
    public String getOrganization()
    {
        String organization = overrides.getOrganization();
        if (organization == null)
        {
            organization = defaults.getOrganization();
            if (organization == null)
            {
                throw new IllegalStateException("organization must be specified");
            }
        }

        return organization;
    }

    @Override
    public Map<String, Protection> getProtections()
    {
        Map<String, Protection> defaults = this.defaults.getProtections();
        Map<String, Protection> overrides = this.overrides.getProtections();

        Map<String, Protection> merged = null;

        if (defaults != null && overrides == null)
        {
            merged = defaults;
        }
        else if (defaults == null && overrides != null)
        {
            merged = overrides;
        }
        else if (defaults != null && overrides != null)
        {
            merged = merge(defaults, overrides);
        }

        return merged;
    }

    @Override
    public Map<String, Permission> getTeams()
    {
        return merge(defaults.getTeams(), overrides.getTeams());
    }

    @Override
    public boolean isAutoInit()
    {
        return (overrides.isAutoInit()) ? true : defaults.isAutoInit();
    }

    @Override
    public boolean isClandestine()
    {
        return (overrides.isClandestine()) ? true : defaults.isClandestine();
    }

    private Collection<String> merge(Collection<String> defaults, Collection<String> overrides)
    {
        HashSet<String> merged = new HashSet<>(defaults.size() + overrides.size());

        merged.addAll(defaults);
        merged.addAll(overrides);

        return merged;
    }

    private <V> Map<String, V> merge(Map<String, V> defaults, Map<String, V> overrides)
    {
        Map<String, V> merged = new HashMap<>(defaults.size() + overrides.size());

        merged.putAll(defaults);
        merged.putAll(overrides);

        return merged;
    }

    private GithubRepositorySettingsStore settingsOrEmpty(GithubRepositorySettingsStore preferences)
    {
        return (preferences == null) ? new GithubRepositorySettingsStore() : preferences;
    }
}
