package io.dangernoodle.github.repo.setup.settings;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

import io.dangernoodle.scm.setup.RepositorySettings;


public interface GithubRepositorySettings extends RepositorySettings
{
    Collection<String> getCollaborators();

    Map<String, Color> getLabels();

    String getOrganization();

    Map<String, Protection> getProtections();

    Map<String, Permission> getTeams();

    boolean isAutoInit();

    boolean isClandestine();

    public static class Color
    {
        private final String color;

        private Color(String color)
        {
            this.color = color;
        }

        @Override
        public boolean equals(Object obj)
        {
            if (obj == null || getClass() != obj.getClass())
            {
                return false;
            }

            return Objects.equals(this.color, ((Color) obj).color);
        }

        @Override
        public int hashCode()
        {
            return Objects.hash(color);
        }

        @Override
        public String toString()
        {
            return color;
        }

        public static Color from(String color)
        {
            // TODO: validate color is valid hex as well...
            color = color.startsWith("#") ? color.substring(1) : color;

            return new Color(color);
        }
    }

    public static enum Permission
    {
        admin,
        read,
        write;
    }

    public static class Protection
    {
//        private PushAccess pushAccess;
//
//        private boolean requireAdminReviews;
//
//        private Collection<String> requiredStatusChecks;
//
//        private boolean requireReviews;
//
//        private boolean requireStatusChecksForAdmins;
//
//        private boolean requireUpToDate;

        private Map<String, Object> map;

        Protection(Map<String, Object> map)
        {
            this.map = map;
        }

        @SuppressWarnings("unchecked")
        public PushAccess getPushAccess()
        {
            return new PushAccess((Map<String, Object>) map.getOrDefault("pushAccess", Collections.emptyMap()));
        }

        public Collection<String> getRequiredStatusChecks()
        {
            return toSafeCollection(map.get("requiredStatusChecks"));
        }

        public boolean isRequireAdminReviews()
        {
            return (boolean) map.getOrDefault("requireAdminReviews", Boolean.FALSE);
        }

        public boolean isRequireReviews()
        {
            return (boolean) map.getOrDefault("requireReviews", Boolean.FALSE);
        }

        public boolean isRequireStatusChecksForAdmins()
        {
            return (boolean) map.getOrDefault("requireStatusChecksForAdmins", Boolean.FALSE);
        }

        public boolean isRequireUpToDate()
        {
            return (boolean) map.getOrDefault("requireUpToDate", Boolean.FALSE);
        }

        @SuppressWarnings("unchecked")
        private static Collection<String> toSafeCollection(Object collection)
        {
            return Optional.ofNullable(collection)
                           .map(c -> (Collection<String>) c)
                           .map(Collections::unmodifiableCollection)
                           .orElse(Collections.emptySet());
        }

        public static class PushAccess
        {
            private final Map<String, Object> map;

            private PushAccess(Map<String, Object> map)
            {
                this.map = map;
            }

            public Collection<String> getTeams()
            {
                return toSafeCollection(map.get("teams"));
            }

            public Collection<String> getUsers()
            {
                return toSafeCollection(map.get("users"));
            }
        }
    }
}
