package io.dangernoodle.github.repo.setup.settings;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;


public class GithubRepositorySettingsStore implements GithubRepositorySettings
{
    private boolean autoInit;

    private boolean clandestine;

    private Collection<String> collaborators;

    private Map<String, Color> labels;

    private String organization;

    private Map<String, Map<String, Object>> protections;

    private Map<String, Permission> teams;

    @Override
    public Collection<String> getCollaborators()
    {
        return toSafeCollection(collaborators);
    }

    @Override
    public Map<String, Color> getLabels()
    {
        return toSafeMap(labels);
    }

    @Override
    public String getOrganization()
    {
        return organization;
    }

    @Override
    public Map<String, Protection> getProtections()
    {
        Map<String, Protection> protections = null;
        if (this.protections != null)
        {
            Map<String, Protection> tmp = new HashMap<>(this.protections.size());
            this.protections.forEach((branch, map) -> tmp.put(branch, new Protection(map)));

            protections = tmp;
        }

        return protections;
    }

    @Override
    public Map<String, Permission> getTeams()
    {
        return toSafeMap(teams);
    }

    @Override
    public boolean isAutoInit()
    {
        return autoInit;
    }

    @Override
    public boolean isClandestine()
    {
        return clandestine;
    }

    Map<String, Map<String, Object>> getProtectionMap()
    {
        return protections;
    }

    private Collection<String> toSafeCollection(Collection<String> collection)
    {
        return Optional.ofNullable(collection)
                       .map(Collections::unmodifiableCollection)
                       .orElse(Collections.emptySet());
    }

    private <V> Map<String, V> toSafeMap(Map<String, V> map)
    {
        return Optional.ofNullable(map)
                       .map(Collections::unmodifiableMap)
                       .orElse(Collections.emptyMap());
    }
}
