package io.dangernoodle.github.utils;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializer;

import io.dangernoodle.github.repo.setup.settings.GithubRepositorySettingsStore;
import io.dangernoodle.github.repo.setup.settings.GithubRepositorySettings;
import io.dangernoodle.scm.setup.RepositorySettings;
import io.dangernoodle.utils.GsonTransformer;


public class GithubGsonTransformer extends GsonTransformer
{
    @Override
    protected GsonBuilder createGsonBuilder()
    {
        return new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.IDENTITY)
                                .registerTypeAdapter(RepositorySettings.class, deserializeSettings())
                                .registerTypeAdapter(GithubRepositorySettings.Color.class, deserializeColor());

    }

    private JsonDeserializer<GithubRepositorySettingsStore.Color> deserializeColor()
    {
        return (json, typeOfT, context) -> GithubRepositorySettings.Color.from(json.getAsString());
    }

    private JsonDeserializer<RepositorySettings> deserializeSettings()
    {
        return (json, typeOfT, context) -> {
            return context.deserialize(json.getAsJsonObject(), GithubRepositorySettingsStore.class);
        };
    }
}
