package io.dangernoodle.github.utils;

import java.io.IOException;

import org.kohsuke.github.GHRepository;
import org.kohsuke.github.GHTeam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import io.dangernoodle.github.GithubClient;
import io.dangernoodle.scm.ScmException;


public final class GithubUtilities
{
    private static final Logger logger = LoggerFactory.getLogger(GithubUtilities.class);

    public static GHRepository getRepository(GithubClient client, String organization, String repository) throws ScmException
    {
        try
        {
            return client.getRepository(organization, repository);
        }
        catch (IOException e)
        {
            logger.error("failed to retrieve [{}] for organization [{}]", repository, organization, e);
            throw new ScmException(e, "failed to retrieve [%s] for organization [%s]", repository, organization);
        }
    }

    public static GHTeam getTeam(GithubClient client, String organization, String slug) throws ScmException
    {
        try
        {
            return client.getTeam(organization, slug);
        }
        catch (IOException e)
        {
            logger.error("failed to retrieve team using slug [{}] for organization [{}]", slug, organization, e);
            throw new ScmException(e, "failed to retrieve team using slug [%s] for organization [%s]", slug, organization);
        }
    }
}
